DROP TABLE BLOG_CONFIG;
CREATE TABLE BLOG_CONFIG (
	BLOG_ID smallint not null default 0,
	ADMIN_EMAIL varchar(255) NULL,
	BLOG_TITLE varchar(255) NULL,
	FLAG_HTML_EDITOR_ADMIN smallint not null,
	FLAG_HTML_EDITOR_ALL smallint not null,
	SESSION_IP_SECURITY smallint not null,
	CREATE_ENTRY_FILES smallint not null,
	REQUIRE_LOGIN smallint not null,
	MONITOR_LEVEL smallint not null,
	ENABLE_SUBSCRIPTIONS smallint not null,
	ENABLE_CAPTCHA smallint not null,
	WEBROOT varchar(255) not null,
	DISABLE_COMMENTS smallint not null,
	COMMENT_DISABLE_AGE smallint not null,
	PING_ON_UPDATE text null,
	CSS_OVERRIDE text null,
	primary key (BLOG_ID)
);

DROP TABLE CATEGORIES;
CREATE TABLE CATEGORIES (
  BLOG_ID integer NOT NULL,
  CATEGORY_ID char(35) NOT NULL,
  CATEGORY_TYPE_ID smallint NOT NULL default 0,
  CATEGORY_NAME varchar(100) NULL,
  PRIMARY KEY  (BLOG_ID, CATEGORY_ID)
);

DROP TABLE USERS;
CREATE TABLE USERS (
  BLOG_ID integer NOT NULL,
  USER_ID char(35) not null,
  USER_KEY varchar(35) NULL,
  UNAME varchar(20) NULL,
  PWORD varchar(255) NULL,
  EMAIL varchar(255) NULL,
  WEBSITE varchar(255) null,
  FLAG_ACTIVE smallint not null default 1,
  FLAG_SUPERUSER smallint not null default 0,
  FLAG_CONFIRMED smallint not null default 0,
  FLAG_ADMIN integer not null default 0,
  FLAG_NOTIFY smallint not null default 0,
  PRIMARY KEY  (BLOG_ID, USER_ID),
  UNIQUE (BLOG_ID, EMAIL),
  UNIQUE (BLOG_ID, UNAME)
);

DROP TABLE USER_SESSIONS;
CREATE TABLE USER_SESSIONS (
  BLOG_ID integer NOT NULL,
  SESSION_KEY char(35) NULL,
  USER_ID char(35) not null,
  IP char(15) not null default '0.0.0.0',
  ACCESS_DATE timestamp NULL,
  PRIMARY KEY  (BLOG_ID, SESSION_KEY)
);

DROP TABLE BLOG_ENTRIES;
CREATE TABLE BLOG_ENTRIES (
    BLOG_ID integer NOT NULL,
	ENTRY_ID char(35) not null,
	GALLERY_ID int not null default 0,
	USER_ID char(35) NULL,
	UNAME varchar(20) not null,
	ENTRY_DATE timestamp not null,
	TITLE varchar(255) NULL,
	SUBTITLE varchar(255) NULL,
	ABSTRACT text NULL,
	CONTENT text NULL,
	FLAG_ALLOW_COMMENTS smallint not null default 1,
	COMMENT_DISABLE_AGE smallint not null default 0,
	ENTRY_FILENAME varchar(255) NULL,
	totalComments integer not null,
	primary key (BLOG_ID, ENTRY_ID)
);

DROP TABLE BLOG_COMMENTS;
CREATE TABLE BLOG_COMMENTS
(
    BLOG_ID integer NOT NULL,
	ENTRY_ID char(35) not null,
	COMMENT_ID int not null,
	USER_ID char(35) NULL,
	UNAME varchar(20) not null,
	EMAIL varchar(255) not null,
	WEBSITE varchar(255) not null,
	ENTRY_DATE timestamp not null,
	IP char(15) not null default '0.0.0.0',
	COMMENT_TEXT text not null,
	primary key (BLOG_ID, ENTRY_ID, COMMENT_ID)
);

DROP TABLE BLOG_CATEGORIES;
CREATE TABLE BLOG_CATEGORIES
(
    BLOG_ID integer NOT NULL,
	ENTRY_ID char(35) not null,
	CATEGORY_ID char(35) not null,
	primary key (BLOG_ID, ENTRY_ID, CATEGORY_ID)
);

DROP TABLE BLOG_SUBSCRIPTIONS;
CREATE TABLE BLOG_SUBSCRIPTIONS
(
    BLOG_ID integer NOT NULL,
	ENTRY_ID char(35) not null,
	USER_ID char(35) not null,
	LAST_NOTIFY timestamp null,
	LAST_ACCESS timestamp not null,
	primary key (BLOG_ID, ENTRY_ID, USER_ID)
);

DROP TABLE GALLERIES;
CREATE TABLE GALLERIES (
  BLOG_ID integer not null,
  GALLERY_ID integer NOT NULL,
  CATEGORY_ID char(35) NULL,
  CREATED timestamp not null,
  LAST_UPDATED timestamp null,
  GALLERY_NAME varchar(255) NULL,
  GALLERY_DESC varchar(255) NULL,
  PRIVATE smallint not null default 0,
  PRIMARY KEY  (BLOG_ID, GALLERY_ID)
);

DROP TABLE GALLERY_PHOTOS;
CREATE TABLE GALLERY_PHOTOS (
  BLOG_ID integer not null,
  GALLERY_ID integer NOT NULL,
  PHOTO_ID integer not null,
  FILENAME varchar(255) NULL,
  PHOTO_DESC varchar(255) NULL,
  ORIG_FILENAME varchar(255) NULL,
  THUMB_FILENAME varchar(255) NULL,
  PRIMARY KEY  (BLOG_ID, GALLERY_ID, PHOTO_ID)
);

CREATE OR REPLACE FUNCTION Month(timestamp) RETURNS double precision
    AS 'select extract(month from $1)'
    LANGUAGE SQL
    IMMUTABLE
    RETURNS NULL ON NULL INPUT;

CREATE OR REPLACE FUNCTION Year(timestamp) RETURNS double precision
    AS 'select extract(year from $1)'
    LANGUAGE SQL
    IMMUTABLE
    RETURNS NULL ON NULL INPUT;

CREATE OR REPLACE FUNCTION Concat(varchar, varchar) RETURNS varchar
    AS 'select $1 || $2'
    LANGUAGE SQL
    IMMUTABLE
    RETURNS NULL ON NULL INPUT;
