DROP TABLE BLOG_CONFIG;
CREATE TABLE BLOG_CONFIG (
	BLOG_ID smallint default 0,
	ADMIN_EMAIL varchar(255) default '',
	BLOG_TITLE varchar(255) default '',
	FLAG_HTML_EDITOR_ADMIN smallint not null,
	FLAG_HTML_EDITOR_ALL smallint not null,
	SESSION_IP_SECURITY smallint not null,
	CREATE_ENTRY_FILES smallint not null,
	REQUIRE_LOGIN smallint not null,
	MONITOR_LEVEL smallint not null,
	ENABLE_SUBSCRIPTIONS smallint not null,
	ENABLE_CAPTCHA smallint not null,
	WEBROOT varchar(255) not null,
	DISABLE_COMMENTS smallint not null,
	COMMENT_DISABLE_AGE smallint not null,
	PING_ON_UPDATE clob default '',
	CSS_OVERRIDE clob default '',
	primary key (BLOG_ID)
);

DROP TABLE CATEGORIES;
CREATE TABLE CATEGORIES (
  BLOG_ID integer NOT NULL,
  CATEGORY_ID char(35) NOT NULL,
  CATEGORY_TYPE_ID smallint default 0,
  CATEGORY_NAME varchar(100) default '',
  PRIMARY KEY  (BLOG_ID, CATEGORY_ID)
);

DROP TABLE USERS;
CREATE TABLE USERS (
  BLOG_ID integer NOT NULL,
  USER_ID char(35) not null,
  USER_KEY varchar(35) default '',
  UNAME varchar(20) default '',
  PWORD varchar(255) default '',
  EMAIL varchar(255) default '',
  WEBSITE varchar(255) default '',
  FLAG_ACTIVE smallint default 1,
  FLAG_SUPERUSER smallint default 0,
  FLAG_CONFIRMED smallint default 0,
  FLAG_ADMIN integer default 0,
  FLAG_NOTIFY smallint default 0,
  PRIMARY KEY  (BLOG_ID, USER_ID),
  UNIQUE (BLOG_ID, EMAIL),
  UNIQUE (BLOG_ID, UNAME)
);

DROP TABLE USER_SESSIONS;
CREATE TABLE USER_SESSIONS (
  BLOG_ID integer NOT NULL,
  SESSION_KEY char(35) default '',
  USER_ID char(35) not null,
  IP char(15) default '0.0.0.0',
  ACCESS_DATE timestamp not null,
  PRIMARY KEY  (BLOG_ID, SESSION_KEY)
);

DROP TABLE BLOG_ENTRIES;
CREATE TABLE BLOG_ENTRIES (
    BLOG_ID integer NOT NULL,
	ENTRY_ID char(35) not null,
	GALLERY_ID int default 0,
	USER_ID char(35) default '',
	UNAME varchar(20) not null,
	ENTRY_DATE timestamp not null,
	TITLE varchar(255) default '',
	SUBTITLE varchar(255) default '',
	ABSTRACT clob default '',
	CONTENT clob default '',
	FLAG_ALLOW_COMMENTS smallint default 1,
	COMMENT_DISABLE_AGE smallint not null default 0,
	ENTRY_FILENAME varchar(255) default '',
	totalComments integer not null,
	primary key (BLOG_ID, ENTRY_ID)
);

DROP TABLE BLOG_COMMENTS;
CREATE TABLE BLOG_COMMENTS
(
    BLOG_ID integer NOT NULL,
	ENTRY_ID char(35) not null,
	COMMENT_ID int not null,
	USER_ID char(35) default '',
	UNAME varchar(20) not null,
	EMAIL varchar(255) not null,
	WEBSITE varchar(255) default '',
	ENTRY_DATE timestamp not null,
	IP char(15) default '0.0.0.0',
	COMMENT_TEXT clob not null,
	primary key (BLOG_ID, ENTRY_ID, COMMENT_ID)
);

DROP TABLE BLOG_CATEGORIES;
CREATE TABLE BLOG_CATEGORIES
(
    BLOG_ID integer NOT NULL,
	ENTRY_ID char(35) not null,
	CATEGORY_ID char(35) not null,
	primary key (BLOG_ID, ENTRY_ID, CATEGORY_ID)
);

DROP TABLE BLOG_SUBSCRIPTIONS;
CREATE TABLE BLOG_SUBSCRIPTIONS
(
    BLOG_ID integer NOT NULL,
	ENTRY_ID char(35) not null,
	USER_ID char(35) not null,
	LAST_NOTIFY timestamp null,
	LAST_ACCESS timestamp not null,
	primary key (BLOG_ID, ENTRY_ID, USER_ID)
);

DROP TABLE GALLERIES;
CREATE TABLE GALLERIES (
  BLOG_ID integer not null,
  GALLERY_ID integer NOT NULL,
  CATEGORY_ID char(35) default '',
  CREATED timestamp not null,
  LAST_UPDATED timestamp null,
  GALLERY_NAME varchar(255) default '',
  GALLERY_DESC varchar(255) default '',
  PRIVATE smallint default 0,
  PRIMARY KEY  (BLOG_ID, GALLERY_ID)
);

DROP TABLE GALLERY_PHOTOS;
CREATE TABLE GALLERY_PHOTOS (
  BLOG_ID integer not null,
  GALLERY_ID integer NOT NULL,
  PHOTO_ID integer not null,
  FILENAME varchar(255) default '',
  PHOTO_DESC varchar(255) default '',
  ORIG_FILENAME varchar(255) default '',
  THUMB_FILENAME varchar(255) default '',
  PRIMARY KEY  (BLOG_ID, GALLERY_ID, PHOTO_ID)
);
