<cfsetting enablecfoutputonly="yes">
<cfparam name="mode" default="">
<cfparam name="criteria" default="">
<cfif mode eq "search" and trim(criteria) eq "">
	<cfset mode = "">
</cfif>
<cfif mode eq "archive" or refind("\/[[:digit:]][[:digit:]][[:digit:]][[:digit:]]\/[[:digit:]][[:digit:]]\/",request.path_info) gt 0>
	<cfparam name="month" default="#Month(Now())#">
	<cfparam name="day" default="">
	<cfparam name="year" default="#Year(Now())#">
	<cfif day is "">
		<cfset fromDate = CreateDate(year,month,1)>
		<cfset toDate = CreateDate(year,month,DaysInMonth(fromDate))>
	<cfelse>
		<cfset fromDate = CreateDate(year,month,day)>
		<cfset toDate = fromDate>
	</cfif>
	<cfset getEntries = application.blogcfm.getEntries(variables.blog_id, fromDate,toDate,"", "")>
	<cfset session.showDate = fromDate>
<cfelseif mode eq "cat" and isDefined("category_id") and trim(category_id) neq "">
	<cfset getCategory = application.blogcfm.getCategory(variables.blog_id, category_id)>
	<cfif getCategory.recordCount is 0>
		<cflocation addtoken="no" url="#variables.blogConfig.webRoot#/index.cfm">
	</cfif>
	<cfset getEntries = application.blogcfm.getEntries(variables.blog_id, CreateDate(1900,1,1),Now(),category_id)>
	<cfset showDate = now()>
	<cfset session.showDate = now()>
<cfelseif mode eq "search">
	<cfset getEntries = application.blogcfm.getEntries(variables.blog_id, CreateDate(1900,1,1),Now(),"",criteria)>
	<cfset session.showDate = now()>
<cfelse>
	<cfset maxEntries = 15> <!--- only display this many entries on the index page --->
	<cfset month = month(Now())>
	<cfset day = "">
	<cfset year = Year(Now())>
	<cfset fromDate = CreateDate(year-1,month,1)>
	<cfset toDate = CreateDate(year,month,DaysInMonth(CreateDate(year,month,1)))>
	<cfset getEntries = application.blogcfm.getEntries(variables.blog_id, fromDate,toDate,"","",maxEntries)>
	<cfset session.showDate = Now()>
</cfif>
<cfsetting enablecfoutputonly="no">

<cfinclude template="above.cfm">
<cfif getEntries.RecordCount is 0>
	<div class="message">No entries were found.<br /> No se encontraron</div>
	<cfinclude template="below.cfm">
	<cfabort>
</cfif>
<cfset lastDate = CreateDate(1900,1,1)>

<cfoutput query="getEntries" group="ENTRY_ID">
	<cfset entryLink = application.blogcfm.getEntryLink(variables.blog_id, entry_id)>
	<cfset thisDate = CreateDate(Year(ENTRY_DATE),Month(ENTRY_DATE),Day(ENTRY_DATE))>
	<cfif thisDate neq lastDate>
		<cfset lastDate = thisDate>
		<div class="dateHeader">
			#DateFormat(ENTRY_DATE,'dd mmmm yyyy')#
		</div>
	</cfif>

<div class="entry">
		<div class="title">#TITLE#</div>
		<cfif SUBTITLE neq ""><div class="subtitle">#SUBTITLE#</div></cfif>
		<cfwddx action="WDDX2CFML" input="#catInfo#" output="qryCatInfo">
		<cfif qryCatInfo.recordCount gt 0>
			<div class="category_links">Categories: &nbsp;
			<cfloop query="qryCatInfo">
			<a href="#variables.blogConfig.webRoot#/index.cfm?mode=cat&category_id=#qryCatInfo.CATEGORY_ID#"
			>#qryCatInfo.CATEGORY_NAME#</a>
			</cfloop></div>
		</cfif>
	<div class="entryDisplay">
		<cfif GALLERY_ID neq 0>
			<span class="photoBlogInfo">This is a photo blog,
			<a href="#entryLink#<cfif entryLink contains "?">&<cfelse>?</cfif>showThumbnails=1">click here to view all thumbnails.</a> or <a href="#entryLink###entrytext">click here to view the text of this entry.<br />Cliquea ac&aacute; para ver el texto.</a></span><p></p>
		</cfif>
		<div class="content">
		<cfif Trim(ReplaceNoCase(ABSTRACT,"&nbsp;","","ALL")) neq "">
			#ABSTRACT#
			<div class="continue_link"><a href="#entryLink#">Continue reading <b>#TITLE#</b> ...</a></div>
		<cfelse>
			<cfif Trim(ReplaceNoCase(CONTENT,"&nbsp;","","ALL")) eq ""><i>This entry has no text.<br />No tiene texto</i><cfelse>#CONTENT#</cfif>
		</cfif>
		</div>
		</div>
		<div class="details">
			Posted by #UNAME# at #TimeFormat(ENTRY_DATE,'h:mm tt')# | <a href="#entryLink#">Link</a> | <a href="#entryLink###comments">#totalComments# comment<cfif totalComments neq 1>s</cfif></a>
			<cfif isDefined("variables.userInfo") and variables.userInfo.recordCount gt 0 and variables.userinfo.FLAG_ADMIN is 1>
				<br><a href="#variables.blogConfig.webRoot#/entry.cfm?entry_id=#entry_id#&deleteEntry=#entry_id#">delete</a>
				<a href="#variables.blogConfig.webRoot#/entry_edit.cfm?entry_id=#entry_id#">edit</a>
			</cfif>
		</div>
</div>
</cfoutput>

<cfinclude template="below.cfm">
