<cfset getEntry = application.blogcfm.viewEntry(variables.blog_id, ENTRY_ID)>
<cfif getEntry.errorCode gt 0 or getEntry.entryInfo.recordCount is 0>
	<cflocation addtoken="no" url="#variables.blogConfig.webRoot#/index.cfm">
</cfif>
<!--- ARE COMMENTS ALLOWED? --->
<cfif isDefined("variables.userInfo") AND variables.userInfo.FLAG_ADMIN is 1>
	<cfset variables.commentsAllowed = "Yes">
<cfelseif variables.blogConfig.DISABLE_COMMENTS eq 1>
	<cfset variables.commentsAllowed = "No">
<cfelseif getEntry.entryInfo.FLAG_ALLOW_COMMENTS eq 0>
	<cfset variables.commentsAllowed = "No">
<Cfelseif getEntry.entryInfo.COMMENT_DISABLE_AGE gt 0 AND ABS(DateDiff('d',NOW(),getEntry.entryInfo.ENTRY_DATE)) gt getEntry.entryInfo.COMMENT_DISABLE_AGE>
	<cfset variables.commentsAllowed = "No">
<Cfelseif variables.blogConfig.COMMENT_DISABLE_AGE gt 0 AND ABS(DateDiff('d',NOW(),getEntry.entryInfo.ENTRY_DATE)) gt variables.blogConfig.COMMENT_DISABLE_AGE>
	<cfset variables.commentsAllowed = "No">
<cfelse>
	<cfset variables.commentsAllowed = "Yes">
</cfif>

<cfset entryLink = application.blogcfm.getEntryLink(variables.blog_id, entry_id)>
<cfif isDefined("form.subscribe")>
	<cfset subscribe = form.subscribe>
</cfif>
<cfif isDefined("saveComment")>
	<cfif variables.blogConfig.REQUIRE_LOGIN is 1 and ( not isDefined("variables.userInfo") or variables.userInfo.recordCount is 0)>
		<!--- they tried to post a comment in a login required environment, but they aren't logged in --->
		<cflocation url="#variables.blogConfig.webRoot#/login.cfm?REDIRECT=#urlEncodedFormat(Request.redirect)#">
	</cfif>
	<cfset form.comment_id = "">
	<cfset errorMessage = "">
	<cfparam name="form.WEBSITE" default="">
	<cfset form.WEBSITE = trim(tagStripper(form.WEBSITE,""))>
	<cfset form.comment_text = trim(tagStripper(form.comment_text,"P,BR"))>
	<cfset StructDelete(form,"saveComment")>
	<cfset StructDelete(form,"subscribe")>

	<cfif variables.blogConfig.REQUIRE_LOGIN is 0 and (not isDefined("variables.userInfo") or variables.userInfo.recordCount is 0)>
		<!--- login is not required, and they're not logged in --->
		<cfset form.uname = trim(tagStripper(form.uname,""))>
		<cfset form.email = trim(tagStripper(form.email,""))>
		<cfset form.user_id = 0>
		<cfset form.entry_id = entry_id>
		<cfset form.entry_date = Now()>
		<cfset form.IP = CGI.REMOTE_ADDR>
		<cfif variables.blogConfig.ENABLE_CAPTCHA is 1>
			<cfparam name="form.captchaValue" default="unspecified">
			<cfparam name="session.captchaKey" default="x">
			<cfif hash(trim(ucase(form.captchaValue))) neq session.captchaKey>
				<cfset errorMessage = errorMessage & "<li>Invalid anti-spam key.  Please try again.</li>#Chr(10)#">
			<cfelse>
				<cfset StructDelete(form,"captchaValue")>
			</cfif>
		</cfif>
		<cfif form.comment_text eq "">
			<cfset errorMessage = errorMessage & "<li>You did not enter a comment.</li>#chr(10)#">
		</cfif>
		<cfif trim(uname) eq "">
			<cfset errorMessage = errorMessage & "<li>You did not enter your name.</li>#chr(10)#">
		</cfif>
		<cfif not isEmail(form.email)>
			<cfset errorMessage = errorMessage & "<li>You did not enter a valid email address.</li>#chr(10)#">
		</cfif>
		<cfif form.website neq "" AND refindnocase("^http://",form.WEBSITE) is 0 and refindnocase("^https://",form.WEBSITE) is 0>
			<cfset errorMessage = errorMessage & "<li>The web site address you entered must begin with http:// or https://</li>#Chr(10)#">
		</cfif>
		<cfif errorMessage neq "">
			<cfset errorMessage = "<ul>#errorMessage#</ul>">
		<cfelse>
			<cfset results = application.blogcfm.saveComment(variables.blog_id, form)>
			<cfif results.errorCode is 0>
				<cflocation addtoken="no" url="#entryLink###comment#results.comment_id#">
			</cfif>
		</cfif>
	<cfelse>
		<!--- login is required, and they are logged in --->
		<cfparam name="form.WEBSITE" default="">
		<cfset form.WEBSITE = trim(tagStripper(form.WEBSITE,""))>
		<cfset form.comment_text = trim(tagStripper(form.comment_text,"P,BR"))>
		<cfif not isDefined("variables.userInfo") or variables.userInfo.recordCount is 0>
			<cflocation url="#entryLink#" addtoken="no">
		</cfif>
		<cfset form.user_id = variables.userInfo.user_id>
		<cfset form.uname = variables.userInfo.uname>
		<cfset form.email = variables.userInfo.email>
		<cfset form.entry_id = entry_id>
		<cfset form.entry_date = Now()>
		<cfset form.IP = CGI.REMOTE_ADDR>
		<cfif form.website neq "" AND refindnocase("^http://",form.WEBSITE) is 0 and refindnocase("^https://",form.WEBSITE) is 0>
			<cfset errorMessage = errorMessage & "<li>The web site address you entered must begin with http:// or https://</li>#Chr(10)#">
		</cfif>
		<cfif form.comment_text eq "">
			<cfset errorMessage = errorMessage & "<li>You did not enter a comment.</li>#chr(10)#">
		</cfif>
		<cfif errorMessage neq "">
			<cfset errorMessage = "<ul>#errorMessage#</ul>">
		<cfelse>
			<cfset results = application.blogcfm.saveComment(variables.blog_id, form)>
			<cfif results.errorCode is 0>
				<cfif isDefined("subscribe") and isDefined("variables.userInfo") and variables.userInfo.recordCount gt 0 and variables.blogConfig.ENABLE_SUBSCRIPTIONS eq 1>
					<cfset application.blogcfm.addSubscription(variables.blog_id, variables.userInfo.user_id, entry_id)>
				</cfif>
				<cflocation addtoken="no" url="#entryLink###comment#comment_id#">
			</cfif>
		</cfif>
	</cfif>
<cfelseif isDefined("deleteComment")>
	<cfif isDefined("variables.userInfo") and variables.userInfo.recordCount gt 0 and variables.userinfo.FLAG_ADMIN is 1>
		<cfset results = application.blogcfm.deleteComment(variables.blog_id, entry_id, deleteComment)>
	</cfif>
	<cflocation addtoken="no" url="#entryLink#">
<cfelseif isDefined("deleteEntry")>
	<cfif isDefined("variables.userInfo") and variables.userInfo.recordCount gt 0 and variables.userinfo.FLAG_ADMIN is 1>
		<cfset results = application.blogcfm.deleteEntry(variables.blog_id, deleteEntry)>
		<cflocation addtoken="no" url="#variables.blogConfig.webRoot#/index.cfm">
	</cfif>
<cfelseif isDefined("subscribe") AND variables.blogConfig.ENABLE_SUBSCRIPTIONS eq 1>
	<cfif isDefined("variables.userInfo") and variables.userInfo.recordCount gt 0>
		<cfset application.blogcfm.addSubscription(variables.blog_id, variables.userInfo.user_id,entry_id)>
		<cfset successMessage = "You have been successfully subscribed to this entry.">
	<cfelse>
		<cflocation addtoken="no" url="#variables.blogConfig.webRoot#/login.cfm?redirect=#urlEncodedFormat(request.redirect)#">
	</cfif>
<cfelseif isDefined("unsubscribe")>
	<cfif isDefined("variables.userInfo") and variables.userInfo.recordCount gt 0>
		<cfset application.blogcfm.deleteSubscription(variables.blog_id, variables.userInfo.user_id,entry_id)>
		<cfset successMessage = "You have been successfully unsubscribed from this entry.">
	<cfelse>
		<cflocation addtoken="no" url="#variables.blogConfig.webRoot#/login.cfm?redirect=#urlEncodedFormat(request.redirect)#">
	</cfif>
<cfelseif isDefined("updateSubscription")>
	<!--- link from email notification --->
	<cfif not isDefined("variables.userInfo") or variables.userInfo.recordCount is 0>
		<!--- force login for update subscription --->
		<cflocation addtoken="no" url="#variables.blogConfig.webRoot#/login.cfm?redirect=#urlEncodedFormat(request.redirect)#">
	</cfif>
</cfif>
<cfif isDefined("variables.userInfo") and variables.userInfo.recordCount gt 0>
	<cfset application.blogcfm.updateSubscription(variables.blog_id, variables.userInfo.user_id, entry_id)>
</cfif>
<cfinclude template="/blogcfm/above.cfm">

<cfset lastDate = "">
<cfoutput query="getEntry.entryInfo" group="ENTRY_ID">
	<cfset thisDate = CreateDate(Year(ENTRY_DATE),Month(ENTRY_DATE),Day(ENTRY_DATE))>
	<cfif thisDate neq lastDate>
		<div class="dateHeader">
			#DateFormat(ENTRY_DATE,'dd mmmm yyyy')#
		</div>
	</cfif>
<div class="entry">
		<div class="title">#TITLE#</div>
		<cfif SUBTITLE neq ""><div class="subtitle">#SUBTITLE#</div></cfif>
		<cfif category_id neq "" and category_id neq 0>
			<div class="category_links">Categories: &nbsp; <cfoutput><a href="#variables.blogConfig.webRoot#/index.cfm?mode=cat&category_id=#category_id#">#CATEGORY_NAME#</a> </cfoutput></div>
		</cfif>
<cfif getEntry.entryInfo.GALLERY_ID neq 0 and getEntry.photos.recordCount gt 0 and isDefined("showPhotos")>
	<div class="photoDisplay">
		<span class="photoBlogInfo">This is a photo blog,
		<a href="#entryLink#<cfif entryLink contains "?">&<cfelse>?</cfif>showThumbnails=1">click here to view all thumbnails.</a> or <a href="##entrytext">click here to view the text of this entry.</a><br />
		<a href="#entryLink#<cfif entryLink contains "?">&<cfelse>?</cfif>showThumbnails=1">cliquea ac&aacute; para ver reducidas.</a> o <a href="##entrytext">cliquea ac&aacute; para ver el texto.</a>		</span>
		<p></p>
		<cfset photos = QueryToArrayOfStructures(getEntry.photos)>
		<cfset filename = photos[showphotos]["FILENAME"]>
		<cfset photo_desc = photos[showphotos]["PHOTO_DESC"]>
		<cfif showPhotos is 1><< PREV<cfelse><a href="#entryLink#<cfif entryLink contains "?">&<cfelse>?</cfif>showPhotos=#showPhotos-1#"><< PREV</a></cfif> &nbsp;
		<cfif showPhotos is getEntry.photos.recordCount>NEXT >><cfelse><a href="#entryLink#<cfif entryLink contains "?">&<cfelse>?</cfif>showPhotos=#showPhotos+1#">NEXT >></a></cfif>
		<br>
		<img src="#blogConfig.photoGalleryWebroot#/#gallery_id#/#filename#" alt="#replace(photo_desc,chr(34),"''","ALL")#">
		<br>
		<i>#photo_desc#</i>
	</div>
<cfelseif getEntry.entryInfo.GALLERY_ID neq 0 and getEntry.photos.recordCount gt 0 and not isDefined("showPhotos")>

	<cfset photos = QueryToArrayOfStructures(getEntry.photos)>
	<div class="photoDisplay">
		<span class="photoBlogInfo">This is a photo blog,
		<a href="##entrytext">click here to view the text of this entry.</a></span>
		<table class="thumbnails" align="center">
		<tr>
		<cfloop from="1" to="#ArrayLen(photos)#" index="counter" step="1">
			<cfset thumb_filename = photos[counter]["THUMB_FILENAME"]>
			<cfset photo_desc = photos[counter]["PHOTO_DESC"]>
			<td class="image"><a href="#entryLink#<cfif entryLink contains "?">&<cfelse>?</cfif>showPhotos=#counter#"><img src="#blogConfig.photoGalleryWebroot#/#gallery_id#/#thumb_filename#" border="0"  alt="#replace(photo_desc,chr(34),"''","ALL")#"></a></td>
			<cfif counter MOD 3 is 0></tr><tr></tr></cfif>
		</cfloop>
		
		</table>
	</div>
</cfif>
	<div class="entryDisplay">
		<a name="entrytext"></a>
		<div class="content"><cfif Trim(ReplaceNoCase(CONTENT,"&nbsp;","","ALL")) eq ""><i>This entry has no text.<br />Esta entrada no tiene texto.</i><cfelse>#CONTENT#</cfif></div>	
	</div>

		<div class="details">
			Posted by #UNAME# at #TimeFormat(ENTRY_DATE,'h:mm tt')# | <a href="#entryLink#">Link</a> | <a href="#entryLink###comments">#getEntry.comments.recordCount# comment<cfif getEntry.comments.recordCount neq 1>s</cfif></a>
			<cfif isDefined("variables.userInfo") and variables.userInfo.recordCount gt 0 and variables.userinfo.FLAG_ADMIN is 1>
				<br><a href="#variables.blogConfig.webRoot#/entry.cfm?entry_id=#entry_id#&deleteEntry=#entry_id#">delete</a>
				<a href="#variables.blogConfig.webRoot#/entry_edit.cfm?entry_id=#entry_id#">edit</a>
			</cfif>
		</div>

</cfoutput>

<cfif variables.blogConfig.ENABLE_SUBSCRIPTIONS eq 1>
	<div class="comment_header">Subscription Options - Opciones de suscripci&oacute;n.</div>
	<p>
	<cfif isDefined("variables.userInfo") and variables.userInfo.recordCount gt 0>
		<cfif application.blogcfm.isSubscribed(variables.blog_id, variables.userInfo.user_id,entry_id)>
			You are currently subscribed to this topic.  To unsubscribe, <a href="<cfoutput>#variables.blogConfig.webRoot#/entry.cfm?entry_id=#entry_id#</cfoutput>&unsubscribe=1">click here</A>.<br />Actualmente est&aacute;s suscripto a este t&oacute;pico.  Para desuscribir, <a href="<cfoutput>#variables.blogConfig.webRoot#/entry.cfm?entry_id=#entry_id#</cfoutput>&unsubscribe=1">cliquea ac&aacute;.</A>.

		<cfelse>
			You are currently <b>not</b> subscribed to this topic.  To receive email notification when new comments are added to this entry, <a href="<cfoutput>#variables.blogConfig.webRoot#/entry.cfm?entry_id=#entry_id#</cfoutput>&subscribe=1">click here</a>.<br />
Actualmente <b>no</b> est&aacute;s suscripto a este t&oacute;pico.  Para recibir notificaciones por email de nuevos comentarios, <a href="<cfoutput>#variables.blogConfig.webRoot#/entry.cfm?entry_id=#entry_id#</cfoutput>&subscribe=1">cliquea ac&aacute;</a>.
		</cfif>
	<cfelse>
		You are not logged in, so your subscription status for this entry is unknown.  You can
		<a href="<cfoutput>#variables.blogConfig.webRoot#/login.cfm?REDIRECT=#urlEncodedFormat(entryLink)#</cfoutput>">login or register here</A>.<br />
No est&aacute;s logueado, por lo que no sabemos tu status. Puedes
		<a href="<cfoutput>#variables.blogConfig.webRoot#/login.cfm?REDIRECT=#urlEncodedFormat(entryLink)#</cfoutput>">loguearte o registrarte ac&aacute;</A>.
	</cfif>
	</p>
</cfif>

<div class="comment_header"><a name="comments">Comments - Comentarios</a></div>
<cfif getEntry.comments.recordCount is 0>
	<p><i>No comments found. No se encontraron comentarios</i></p>
<cfelse>
	<cfoutput query="getEntry.comments">
		<a name="comment#comment_id#"></a>
		<div class="comment_subject">Re: #getEntry.entryInfo.TITLE#</div>
		<div class="comment_text">
		#activateUrl(getEntry.comments.COMMENT_TEXT, "","true","true")#
		</div>
		<div class="comment_details">
		Posted by <cfif getEntry.comments.WEBSITE neq ""><a href="#getEntry.comments.WEBSITE#" rel="nofollow" target="_blank">#getEntry.comments.UNAME#</a><cfelse>#getEntry.comments.UNAME#</cfif> on #dateFormat(getEntry.comments.ENTRY_DATE,'mmmm d, yyyy')# at #timeFormat(getEntry.comments.ENTRY_DATE,'h:mm tt')#
		<cfif isDefined("variables.userInfo") and variables.userInfo.recordCount gt 0 and variables.userinfo.FLAG_ADMIN is 1>
		<br><a href="#variables.blogConfig.webRoot#/entry.cfm?entry_id=#entry_id#&deleteComment=#comment_id#">delete</a>
		Posted from #IP#
		</cfif>
		</div>
		<br>
	</cfoutput>
</cfif>
<cfif variables.commentsAllowed>
	<div class="comment_header"><a name="comment_form">Post a Comment. Coment&aacute;.</a></div>
	<cfif variables.blogConfig.DISABLE_COMMENTS eq 1>
		<p><i>Comments are disabled in this blog, but you can still comment because you are an administrator.</i></p>
	<cfelseif getEntry.entryInfo.FLAG_ALLOW_COMMENTS eq 0>
		<p><i>Comments are disabled for this entry, but you can still comment because you are an administrator.</i></p>
	<Cfelseif getEntry.entryInfo.COMMENT_DISABLE_AGE gt 0 AND ABS(DateDiff('d',NOW(),getEntry.entryInfo.ENTRY_DATE)) gt getEntry.entryInfo.COMMENT_DISABLE_AGE>
		<p><i>Comments are disabled for this entry because it is more than <cfoutput>#getEntry.entryInfo.COMMENT_DISABLE_AGE#</cfoutput> days old, but you can still comment because you are an administrator.</i></p>
	<Cfelseif variables.blogConfig.COMMENT_DISABLE_AGE gt 0 AND ABS(DateDiff('d',NOW(),getEntry.entryInfo.ENTRY_DATE)) gt variables.blogConfig.COMMENT_DISABLE_AGE>
		<p><i>Due to this blog's configuration, comments are disabled for this entry because it is more than <cfoutput>#getEntry.entryInfo.COMMENT_DISABLE_AGE#</cfoutput> days old, but you can still comment because you are an administrator.</i></p>
	</cfif>

	<cfif variables.blogConfig.REQUIRE_LOGIN is 1 AND (not isDefined("variables.userInfo") OR variables.userInfo.recordCount is 0)>
		<a href="<Cfoutput>#variables.blogConfig.webRoot#/login.cfm?REDIRECT=#UrlEncodedFormat(Request.REDIRECT)#</CFOUTPUT>">Post a comment. Comentar</a> (login required - debes loguearte)
	<cfelseif variables.blogConfig.REQUIRE_LOGIN is 1 AND isDefined("variables.userInfo") AND variables.userInfo.FLAG_CONFIRMED is 0 AND variables.userInfo.FLAG_ADMIN is 0>
		<H4>Account Not Confirmed - Cuenta no confirmada </H4>
		You have not confirmed your current email address, which is <cfoutput><b>#variables.userInfo.email#</b></cfoutput>.<br />
		No has confirmado to email, que es <cfoutput><b>#variables.userInfo.email#</b></cfoutput>.
		<p>
		When you registered, you should have received a confirmation email with a link to
		confirm your email address.<br />
		Cuando te registraste, debes haber recibido un mail con el link para confirmar.
		<p>
		If you did not receive that email or if you cannot find it, you may 
		<a href="<cfoutput>#blogconfig.webroot#</cfoutput>/login.cfm">request a new  confirmation email</a>.<br />
		Si no lo recibiste o no lo encuentras, requiere una nueva confirmaci&oacute;n 
		<a href="<cfoutput>#blogconfig.webroot#</cfoutput>/login.cfm">ac</a>. 
		<p>
		If your email address is not current, you should change it first by going to
		<a href="<cfoutput>#blogconfig.webroot#</cfoutput>/edit_profile.cfm">My Profile</a>.<br />
		Si tu direcci&oacute;n de mail no est&aacute; actualizada, cambi&aacute;la en 
		<a href="<cfoutput>#blogconfig.webroot#</cfoutput>/edit_profile.cfm">Mi Perfil</a>.
	<cfelse>
		<cfinclude template="messages.cfm">
		<form method="post" action="<cfoutput>#entryLink#</cfoutput>#comment_form" name="frmComment">
		<input type="hidden" name="saveComment" value="1">
		<cfparam name="form.UNAME" default="">
		<cfparam name="form.email" default="">
		<cfif variables.blogConfig.REQUIRE_LOGIN is 0 AND (not isDefined("variables.userInfo") OR variables.userInfo.recordCount is 0)>
			<table>
			<tr>
				<td class="form_key">Name:</td>
				<td>&nbsp;</td>
				<td class="form_data"><input name="UNAME" type="text" size="20" maxlength="20" required="yes" message="You must enter your name." VALUE="<cfoutput>#Replace(FORM.UNAME,Chr(34),'&quot;','all')#</cfoutput>"><span class="required">Required. Nombre requerido</span></td>
			</tr>
			<tr>
				<td class="form_key">Email:</td>
				<td>&nbsp;</td>
				<td class="form_data"><input name="EMAIL" type="text" size="20" maxlength="255" required="yes" message="You must enter your email address." VALUE="<cfoutput>#Replace(FORM.EMAIL,Chr(34),'&quot;','all')#</cfoutput>"><span class="required">Required</span> <I>your email address will not be publicly displayed.</I>&nbsp;No ser&aacute; visible</td>
			</tr>
			</table>
			<br>
			<i>Want to receive notifications when new comments are added?  <a href="<cfoutput>#variables.blogConfig.webRoot#/login.cfm?REDIRECT=#urlEncodedFormat(entryLink)#</cfoutput>">Login/Register</a> for an account.</i><br />
<i>Quieres recibir notificaciones cuando se agregan nuevos comentarios?</i>
			<p>

			<cfif variables.blogConfig.enable_captcha is 1>
				<cftry>
					<cfset captcha = genCaptchaImage(application.blogcfm.captchaImageRoot,application.blogcfm.dirsep)>
					<cfcatch type="Any">
						<!--- ooops --->
						<cfset captcha.key = "">
						<cfset captcha.image = "">
						<cfset captcha.value = "">
					</cfcatch>
				</cftry>
	
				<Cfif captcha.key eq "">
					<i>NOTE:  CAPTCHA key generation failed.  This has been logged in the application error log.</i>
						<cfset session.captchaKey = hash("BROKEN")>
					<input type="hidden" name="captchaValue" value="BROKEN">
				<cfelse>
					Anti-spam key<br>
					<cfset captcha = genCaptchaImage(application.blogcfm.captchaImageRoot,application.blogcfm.dirsep)>
					<img src="<cfoutput>#variables.blogConfig.webRoot#/serveCaptcha.cfm?captchaImage=#captcha.image#</cfoutput>" border=1><br>
					Type in the text that you see in the above image:<input type="text" name="captchaValue" size="6" maxlength="6" required="Yes" MESSAGE="You must complete the anti-spam field.">
					<cfset session.captchaKey = captcha.key>
				</cfif>
				<p>
			</cfif>
		<cfelse>
			Link:  <input type="text" onFocus="select();" size="40" maxlength="255" name="WEBSITE" value="<cfoutput>#Replace(variables.userInfo.WEBSITE,chr(34),'&quot;','all')#</cfoutput>">
			&nbsp;Tipea el texto de la im&aacute;gen.
			<p>
			<input type="checkbox" name="subscribe" value="1" checked>
			Notify me when new comments are posted. Notificarme nuevos comentarios.
			<p>
		</cfif>
		Your comment Tu comentario:<br>
		<textarea name="COMMENT_TEXT" ROWS=5 COLS=60 WRAP="soft"><cfif isDefined("form.comment_text")><cfoutput>#ReplaceNoCase(form.comment_text,"<","&lt;","ALL")#</cfoutput></cfif></textarea>
		<br><i>Sorry, no HTML allowed!. No admite HTML</i>
		<p>
		<input type=submit value=Save>
		</form>
	</cfif>
<cfelse>
		<div class="comment_header"><a name="comment_form">Post a Comment</a>. Comentar. </div>
		<i>Commenting has been disabled for this entry.</i>
</cfif> Los	comentarios no est&aacute;n habilitados para esta entrada..
</div>



    <cfinclude template="/blogcfm/below.cfm">
