<cfcomponent>
<!---
V 1.14
Copyright (c) 2005 WebWorks, LLC.
--->

<cffunction access="public" name="init" output="no" returntype="void">
	<cfargument name="documentRoot" type="string" required="yes">
	<cfargument name="primarydb" type="string" required="yes">
	<cfargument name="mapping" type="string" required="yes">
	<cfargument name="dbtype" type="string" required="no">
	
	<cfset this.documentRoot = arguments.documentRoot>
	<cfif right(this.documentroot,1) eq "/" OR right(this.documentroot,1) eq "\">
		<cfset this.documentRoot = RemoveChars(this.documentRoot,len(this.documentRoot),1)>
	</cfif>

	<cfset this.primarydb = arguments.primarydb>
	<cfset this.mapping = arguments.mapping>
	<cfscript>
	if (FindNoCase("windows",server.os.name))
	{
		this.dirsep = "\";
	} else {
		this.dirsep = "/";
	}
	</cfscript>
	<cfset this.captchaImageRoot  = this.documentRoot & this.dirsep & "captcha">
	<cfset this.VERSION = "1.14">
	<cfset this.captchaFont = this.captchaImageRoot & this.dirSep & "comicbd.ttf">
	<cfset this.shared_user_database = 0>
	<cfquery name="qry" datasource="#this.primarydb#">
		SELECT BLOG_ID FROM BLOG_CONFIG
	</cfquery>
	<cfloop query="qry">
		<cfif not directoryExists(this.documentRoot & this.dirsep & blog_id)>
			<cfdirectory action="CREATE" directory="#this.documentRoot##this.dirsep##blog_id#">
		</cfif>
		<cfif not directoryExists(this.documentRoot & this.dirsep & blog_id & this.dirsep & "custom")>
			<cfdirectory action="CREATE" directory="#this.documentRoot##this.dirsep##blog_id##this.dirsep#custom">
		</cfif>
		<cfif not directoryExists(this.documentRoot & this.dirsep & blog_id & this.dirsep & "photos")>
			<cfdirectory action="CREATE" directory="#this.documentRoot##this.dirsep##blog_id##this.dirsep#photos">
		</cfif>
	</cfloop>
	<cfif isDefined("arguments.dbtype")>
		<cfset this.dbtype = trim(lcase(arguments.dbtype))>
		<cfif this.dbtype eq "access">
			<cfset this.dbfnLower = "lcase">
		<cfelse>
			<cfset this.dbfnLower = "lower">
		</cfif>
	<cfelse>
		<cfset this.dbtype = "mysql">
		<cfset this.dbfnLower = "lower">
	</cfif>
</cffunction>

<cffunction access="public" name="saveCategory" output="No" returntype="struct">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="CATEGORY_ID" type="string" required="yes">
	<cfargument name="CATEGORY_TYPE_ID" type="numeric" required="yes">
	<cfargument name="CATEGORY_NAME" type="string" required="yes">

	<cfset var qry = "">
	<cfset var retval = StructNew()>
	
	<cfset retval.errorCode = 0>
	<cfset retVal.errorMessage = "">
	<cfset retVal.category_id = arguments.category_id>
		
	<cfif arguments.category_id eq "">
		<CFQUERY NAME="qry" DATASOURCE="#this.PRIMARYDB#">
			SELECT CATEGORY_ID FROM CATEGORIES
			WHERE 
				BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
				AND #this.dbfnLower#(CATEGORY_NAME)=<cfqueryparam cfsqltype="cf_sql_varchar" value="#lcase(arguments.category_name)#">
				AND CATEGORY_TYPE_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.category_type_id#">
		</CFQUERY>
		<CFIF qry.RecordCount gt 0>
			<cfset retVal.category_id = qry.category_id>
			<cfreturn retVal>
		<CFELSE>
			<CFSET retVal.CATEGORY_ID = CreateUUID()>
			<CFQUERY NAME="qry" DATASOURCE="#this.PRIMARYDB#">
				INSERT INTO CATEGORIES
				( BLOG_ID, CATEGORY_ID, CATEGORY_TYPE_ID, CATEGORY_NAME )
				VALUES
				( 
					<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">,
					<cfqueryparam cfsqltype="cf_sql_char" value="#retVal.category_id#">,
					<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.category_type_id#">, 
					<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.category_name#"> 
				)
			</CFQUERY>
			<cfreturn retVal>
		</CFIF>
	<cfelse>
		<CFQUERY NAME="qry" DATASOURCE="#this.PRIMARYDB#">
			SELECT * 
			FROM CATEGORIES
			WHERE 
				BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
				AND #this.dbfnLower#(CATEGORY_NAME)=<cfqueryparam cfsqltype="cf_sql_varchar" value="#lcase(arguments.category_name)#">
				AND CATEGORY_TYPE_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.category_type_id#">
				AND CATEGORY_ID <> <cfqueryparam cfsqltype="cf_sql_char" value="#arguments.category_id#">
		</CFQUERY>
		<CFIF qry.RecordCount gt 0>
			<cfset retVal.errorCode = 1>
			<cfset retVal.errorMessage = "The category could not be saved because another category with the same name already exists.">
			<cfreturn retVal>
		<CFELSE>
			<CFQUERY NAME="qry" DATASOURCE="#this.PRIMARYDB#">
				UPDATE CATEGORIES
				SET CATEGORY_NAME=<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.category_name#">
				WHERE 
					BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
					AND CATEGORY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.category_id#">
			</CFQUERY>
			<cfreturn retVal>
		</CFIF>
	</cfif>

</cffunction>

<cffunction access="public" name="getCategory" output="No" returntype="query">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="category_id" type="string" required="yes">
	
	<cfset var qry = "">
	<cfquery name="qry" datasource="#this.primarydb#">
		SELECT * 
		FROM CATEGORIES
		WHERE 
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND CATEGORY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.category_id#">
	</cfquery>
	<cfreturn qry>
</cffunction>

<cffunction access="public" name="listCategories" output="false" returntype="query">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="CATEGORY_TYPE_ID" type="numeric" required="yes">
	<cfargument name="includeUncategorized" type="boolean" required="no" default="true">
	
	<cfset var qry = "">
	<cfset var qry1 = "">
	<cfset var qry2 = "">
	<cfquery name="qry1" datasource="#this.primarydb#">
		SELECT CATEGORY_ID as xCATEGORY_ID, CATEGORY_NAME AS xCATEGORY_NAME
		FROM CATEGORIES
		WHERE 
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND CATEGORY_TYPE_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.category_type_id#">
	</cfquery>
	<cfif NOT includeUncategorized>
		<cfset qry = qry1>
	<cfelse>
		<cfset qry2 = QueryNew("xCATEGORY_ID,xCATEGORY_NAME")>
		<cfset QueryAddRow(qry2,1)>
		<cfset QuerySetCell(qry2,"xCATEGORY_ID","")>
		<cfset QuerySetCell(qry2,"xCATEGORY_NAME","Uncategorized")>
		<cfquery name="qry" dbtype="query">
			select xCATEGORY_ID, xCATEGORY_NAME from qry2
			UNION
			select xCATEGORY_ID, xCATEGORY_NAME
			from qry1
		</cfquery>
	</cfif>
	<cfreturn qry>
</cffunction>


<cffunction access="public" name="deleteCategory" output="No" returntype="struct">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="CATEGORY_ID" type="string" required="yes">
	<cfargument name="NEW_CATEGORY_ID" type="string" required="yes">
	<cfargument name="CATEGORY_TYPE_ID" type="numeric" required="yes">

	<cfset var qry = "">
	<cfset var qry2 = "">
	<cfset var retVal = StructNew()>
	<cfset retVal.errorCode = 0>
	<cfset retVal.errorMessage = "">
	<cfif category_type_id eq 6>
		<cfquery name="qry" datasource="#this.primarydb#">
			update GALLERIES
			set CATEGORY_ID=<cfqueryparam cfsqltype="CF_SQL_CHAR" value="#NEW_CATEGORY_ID#">
			where CATEGORY_ID=<cfqueryparam cfsqltype="CF_SQL_CHAR" value="#CATEGORY_ID#">
		</cfquery>
	<cfelseif category_type_id eq 5>
		<cfif NEW_CATEGORY_ID neq "">
			<cfquery name="qry" datasource="#this.primarydb#">
				SELECT ENTRY_ID FROM BLOG_CATEGORIES
				WHERE 
					BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
					AND CATEGORY_ID=<cfqueryparam cfsqltype="CF_SQL_CHAR" value="#CATEGORY_ID#">
			</cfquery>
			<cfloop query="qry">
				<cftry>
					<cfquery name="qry2" datasource="#this.primarydb#">
						update 
							BLOG_CATEGORIES
						set 
							CATEGORY_ID=<cfqueryparam cfsqltype="CF_SQL_CHAR" value="#NEW_CATEGORY_ID#">
						where
							BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#"> 
							AND ENTRY_ID=<cfqueryparam cfsqltype="CF_SQL_CHAR" value="#qry.ENTRY_ID#">
							AND CATEGORY_ID=<cfqueryparam cfsqltype="CF_SQL_CHAR" value="#CATEGORY_ID#">
					</cfquery>
					<cfcatch type="any">
						<!--- primary key error... the entry is already in the new category, so just delete the other category --->
						<cfquery name="qry2" datasource="#this.primarydb#">
							DELETE FROM BLOG_CATEGORIES
							where 
								BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
								AND ENTRY_ID=<cfqueryparam cfsqltype="CF_SQL_CHAR" value="#qry.ENTRY_ID#">
								AND CATEGORY_ID=<cfqueryparam cfsqltype="CF_SQL_CHAR" value="#CATEGORY_ID#">
						</cfquery>
					</cfcatch>
				</cftry>
			</cfloop>
		<cfelse>
			<cfquery name="qry" datasource="#this.primarydb#">
				DELETE FROM BLOG_CATEGORIES
				where
					BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#"> 
					AND CATEGORY_ID=<cfqueryparam cfsqltype="CF_SQL_CHAR" value="#CATEGORY_ID#">
			</cfquery>
		</cfif>
		<cfquery name="qry" datasource="#this.primarydb#">
			delete from CATEGORIES
			where 
				BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
				AND CATEGORY_ID=<cfqueryparam cfsqltype="CF_SQL_CHAR" value="#CATEGORY_ID#">		
		</cfquery>
	<cfelse>
		<cfset retVal.errorCode = 1>
		<cfset retVal.errorMessage = "The deleteCategory function must be called with a CATEGORY_TYPE_ID=5 or 6.">
	</cfif>
	<cfreturn retVal>
</cffunction>

<cffunction name="authUser" access="public" returnType="Struct" output="no">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="UNAME" type="string" required="yes">
	<cfargument name="PWORD" type="string" required="yes">
	<cfargument name="IP" type="string" required="yes">
	
	<cfset var qry = "">
	<cfset var qry2 = "">
	<cfset var retVal = StructNew()>
	<cfset retVal.errorCode = 0>
	<cfset retVal.errorMessage = "">
	<cfset arguments.UNAME = trim(lcase(arguments.UNAME))>
	<cfset arguments.PWORD = Trim(arguments.PWORD)>
	
	<cfquery name="qry" datasource="#this.primarydb#">
		select * from USERS
		where 
			UNAME=<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.uname#">
			AND BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
	</cfquery>
	<cfif qry.recordCount is 0>
		<cfset retVal.errorCode = 1>
		<cfset retVal.errorMessage = "Invalid username.">
		<cfreturn retVal>
	<cfelseif qry.pword neq Hash(arguments.pword)>
		<cfset retVal.errorCode = 1>
		<cfset retVal.errorMessage = "Invalid password.">
		<cfreturn retVal>
	<cfelseif qry.FLAG_ACTIVE is 0>
		<cfset retVal.errorCode = 1>
		<cfset retVal.errorMessage = "That user account has been deactivated.">
		<cfreturn retVal>
	<cfelse>
		<Cfset retVal.userInfo = qry>
		<cfset retval.session_key = CreateUUID()>
		<cfquery name="qry2" datasource="#this.primarydb#">
			INSERT INTO USER_SESSIONS
			( BLOG_ID, SESSION_KEY, USER_ID, ACCESS_DATE, IP)
			VALUES
			(
				<cfif this.shared_user_database is 0>
					<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">,
				<cfelse>
					<cfqueryparam cfsqltype="cf_sql_integer" value="0">,
				</cfif>
				<cfqueryparam cfsqltype="cf_sql_char" value="#retval.session_key#">,
				<cfqueryparam cfsqltype="cf_sql_char" value="#qry.USER_ID#">,
				#CreateODBCDateTime(Now())#,
				<cfqueryparam cfsqltype="cf_sql_char" value="#IP#">
			)
		</cfquery>
		<cfreturn retVal>
	</cfif>
</cffunction>

<cffunction name="authCookie" access="public" returnType="Struct" output="no">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="session_key" type="string" required="yes">
	<cfargument name="IP" type="string" required="yes">
	
	<cfset var qry = "">
	<cfset var qry2 = "">
	<cfset var retVal = StructNew()>
	<cfset retVal.errorCode = 0>
	<cfset retVal.errorMessage = "">
	
	<cfquery name="qry" datasource="#this.primarydb#">
		select A.*, B.IP
		from USERS A INNER JOIN USER_SESSIONS B ON A.USER_ID=B.USER_ID
		where 
			B.SESSION_KEY=<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.session_key#">
			<cfif this.shared_user_database is 0>
				AND B.BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			</cfif>
	</cfquery>
	<cfif qry.recordCount is 0>
		<cfset retVal.errorCode = 1>
		<cfset retVal.errorMessage = "Invalid session.">
		<cfreturn retVal>
	<cfelseif qry.FLAG_ACTIVE is 0>
		<cfset retVal.errorCode = 1>
		<cfset retVal.errorMessage = "Inactive user account. Cuenta inactiva">
		<cfreturn retVal>
	<cfelseif trim(qry.IP) neq trim(arguments.IP) and getBlogConfigValue(arguments.blog_id, "SESSION_IP_SECURITY") IS 1>
		<cfset retVal.errorCode = 1>
		<cfset retVal.cookie_ip = qry.ip>
		<cfset retVal.cgi_ip = arguments.ip>
		<cfset retVal.errorMessage = "Session IP Security Alert - the session IP address does not match the current IP address.">
		<cfreturn retVal>
	<cfelse>
		<cfquery name="qry2" datasource="#this.primarydb#">
			UPDATE USER_SESSIONS
			SET 
				ACCESS_DATE=#CreateODBCDateTime(Now())#
			WHERE
				SESSION_KEY=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.session_key#">
				<cfif this.shared_user_database is 0>
					AND BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
				</cfif>
		</cfquery>
		<cfset retVal.session_key = arguments.session_key>
		<cfset retVal.userInfo = qry>
		<cfreturn retVal>
	</cfif>
</cffunction>

<cffunction name="createUser" access="public" returnType="Struct" output="no">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="UNAME" type="string" required="yes">
	<cfargument name="PWORD" type="string" required="yes">
	<cfargument name="EMAIL" type="string" required="yes">
	<cfargument name="WEBSITE" type="string" required="yes">
	<cfargument name="FLAG_NOTIFY" type="numeric" required="yes">
	<cfargument name="IP" type="String" required="Yes">
	
	<cfset var qry = "">
	<cfset var retVal = StructNew()>
	<cfset var USER_KEY = CreateUUID()>
	<cfset var USER_ID = CreateUUID()>
	<cfset var session_key = CreateUUID()>
	<cfset var results = "">
	<cfset retVal.errorCode = 0>
	<cfset retVal.errorMessage = "">
	
	<cfquery name="qry" datasource="#this.primarydb#">
		SELECT * FROM USERS
		WHERE 
			UNAME=<cfqueryparam cfsqltype="cf_sql_varchar" value="#trim(lcase(arguments.uname))#">
			<cfif this.shared_user_database is 0>
				AND BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			</cfif>
	</cfquery>
	<cfif qry.recordCount gt 0>
		<cfset retVal.errorCode = 1>
		<cfset retVal.errorMessage = "That username is already in use.">
		<cfreturn retVal>
	</cfif>
	<cfquery name="qry" datasource="#this.primarydb#">
		SELECT * FROM USERS
		WHERE 
			EMAIL=<cfqueryparam cfsqltype="cf_sql_varchar" value="#trim(lcase(arguments.email))#">
			<cfif this.shared_user_database is 0>
				AND BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			</cfif>
	</cfquery>
	<cfif qry.recordCount gt 0>
		<cfset retVal.errorCode = 1>
		<cfset retVal.errorMessage = "An account using that email address already exists.">
		<cfreturn retVal>
	</cfif>
	<cfquery name="qry" datasource="#this.primarydb#">
		INSERT INTO USERS 
		(
			BLOG_ID, 
			USER_ID,
			USER_KEY,
			UNAME,
			PWORD,
			EMAIL,
			WEBSITE,
			FLAG_ACTIVE,
			FLAG_NOTIFY,
			FLAG_CONFIRMED
		) VALUES (
			<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">,
			<cfqueryparam cfsqltype="cf_sql_varchar" value="#USER_ID#">,
			<cfqueryparam cfsqltype="cf_sql_varchar" value="#USER_KEY#">,
			<cfqueryparam cfsqltype="cf_sql_varchar" value="#trim(lcase(UNAME))#">,
			<cfqueryparam cfsqltype="cf_sql_varchar" value="#trim(Hash(PWORD))#">,
			<cfqueryparam cfsqltype="cf_sql_varchar" value="#trim(lcase(EMAIL))#">,
			<cfqueryparam cfsqltype="cf_sql_varchar" value="#trim(WEBSITE)#">,
			1,
			<cfqueryparam cfsqltype="cf_sql_integer" value="#FLAG_NOTIFY#">,
			0
		)
	</cfquery>
	<cfset retval.session_key = CreateUUID()>
	<cfquery name="qry2" datasource="#this.primarydb#">
		INSERT INTO USER_SESSIONS
		( BLOG_ID, SESSION_KEY, USER_ID, ACCESS_DATE, IP)
		VALUES
		(
			<cfif this.shared_user_database is 0>
				<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">,
			<cfelse>
				<cfqueryparam cfsqltype="cf_sql_integer" value="0">,
			</cfif>
			<cfqueryparam cfsqltype="cf_sql_char" value="#retval.session_key#">,
			<cfqueryparam cfsqltype="cf_sql_char" value="#USER_ID#">,
			#CreateODBCDateTime(Now())#,
			<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.IP#">
		)
	</cfquery>
	<cfset results = sendConfirmation(arguments.blog_id, USER_ID)>
	<cfreturn retVal>
</cffunction>

<cffunction name="deleteRegisteredUser" access="public" returnType="boolean" output="no">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="USER_ID" type="string" required="yes">
	
	<cfset var qry = "">
	<cfquery name="qry" datasource="#this.primarydb#">
		delete from USERS
		where 
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND USER_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.USER_ID#">
	</cfquery>
	<cfquery name="qry" datasource="#this.primarydb#">
		delete from USER_SESSIONS
		where 
			USER_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.USER_ID#">
			<cfif this.shared_user_database is 0>
				AND BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			</cfif>
	</cfquery>
	<cfquery name="qry" datasource="#this.primarydb#">
		delete from BLOG_SUBSCRIPTIONS
		where 
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND USER_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.USER_ID#">
	</cfquery>
	<cfreturn true>
</cffunction>

<cffunction name="saveRegisteredUser" access="public" returnType="Struct" output="no">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="details" type="struct" required="yes">
	
	<cfset var qry = "">
	<cfset var retVal = StructNew()>
	<cfset retVal.errorCode = 0>
	<cfset retVal.errorMessage = "">
	
	<cfparam name="arguments.details.USER_ID" default="">
	<cfparam name="arguments.details.USER_KEY" default="">
	<cfset arguments.details = trimElements(arguments.details)>
	
	<cfif len(arguments.details.USER_ID) neq 35 and len(arguments.details.USER_KEY) neq 35>
		<cfset retVal.errorCode = 1>
		<cfset retVal.errorMessage = "Invalid USER ID.">
		<cfreturn retVal>
	</cfif>
	<cfquery name="qry" datasource="#this.primarydb#">
		UPDATE USERS
		SET
			<cfif isDefined("arguments.details.USER_KEY") AND arguments.details.USER_KEY neq "">USER_KEY=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.details.USER_KEY#">,</cfif>
			<cfif isDefined("arguments.details.UNAME")>UNAME=<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.details.UNAME#">,</cfif>
			<cfif isDefined("arguments.details.PWORD")>PWORD=<cfqueryparam cfsqltype="cf_sql_varchar" value="#Hash(arguments.details.PWORD)#">,</cfif>
			<cfif isDefined("arguments.details.EMAIL")>EMAIL=<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.details.EMAIL#">, FLAG_CONFIRMED=0,
			<cfelseif isDefined("arguments.details.FLAG_CONFIRMED")>FLAG_CONFIRMED=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.details.FLAG_CONFIRMED#">,</cfif>
			<cfif isDefined("arguments.details.WEBSITE")>WEBSITE=<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.details.WEBSITE#">,</cfif>
			<cfif isDefined("arguments.details.FLAG_ACTIVE")>FLAG_ACTIVE=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.details.FLAG_ACTIVE#">,</cfif>
			<cfif isDefined("arguments.details.FLAG_SUPERUSER")>FLAG_SUPERUSER=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.details.FLAG_SUPERUSER#">,</cfif>
			<cfif isDefined("arguments.details.FLAG_ADMIN")>FLAG_ADMIN=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.details.FLAG_ADMIN#">,</cfif>
			<cfif isDefined("arguments.details.FLAG_NOTIFY")>FLAG_NOTIFY=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.details.FLAG_NOTIFY#">,</cfif>
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
		WHERE
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			<cfif len(arguments.details.user_id) eq 35>
				AND USER_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.details.USER_ID#">
			<cfelse>
				AND USER_KEY=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.details.USER_KEY#">
			</cfif>
	</cfquery>
	<cfif isDefined("arguments.details.EMAIL")>
		<cfset sendConfirmation(arguments.blog_id, arguments.details.USER_ID)>
	</cfif>
	<cfreturn retVal>
	
</cffunction>


<cffunction name="getRegisteredUser" access="public" returnType="Struct" output="no">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="USER_ID" type="string" required="yes">
	
	<cfset var qry = "">
	<cfset var retVal = StructNew()>
	<cfset retVal.errorCode = 0>
	<cfset retVal.errorMessage = "">

	<cfquery name="qry" datasource="#this.primarydb#">
		select *, '' AS SESSION_KEY
		 from USERS
		where 
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND USER_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.USER_ID#">
	</cfquery>
	<cfif qry.recordCount IS 0>
		<cfset retVal.errorCode = 1>
		<cfset retVal.errorMessage = "Invalid USER ID.">
		<cfreturn retVal>
	<cfelse>
		<cfset retVal.session_key = qry.session_key>
		<cfset retVal.userInfo = qry>
		<cfreturn retVal>
	</cfif>
</cffunction>

<cffunction name="getRegisteredUserByKey" access="public" returnType="Struct" output="no">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="USER_KEY" type="string" required="yes">
	
	<cfset var qry = "">
	<cfset var retVal = StructNew()>
	<cfset retVal.errorCode = 0>
	<cfset retVal.errorMessage = "">

	<cfquery name="qry" datasource="#this.primarydb#">
		select USERS.*, '' AS SESSION_KEY
		 from USERS
		where 
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND USER_KEY=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.USER_KEY#">
	</cfquery>
	<cfif qry.recordCount IS 0>
		<cfset retVal.errorCode = 1>
		<cfset retVal.errorMessage = "Invalid USER KEY.">
		<cfreturn retVal>
	<cfelse>
		<cfset retVal.session_key = qry.session_key>
		<cfset retVal.userInfo = qry>
		<cfreturn retVal>
	</cfif>
</cffunction>

<cffunction name="retrievePassword" access="public" returnType="Struct" output="no">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="EMAIL" type="string" required="yes">
	
	<cfset var qry = "">
	<cfset var retVal = StructNew()>
	<cfset retVal.errorCode = 0>
	<cfset retVal.errorMessage = "">
	
	<cfquery name="qry" datasource="#this.primarydb#">
		SELECT * FROM USERS
		WHERE 
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND EMAIL = <cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.EMAIL#">
	</cfquery>
	<cfif qry.recordCount is 0>
		<cfset retVal.errorCode = 1>
		<cfset retVal.errorMessage = "No account matching that email address - #arguments.email# - was found in our database.">
		<cfreturn retVal>
	<cfelse>
<cfmail  bcc="polo@daxnet.com" from="#getBlogConfigValue(arguments.blog_id, "ADMIN_EMAIL")#" TO="#qry.email#"  server="mail.daxnet.com " failto="polo@daxnet.com" username="admin@daxnet.com"  password="iguano08" replyto="admin@iguanapolo.com"  charset="iso-8859-1" SUBJECT="Password Reset">
Dear #qry.uname#:

A password reset request has been received at #getBlogConfigValue(arguments.blog_id, "BLOG_TITLE")#
Nos has solicitado resetear la contrasea.
Your username:  #qry.uname#  (Tu nombre de usuario)

You may reset your password using the following URL:
Puedes resetear tu contrase&ntilde;a usando el link siguiente:
#getBlogConfigValue(arguments.blog_id,"WEBROOT")#/password_reset.cfm?K=#qry.USER_KEY#

Thank you. Gracias
IguanaPolo Admin
</cfmail>
		<cfreturn retVal>
	</cfif>
</cffunction>

<cffunction name="sendConfirmation" access="public" returnType="Struct" output="no">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="USER_ID" type="string" required="yes">
	<cfargument name="EMAIL" type="string" required="no">
	
	<cfset var qry = "">
	<cfset var retVal = StructNew()>
	<cfset retVal.errorCode = 0>
	<cfset retVal.errorMessage = "">
	
	<cfquery name="qry" datasource="#this.primarydb#">
		SELECT * FROM USERS
		WHERE 
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			<cfif isDefined("arguments.email") and trim(arguments.email) neq "">
				AND #this.dbfnLower#(EMAIL) = <cfqueryparam cfsqltype="cf_sql_varchar" value="#trim(lcase(arguments.email))#">
			<cfelse>
				AND USER_ID = <cfqueryparam cfsqltype="cf_sql_char" value="#arguments.USER_ID#">
			</cfif>
	</cfquery>
	<cfif qry.recordCount is 0>
		<cfset retVal.errorCode = 1>
		<cfif isDefined("arguments.email") and trim(arguments.email) neq "">
			<cfset retVal.errorMessage = "Sorry, but that email address as not found in the user database.">
		<cfelse>
			<cfset retVal.errorMessage = "Invalid User ID.">
		</cfif>
		<cfreturn retVal>
	<cfelse>
	
		<cfmail  bcc="polo@daxnet.com" from="#getBlogConfigValue(arguments.blog_id, "ADMIN_EMAIL")#" TO="#qry.email#"  server="mail.daxnet.com " failto="polo@daxnet.com" username="admin@daxnet.com"  password="iguano08" replyto="admin@iguanapolo.com"  charset="iso-8859-1" SUBJECT="Please confirm your account. Confirma tu acceso">		
Dear #qry.uname#,
Please confirm your account with "#getBlogConfigValue(arguments.blog_id, "BLOG_TITLE")#" by clicking on the following link.  You will not be able to post comments or receive email notifications until you confirm your account.
Por favor confirma tu cuenta en "#getBlogConfigValue(arguments.blog_id, "BLOG_TITLE")#" cliqueando el siguiente link. No podrs postear comentarios ni recibir notificaciones antes de confirmar.
Your username:  #qry.uname#   (Tu nombre de usuario)
Your email address:  #qry.EMAIL#  (Tu email)

#getBlogConfigValue(arguments.blog_id,"WEBROOT")#/confirm_account.cfm?K=#qry.USER_KEY#

Thank you. Gracias.
IguanaPolo Admin.
</cfmail>
		<cfreturn retVal>
	</cfif>
</cffunction>

<cffunction name="listRegisteredUsers" access="public" output="no" returnType="query">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="SEARCH_UNAME" required="yes" type="string">
	<cfargument name="SEARCH_EMAIL" required="yes" type="string">

	<cfset var qry = "">
	
	<cfset SEARCH_UNAME = Replace(SEARCH_UNAME,"*","%","ALL")>
	<cfset SEARCH_EMAIL = Replace(SEARCH_EMAIL,"*","%","ALL")>
	
	<cfquery name="qry" datasource="#this.primarydb#">
		SELECT *
		FROM USERS
		WHERE
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
		<cfif SEARCH_UNAME neq "" OR SEARCH_EMAIL neq "">
			AND (
				1 = 0
				<cfif SEARCH_UNAME neq "">
					 OR #this.dbfnLower#(UNAME) LIKE <cfqueryparam cfsqltype="cf_sql_char" value="#lcase(SEARCH_UNAME)#">
				</cfif>
				<cfif SEARCH_EMAIL neq "">
					 OR #this.dbfnLower#(EMAIL) LIKE <cfqueryparam cfsqltype="cf_sql_char" value="#lcase(SEARCH_EMAIL)#">
				</cfif>
				)
		</cfif>
	</cfquery>
	<cfreturn qry>
</cffunction>

<cffunction access="public" name="getBlogConfig" output="no" returntype="query">
	<cfargument name="BLOG_ID" type="numeric" required="yes">

	<cfset var qry = "">
	<cfset var photoGalleryRoot = this.documentRoot & this.dirSep & arguments.blog_id & this.dirSep & "photos">

	<cfquery name="qry" datasource="#this.primarydb#">
		SELECT 
			BLOG_ID,ADMIN_EMAIL,BLOG_TITLE,FLAG_HTML_EDITOR_ADMIN,FLAG_HTML_EDITOR_ALL,SESSION_IP_SECURITY,CREATE_ENTRY_FILES,REQUIRE_LOGIN,MONITOR_LEVEL,ENABLE_SUBSCRIPTIONS,ENABLE_CAPTCHA,WEBROOT,DISABLE_COMMENTS,COMMENT_DISABLE_AGE,PING_ON_UPDATE,CSS_OVERRIDE,
			'#replace(photoGalleryRoot,"\", "\\","ALL")#' as photoGalleryRoot,
			<cfif this.dbtype eq "access" or this.dbtype eq "mssql">
				webroot + '/#arguments.blog_id#/photos' as photoGalleryWebroot
			<cfelse>
				CONCAT(webroot,'/#arguments.blog_id#/photos') as photoGalleryWebroot
			</cfif>
		FROM BLOG_CONFIG
		WHERE BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
	</cfquery>
	<cfreturn qry>
</cffunction>

<cffunction access="private" name="getBlogConfigValue" output="No" returntype="any">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="key" type="string" required="yes">
	
	<cfset var qry = "">
	<cfset var photoGalleryRoot = this.documentRoot & this.dirSep & arguments.blog_id & this.dirSep & "photos">

	<cfset arguments.key = ucase(arguments.key)>
	<cfif arguments.key eq "PHOTOGALLERYROOT" OR arguments.key eq "PHOTOGALLERYWEBROOT">
		<cfreturn evaluate(arguments.key)>
	<cfelseif arguments.key eq "PHOTOGALLERYWEBROOT">
		<cfquery name="qry" datasource="#this.primarydb#">
			SELECT 
				<cfif this.dbtype eq "access" or this.dbtype eq "mssql">
					webroot + '/#arguments.blog_id#/photos' as RESULT
				<cfelse>
					CONCAT(webroot,'/#arguments.blog_id#/photos') as RESULT
				</cfif>
			FROM BLOG_CONFIG
			WHERE BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
		</cfquery>
		<cfreturn qry.result>
	<cfelse>
		<cftry>
			<cfquery name="qry" datasource="#this.primarydb#">
				SELECT #key# AS RESULT
				FROM BLOG_CONFIG
				WHERE BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			</cfquery>
			<cfcatch type="any">
				<cfreturn "">
			</cfcatch>
		</cftry>	
		<cfreturn qry.RESULT>
	</cfif>
</cffunction>

<cffunction  access="public" name="saveBlogConfig" output="No" returntype="boolean">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="details" type="struct" required="yes">
	
	<cfset var qry = "">

	<cfquery name="qry" datasource="#this.primarydb#">
		UPDATE BLOG_CONFIG
		SET
			ADMIN_EMAIL=<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.details.admin_email#">,
			BLOG_TITLE=<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.details.blog_title#">,
			FLAG_HTML_EDITOR_ADMIN=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.details.FLAG_HTML_EDITOR_ADMIN#">,
			SESSION_IP_SECURITY=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.details.SESSION_IP_SECURITY#">,
			REQUIRE_LOGIN=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.details.REQUIRE_LOGIN#">,
			MONITOR_LEVEL=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.details.MONITOR_LEVEL#">,
			ENABLE_SUBSCRIPTIONS=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.details.ENABLE_SUBSCRIPTIONS#">,
			ENABLE_CAPTCHA=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.details.ENABLE_CAPTCHA#">,
			DISABLE_COMMENTS=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.details.DISABLE_COMMENTS#">,
			COMMENT_DISABLE_AGE=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.details.COMMENT_DISABLE_AGE#">,
			PING_ON_UPDATE=<cfqueryparam cfsqltype="cf_sql_longvarchar" value="#arguments.details.PING_ON_UPDATE#">,
			CSS_OVERRIDE=<cfqueryparam cfsqltype="cf_sql_longvarchar" value="#arguments.details.CSS_OVERRIDE#">
		WHERE
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
	</cfquery>
	<cfreturn true>
</cffunction>


<cffunction  access="public" name="saveEntry" output="no" returntype="Struct">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="details" type="struct" required="yes">
	<cfargument name="FIELDNAMES" type="string" required="no" default="">

	<cfset var form = details>
	<cfset var entryFile = "">
	<cfset var NEW_CATEGORY = details.NEW_CATEGORY>
	<cfset var CATEGORY_ID = details.CATEGORY_ID>
	<cfset var results = "">
	<cfset var cat_id = "">
	<Cfset var cat_name = "">
	<cfset var retVal = StructNew()>
	<cfset retVal.errorCode = 0>
	<cfset retVal.errorMessage = "">

	<cfif isDefined("arguments.details.COMMENT_DISABLE_AGE") AND not isNumeric(arguments.details.COMMENT_DISABLE_AGE)>
		<cfset arguments.details.COMMENT_DISABLE_AGE = 0>
	</cfif>
	<cfif details.entry_id is "">
		<cfparam name="arguments.details.gallery_id" default="0">
		<cfset retVal.ENTRY_ID = CreateUUID()>
		<cfquery name="qry" datasource="#this.primarydb#">
			INSERT INTO BLOG_ENTRIES
			(
				BLOG_ID,
				ENTRY_ID,
				GALLERY_ID,
				USER_ID,
				UNAME,
				ENTRY_DATE,
				TITLE,
				SUBTITLE,
				ABSTRACT,
				CONTENT,
				FLAG_ALLOW_COMMENTS,
				COMMENT_DISABLE_AGE,
				ENTRY_FILENAME,
				totalComments
			) VALUES (
				<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.BLOG_ID#">,
				<cfqueryparam cfsqltype="cf_sql_char" value="#retVal.ENTRY_ID#">,
				<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.details.GALLERY_ID#">,
				<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.details.USER_ID#">,
				<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.details.UNAME#">,
				#CreateODBCDateTime(arguments.details.entry_date)#,
				<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.details.TITLE#">,
				<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.details.SUBTITLE#">,
				<cfqueryparam cfsqltype="CF_SQL_LONGVARCHAR" value="#arguments.details.ABSTRACT#">,
				<cfqueryparam cfsqltype="CF_SQL_LONGVARCHAR" value="#arguments.details.CONTENT#">,
				<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.details.FLAG_ALLOW_COMMENTS#">,
				<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.details.COMMENT_DISABLE_AGE#">,
				<cfqueryparam cfsqltype="cf_sql_char" value=" ">,
				0
			)
		</cfquery>
		<cfif getBlogConfigValue(arguments.blog_id, "CREATE_ENTRY_FILES") is 1>
			<cfset makeEntryLink(arguments.blog_id, retVal.entry_id)>
		</cfif>
	<cfelse>
		<cfquery name="qry" datasource="#this.primarydb#">
			UPDATE BLOG_ENTRIES
			SET
				<cfif isDefined("arguments.details.GALLERY_ID")>GALLERY_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.details.gallery_id#">,</cfif>
				<cfif isDefined("arguments.details.USER_ID")>USER_ID=<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.details.USER_ID#">,</cfif>
				<cfif isDefined("arguments.details.UNAME")>UNAME=<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.details.UNAME#">,</cfif>
				<cfif isDefined("arguments.details.TITLE")>TITLE=<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.details.TITLE#">,</cfif>
				<cfif isDefined("arguments.details.SUBTITLE")>SUBTITLE=<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.details.SUBTITLE#">,</cfif>
				<cfif isDefined("arguments.details.ENTRY_DATE")>ENTRY_DATE=#CreateODBCDateTime(arguments.details.ENTRY_DATE)#,</cfif>
				<cfif isDefined("arguments.details.ABSTRACT")>ABSTRACT=<cfqueryparam cfsqltype="cf_sql_longvarchar" value="#arguments.details.ABSTRACT#">,</cfif>
				<cfif isDefined("arguments.details.CONTENT")>CONTENT=<cfqueryparam cfsqltype="cf_sql_longvarchar" value="#arguments.details.CONTENT#">,</cfif>
				<cfif isDefined("arguments.details.FLAG_ALLOW_COMMENTS")>FLAG_ALLOW_COMMENTS=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.details.FLAG_ALLOW_COMMENTS#">,</cfif>
				<cfif isDefined("arguments.details.COMMENT_DISABLE_AGE")>COMMENT_DISABLE_AGE=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.details.COMMENT_DISABLE_AGE#">,</cfif>
				<cfif isDefined("arguments.details.ENTRY_FILENAME")>ENTRY_FILENAME=<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.details.ENTRY_FILENAME#">,</cfif>
				BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			WHERE
				BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
				AND ENTRY_ID=<cfqueryparam cfsqltype="CF_SQL_CHAR" value="#arguments.details.ENTRY_ID#">
		</cfquery>
		<cfset retVal.ENTRY_ID = arguments.details.entry_id>
		<!--- if we create entry files AND the entry file doesn't exist --->
		<cfif getBlogConfigValue(arguments.blog_id, "CREATE_ENTRY_FILES") is 1 AND getEntryLink(arguments.blog_id, arguments.details.entry_id) CONTAINS arguments.details.entry_id>
			<cfset makeEntryLink(arguments.blog_id, retVal.entry_id)>
		</cfif>
	</cfif>
	<cfif NEW_CATEGORY neq "">
		<cfloop list="#NEW_CATEGORY#" index="cat_name">
			<cfset results = saveCategory(arguments.blog_id, "", 5, cat_name)>
			<cfset CATEGORY_ID = ListAppend(CATEGORY_ID,results.category_id)>
		</cfloop>
	</cfif>
	<cfquery name="qry" datasource="#This.primarydb#">
		DELETE FROM BLOG_CATEGORIES
		WHERE
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#retVal.ENTRY_ID#">
	</cfquery>
	<cfif listLen(CATEGORY_ID) gt 0>
		<cfloop list="#CATEGORY_ID#" INDEX="cat_id">
			<cfquery name="qry" datasource="#This.primarydb#">
				INSERT INTO BLOG_CATEGORIES 
				( BLOG_ID, ENTRY_ID, CATEGORY_ID )
				VALUES 
				(
					<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">,
					<cfqueryparam cfsqltype="cf_sql_char" value="#retVal.ENTRY_ID#">,
					<cfqueryparam cfsqltype="cf_sql_char" value="#cat_id#">
				)
			</cfquery>
		</cfloop>
	</cfif>
	<cfif arguments.details.entry_id is "">
		<cfquery name="qry" datasource="#this.primarydb#">
			select USER_ID, EMAIL
			FROM USERS
			WHERE 
				BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
				AND FLAG_NOTIFY=1
				AND #this.dbfnLower#(EMAIL) <> <cfqueryparam cfsqltype="cf_sql_varchar" value="#getBlogConfigValue(arguments.blog_id, "ADMIN_EMAIL")#">
				AND USER_ID <> <cfqueryparam cfsqltype="cf_sql_char" value="arguments.details.user_id">
		</cfquery>
		<cfloop query="qry">
			<cfset sendNotification(arguments.blog_id, 'entry','global',retVal.entry_id,0,qry.user_id,qry.email)>
		</cfloop>
		<cfset sendNotification(arguments.blog_id, 'entry','admin',retVal.entry_id,0,0, getBlogConfigValue(arguments.blog_id, "ADMIN_EMAIL"))>
	</cfif>
	<cfif getBlogConfigValue(arguments.blog_id, "PING_ON_UPDATE") neq "">
		<cfset SendPings(getBlogConfigValue(arguments.blog_id, "PING_ON_UPDATE"))>
	</cfif>
	<cfreturn retVal>
	
</cffunction>

<cffunction  access="public" name="saveComment" output="yes" returntype="Struct">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="details" type="struct" required="yes">
	<cfargument name="FIELDNAMES" type="string" required="no" default="">

	<cfset var form = details>
	<cfset var retVal = StructNew()>
	<cfset retVal.errorCode = 0>
	<cfset retVal.errorMessage = "">
	
	<cfif arguments.details.comment_id is "">
		<cfparam name="arguments.details.USER_ID" default="">
		<cfparam name="arguments.details.UNAME" default="">
		<cfparam name="arguments.details.WEBSITE" default="">
		<cfparam name="arguments.details.EMAIL" default="">
		<cfparam name="arguments.details.IP" default="0.0.0.0">
		<cfquery name="qry" datasource="#this.primarydb#">
			select max(COMMENT_ID) AS MAX_COMMENT_ID
			FROM BLOG_COMMENTS
			WHERE
				BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#"> 
				AND ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.details.ENTRY_id#"> 
		</cfquery>
		<cfif qry.recordCount is 0 or not isNumeric(qry.MAX_COMMENT_ID)>
			<cfset retval.COMMENT_ID = 1>
		<cfelse>
			<cfset retval.COMMENT_ID = qry.MAX_COMMENT_ID + 1>
		</cfif>
		<cfquery name="qry" datasource="#this.primarydb#">
			INSERT INTO BLOG_COMMENTS
			(
				BLOG_ID,
				ENTRY_ID,
				COMMENT_ID,
				USER_ID,
				UNAME,
				EMAIL,
				WEBSITE,
				ENTRY_DATE,
				IP,
				COMMENT_TEXT
			) VALUES (
				<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.BLOG_ID#">,
				<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.details.ENTRY_ID#">,
				<cfqueryparam cfsqltype="cf_sql_integer" value="#retVal.COMMENT_ID#">,
				<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.details.USER_ID#">,
				<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.details.UNAME#">,
				<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.details.EMAIL#">,
				<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.details.WEBSITE#">,
				#CreateODBCDateTime(Now())#,
				<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.details.IP#">,
				<cfqueryparam cfsqltype="cf_sql_longvarchar" value="#arguments.details.COMMENT_TEXT#">
			)
		</cfquery>
		<cfquery name="qry" datasource="#this.primarydb#">
			UPDATE BLOG_ENTRIES
			SET totalComments = totalComments + 1
			WHERE
				BLOG_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.BLOG_ID#">
				AND ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.details.ENTRY_ID#">
		</cfquery>

		<!--- send subscription updates --->
		<cfquery name="qry" datasource="#this.primarydb#">
			SELECT A.EMAIL, A.USER_ID
			FROM
				USERS A INNER JOIN BLOG_SUBSCRIPTIONS B on A.USER_ID=B.USER_ID AND A.BLOG_ID=B.BLOG_ID
			WHERE
				A.BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#"> 
				AND B.USER_ID <> <cfqueryparam cfsqltype="cf_sql_char" value="#arguments.details.user_id#">
				AND #this.dbfnLower#(A.EMAIL) <> <cfqueryparam cfsqltype="cf_sql_varchar" value="#getBlogConfigValue(arguments.blog_id, "ADMIN_EMAIL")#">
				AND B.ENTRY_ID = <cfqueryparam cfsqltype="cf_sql_char" value="#arguments.details.entry_id#">
				AND A.FLAG_CONFIRMED = 1
				AND B.LAST_NOTIFY < B.LAST_ACCESS
		</cfquery>
		<cfloop query="qry">
			<cfset sendNotification(arguments.blog_id, 'comment','subscribe',arguments.details.entry_id,retval.comment_id,qry.user_id,qry.email)>
		</cfloop>
		<cfif getBlogConfigValue(arguments.blog_id, "MONITOR_LEVEL") IS 1>
			<cfset sendNotification(arguments.blog_id, 'comment','admin',arguments.details.entry_id,retval.comment_id,0, getBlogConfigValue(arguments.blog_id, "ADMIN_EMAIL"),arguments.details.comment_text)>
		</cfif>
	<cfelse>
		<!--- editing of comments is not yet supported --->
	</cfif>
	<cfreturn retVal>
	
</cffunction>

<cffunction name="deleteEntry" access="public" returnType="boolean" output="no">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="ENTRY_ID" type="string" required="yes">
	
	<cfset var qry = "">
	<cfset var entryFilePath = "">
	<cfset var entryFileName = "">
	<cfset var entryFileLink = "">
	<cfquery name="qry" datasource="#this.primarydb#">
		SELECT ENTRY_DATE, ENTRY_FILENAME FROM BLOG_ENTRIES
		WHERE
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.entry_id#">
	</cfquery>
	<cfif qry.recordCount is 0><cfreturn ""></cfif>
	<cfset entryFilePath = "#this.documentroot##this.dirsep##arguments.blog_id##this.dirsep##Year(qry.entry_date)##this.dirsep##DateFormat(qry.entry_date,'mm')##this.dirsep##qry.entry_filename#">

	<cfquery name="qry" datasource="#this.primarydb#">
		delete from BLOG_ENTRIES
		where 
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.entry_id#">
	</cfquery>
	<cfquery name="qry" datasource="#this.primarydb#">
		delete from BLOG_COMMENTS
		where 
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.entry_id#">
	</cfquery>
	<cfquery name="qry" datasource="#this.primarydb#">
		delete from BLOG_SUBSCRIPTIONS
		where 
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.entry_id#">
	</cfquery>
	<cfif FileExists(entryFilePath)>
		<cftry>
			<cffile action="DELETE" file="#entryFilePath#">
			<cfcatch type="any">
				<cfreturn true>
			</cfcatch>
		</cftry>	
	</cfif>
	<cfreturn true>
</cffunction>

<cffunction name="deleteComment" access="public" returnType="boolean" output="no">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="ENTRY_ID" type="string" required="yes">
	<cfargument name="COMMENT_ID" type="numeric" required="yes">
	
	<cfset var qry = "">
	<cfquery name="qry" datasource="#this.primarydb#">
		delete from BLOG_COMMENTS
		where 
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.entry_id#">
			AND COMMENT_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.COMMENT_ID#">
	</cfquery>
	<cfquery name="qry" datasource="#this.primarydb#">
		UPDATE BLOG_ENTRIES
		SET totalComments = totalComments - 1
		WHERE
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.BLOG_ID#">
			AND ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.ENTRY_ID#">
	</cfquery>
	<cfreturn true>
</cffunction>

<cffunction name="getEntries" access="public" output="false" returnType="query">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="fromDate" type="date" required="yes">
	<cfargument name="toDate" type="date" required="yes">
	<cfargument name="category_id" type="string" required="yes">
	<cfargument name="criteria" type="string" required="no">
	<cfargument name="maxEntries" type="numeric" required="no" default="9999">
	
	<cfset var qry = "">
	<cfset var qry2 = "">
	<cfset var wddxPacketQry2 = "">
	
	<!--- make sure the from date is the beginning of the day, and the to date is the end of the day --->
	<cfset arguments.fromDate = createDateTime(year(arguments.fromDate),month(arguments.fromDate),day(arguments.fromDate),0,0,0)>
	<cfset arguments.toDate = createDateTime(year(arguments.toDate),month(arguments.toDate),day(arguments.toDate),23,59,59)>
	<cfquery name="qry" datasource="#this.primarydb#" MAXROWS="#maxEntries#">
		<!--- mysql 4.0 or lower does not support subqueries, so this query is different for mysql --->
		SELECT 
			<cfif this.dbtype eq "mysql">DISTINCT</cfif> A.*
		FROM 
			BLOG_ENTRIES A <cfif category_id neq "" and this.dbtype eq "mysql">left join BLOG_CATEGORIES C ON A.ENTRY_ID=C.ENTRY_ID AND A.BLOG_ID=C.BLOG_ID</cfif>
		WHERE
			A.BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND A.ENTRY_DATE >= #CreateODBCDateTime(arguments.fromDate)#
			AND A.ENTRY_DATE <= #CreateODBCDateTime(arguments.toDate)#
			<cfif category_id neq "">
				<cfif this.dbtype eq "mysql">
					and C.CATEGORY_ID = <cfqueryparam cfsqltype="cf_sql_char" value="#arguments.category_id#">
				<cfelse>
					and A.ENTRY_ID IN ( SELECT ENTRY_ID FROM BLOG_CATEGORIES WHERE CATEGORY_ID = <cfqueryparam cfsqltype="cf_sql_char" value="#arguments.category_id#">)
				</cfif>
			</cfif>
			<cfif isDefined("criteria") and criteria neq "">
				and 
				(
					A.TITLE LIKE <cfqueryparam cfsqltype="cf_sql_varchar" value="%#criteria#%">
					OR A.SUBTITLE LIKE <cfqueryparam cfsqltype="cf_sql_varchar" value="%#criteria#%">
					OR A.ABSTRACT LIKE <cfqueryparam cfsqltype="cf_sql_longvarchar" value="%#criteria#%">
					OR A.CONTENT LIKE <cfqueryparam cfsqltype="cf_sql_longvarchar" value="%#criteria#%">
				)
			</cfif>
		ORDER BY A.ENTRY_DATE DESC
	</cfquery>
	<cfset QueryAddColumn(qry,"catInfo",ArrayNew(1))>
	<cfloop query="qry">
		<cfquery name="qry2" datasource="#this.primarydb#">
			select B.CATEGORY_ID, B.CATEGORY_NAME
			FROM CATEGORIES B INNER JOIN BLOG_CATEGORIES A
				ON A.BLOG_ID=B.BLOG_ID AND A.CATEGORY_ID=B.CATEGORY_ID
			WHERE 
				A.BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
				AND A.ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#entry_id#">		
		</cfquery>
		<cfwddx action="CFML2WDDX" input="#qry2#" output="wddxPacketQry2" usetimezoneinfo="Yes">
		<cfset querySetCell(qry,"catInfo",wddxPacketQry2,currentRow)>
	</cfloop>
	
	<cfreturn qry>
</cffunction>

<cffunction name="getEntry" access="public" output="no" returnType="Struct">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="ENTRY_ID" type="string" required="yes">
	
	<cfset var qry = "">
	<cfset var qry2 = "">
	<cfset var retVal = StructNew()>
	<cfset retVal.errorCode = 0>
	<cfset retVal.errorMessage = "">
	
	<cfquery name="qry" datasource="#this.primarydb#">
		SELECT A.*
		FROM BLOG_ENTRIES A
		WHERE
			A.BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND A.ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.entry_id#">
	</cfquery>
	<cfset retVal.entryInfo = qry>
	<cfquery name="qry2" datasource="#this.primarydb#">
		SELECT
			B.CATEGORY_ID
		FROM BLOG_CATEGORIES A INNER JOIN CATEGORIES B ON A.CATEGORY_ID=B.CATEGORY_ID AND A.BLOG_ID=B.BLOG_ID
		WHERE
			A.BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND A.ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.entry_id#">
	</cfquery>
	<cfset retVal.categories = "">
	<cfloop query="qry2">
		<cfset retVal.categories = ListAppend(retVal.categories,qry2.category_id)>
	</cfloop>
	
	<cfreturn retVal>
</cffunction>

<cffunction name="viewEntry" access="public" output="no" returnType="Struct">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="ENTRY_ID" type="string" required="yes">
	
	<cfset var qry = "">
	<cfset var qry2 = "">
	<cfset var qry3 = "">
	<cfset var retVal = StructNew()>
	<cfset retVal.errorCode = 0>
	<cfset retVal.errorMessage = "">
	
	<cfquery name="qry" datasource="#this.primarydb#">
		SELECT A.*,
			C.CATEGORY_ID, D.CATEGORY_NAME
		FROM 
			(BLOG_ENTRIES A left join BLOG_CATEGORIES C ON A.ENTRY_ID=C.ENTRY_ID AND A.BLOG_ID=C.BLOG_ID)
			LEFT JOIN CATEGORIES D ON C.CATEGORY_ID=D.CATEGORY_ID AND C.BLOG_ID=D.BLOG_ID
		WHERE
			A.BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND A.ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.entry_id#">
	</cfquery>
	<cfset retVal.entryInfo = qry>
	<cfquery name="qry2" datasource="#this.primarydb#">
		SELECT
			B.CATEGORY_ID
		FROM BLOG_CATEGORIES A INNER JOIN CATEGORIES B ON A.CATEGORY_ID=B.CATEGORY_ID AND A.BLOG_ID=B.BLOG_ID
		WHERE
			A.BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND A.ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.entry_id#">
	</cfquery>
	<cfset retVal.categories = "">
	<cfloop query="qry2">
		<cfset retVal.categories = ListAppend(retVal.categories,qry2.category_id)>
	</cfloop>
	<cfquery name="qry3" datasource="#this.primarydb#">
		SELECT A.*
		FROM BLOG_COMMENTS A
		WHERE
			A.BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND A.ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.entry_id#">
		ORDER BY A.ENTRY_DATE ASC
	</cfquery>
	<Cfset retVal.comments = qry3>
	
	
	<cfquery name="qry4" datasource="#this.primarydb#">
		SELECT A.*
		FROM GALLERY_PHOTOS A
		WHERE
			A.BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND A.GALLERY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#qry.gallery_id#">
		ORDER BY A.PHOTO_ID ASC
	</cfquery>
	<Cfset retVal.photos = qry4>
	
	<cfreturn retVal>
</cffunction>

<cffunction name="getPodInfo" access="public" output="no" returnType="Struct">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="numEntries" type="numeric" required="yes">
	<cfargument name="numComments" type="numeric" required="yes">
	<cfargument name="showDate" type="date" required="yes">
	
	<cfset var qry = "">
	<cfset var qry2 = "">
	<cfset var qry3 = "">
	<cfset var qry4 = "">
	
	<cfquery name="qry" datasource="#this.primarydb#" maxrows="#numEntries#">
		SELECT ENTRY_ID, TITLE, ENTRY_DATE
		FROM BLOG_ENTRIES
		WHERE
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
		ORDER BY ENTRY_DATE DESC
	</cfquery>
	<cfquery name="qry2" datasource="#this.primarydb#" maxrows="#numComments#">
		SELECT 
			A.ENTRY_ID, A.TITLE, B.UNAME, B.ENTRY_DATE, B.COMMENT_ID
		FROM BLOG_ENTRIES A INNER JOIN BLOG_COMMENTS B ON A.ENTRY_ID=B.ENTRY_ID AND A.BLOG_ID=B.BLOG_ID
		WHERE
			A.BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
		ORDER BY B.ENTRY_DATE DESC
	</cfquery>
	<cfquery name="qry3" datasource="#this.primarydb#">
		SELECT 
			Month(ENTRY_DATE) AS MONTH_OF_ARCHIVE, 
			Year(ENTRY_DATE) AS YEAR_OF_ARCHIVE,
			COUNT(*) AS numEntries
		FROM BLOG_ENTRIES
		WHERE
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
		GROUP BY 
			YEAR(ENTRY_DATE), 
			MONTH(ENTRY_DATE)
		ORDER BY 
			Year(ENTRY_DATE) DESC, 
			Month(ENTRY_DATE) DESC
	</cfquery>
	<cfquery name="qry4" datasource="#this.primarydb#">
		SELECT 
			C.CATEGORY_ID, C.CATEGORY_NAME, COUNT(*) as numEntries
		FROM 
			(BLOG_ENTRIES A INNER JOIN BLOG_CATEGORIES B ON A.ENTRY_ID=B.ENTRY_ID AND A.BLOG_ID=B.BLOG_ID)
			INNER JOIN CATEGORIES C ON B.CATEGORY_ID=C.CATEGORY_ID AND B.BLOG_ID=C.BLOG_ID
		WHERE
			A.BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
		GROUP BY C.CATEGORY_ID, C.CATEGORY_NAME
		ORDER BY C.CATEGORY_NAME
	</cfquery>
	<cfquery name="qry5" datasource="#this.primarydb#">
		SELECT 
			DISTINCT 
			ENTRY_DATE
		FROM 
			BLOG_ENTRIES
		WHERE 
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND Month(ENTRY_DATE) = #Month(showDate)#
			AND Year(ENTRY_DATE) = #Year(showDate)#
		ORDER BY ENTRY_DATE ASC
	</cfquery>
	<cfset retVal.highlightDates = "">
	<cfloop query="qry5">
		<cfif ListFind(retVal.highlightDates,Day(ENTRY_DATE)) IS 0>
			<cfset retVal.highlightDates = ListAppend(retVal.highlightDates,Day(ENTRY_DATE))>
		</cfif>
	</cfloop>	

	<cfquery name="qry6" datasource="#this.primarydb#">
		select 
			A.GALLERY_ID, A.GALLERY_NAME, A.CREATED, A.GALLERY_DESC, COUNT(B.PHOTO_ID) as numGalleries
		FROM 
			GALLERIES A LEFT JOIN GALLERY_PHOTOS B ON A.GALLERY_ID=B.GALLERY_ID
		GROUP BY 
			A.GALLERY_ID, A.GALLERY_NAME, A.GALLERY_DESC, A.CREATED
		ORDER BY A.CREATED DESC, A.GALLERY_NAME ASC
	</cfquery>
	
	<cfset retVal.recentEntries = qry>
	<cfset retVal.recentComments = qry2>
	<cfset retVal.archivedMonths = qry3>
	<cfset retVal.categories = qry4>
	<cfset retVal.galleryList = qry6>
	<cfreturn retVal>
</cffunction>



<cffunction name="sendNotification" access="private" output="false" returnType="boolean">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="notificationType" type="string" required="yes">
		<!--- "comment" or "entry" --->
	<cfargument name="reason" type="string" required="yes">
	<cfargument name="ENTRY_ID" type="string" required="yes">
	<cfargument name="COMMENT_ID" type="numeric" required="yes">
	<cfargument name="user_id" type="string" required="yes">
	<cfargument name="email" type="string" required="yes">
	<cfargument name="content" type="string" required="no">

	<cfset var qry = "">
	<cfset var subject = "">
	<cfset var reasonText = "">
	<cfset var entryLink = "">
	<cfset var entry = "">
	<cfset subject = "Subscription Notification - #getBlogConfigValue(arguments.blog_id, "BLOG_TITLE")#">
	<cfif reason eq "admin">
		<cfset reasonText = "You are receiving this notification because you are a site administrator and this blog is configured to send these notifications to the site administrators.">
	<cfelseif reason eq "global">
		<cfset reasonText = "You are receiving this notification because your user account with this blog is configured for global notification.">
	<cfelse>
		<cfset reasonText = "You are receiving this notification because you asked to be notified when new comments were added to this blog entry.">
	</cfif>
	<cfset entryLink = getEntryLink(arguments.blog_id, entry_id)>
	<cfset entry = getEntry(arguments.blog_id, arguments.entry_id)>

<cfmail from="#getBlogConfigValue(arguments.blog_id, "ADMIN_EMAIL")#"  server="mail.daxnet.com" to="#email#" bcc="polo@daxnet.com"  username="admin@daxnet.com" replyto="admin@iguanapolo.com" password="iguano08" charset="iso-8859-1" failto="polo@daxnet.com" SUBJECT="#subject#">
A new (nuevo) #notificationType# <cfif notificationType eq "entry">titled "#entry.entryInfo.TITLE#" <cfelse>regarding (acerca de )"#entry.entryInfo.TITLE#" </cfif>has been added to (ha sido agregada a ) #getBlogConfigValue(arguments.blog_id, "BLOG_TITLE")#.

#reasonText#

#entryLink#<cfif entryLink contains "?">&<cfelse>?</cfif>updateSubscription=1<cfif arguments.comment_id neq 0>&comment_id=#comment_id###comment#comment_id#</cfif>

<cfif reason eq "subscribe">To unsubscribe from this entry only (Desuscribir de este tema):
#entryLink#<cfif entryLink contains "?">&<cfelse>?</cfif>unsubscribe=1

To unsubscribe from all blog entries (Desuscribir de todo):
#getBlogConfigValue(arguments.blog_id,"WEBROOT")#/unsubscribe.cfm?all=true</cfif><cfif reason eq "global">

To disable global entry notification (Deshabilitar notificaciones):
#getBlogConfigValue(arguments.blog_id,"WEBROOT")#/edit_profile.cfm</cfif><cfif reason eq "admin">

To disable admin notification (Deshabilitar notificaciones de admin):
#getBlogConfigValue(arguments.blog_id,"WEBROOT")#/admin/index.cfm</cfif><cfif isDefined("arguments.content")>
______________________________________________________________________
#arguments.content#
</cfif>

IguanaPolo Admin
</cfmail>
	<cfif reason eq "subscribe">
		<cfquery name="qry" datasource="#this.primarydb#">
			update BLOG_SUBSCRIPTIONS
			SET LAST_NOTIFY=#CreateODBCDateTime(Now())#
			WHERE
				BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
				AND USER_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.user_id#">
				AND ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.entry_id#">
		</cfquery>
	</cfif>
	<cfreturn true>
</cffunction>

<cffunction name="deleteSubscriptions" access="public" output="no" returnType="boolean">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="user_id" type="string" required="yes">
	<cfargument name="ENTRY_ID" type="string" required="yes">

	<cfset var qry = "">
	<cfquery name="qry" datasource="#this.primarydb#">
		delete from BLOG_SUBSCRIPTIONS
		WHERE
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND USER_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.user_id#">
			<cfif arguments.entry_id neq "">
			AND ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.entry_id#">
			</cfif>
	</cfquery>
	<cfreturn true>
</cffunction>

<cffunction name="updateSubscription" access="public" output="no" returnType="boolean">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="user_id" type="string" required="yes">
	<cfargument name="ENTRY_ID" type="string" required="yes">

	<cfset var qry = "">
	<cfquery name="qry" datasource="#this.primarydb#">
		UPDATE BLOG_SUBSCRIPTIONS
		SET LAST_ACCESS=#CreateODBCDateTime(Now())#
		WHERE
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND USER_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.user_id#">
			AND ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.entry_id#">
	</cfquery>
	<cfreturn true>
</cffunction>

<cffunction name="addSubscription" access="public" output="no" returnType="boolean">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="user_id" type="string" required="yes">
	<cfargument name="ENTRY_ID" type="string" required="yes">

	<cfset var qry = "">
	<cftry>
		<cfquery name="qry" datasource="#this.primarydb#">
			INSERT INTO BLOG_SUBSCRIPTIONS
			( BLOG_ID, ENTRY_ID, USER_ID, LAST_NOTIFY, LAST_ACCESS )
			VALUES
			(
				<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">,
				<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.entry_id#">,
				<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.user_id#">,
				#CreateODBCDateTime(Now())#,
				#CreateODBCDateTime(Now())#
			
			)
		</cfquery>
		<cfcatch type="any">
			<!--- already subsccribed --->
			<cfreturn true>
		</cfcatch>
	</cftry>
	<cfreturn true>
</cffunction>

<cffunction name="deleteSubscription" access="public" output="no" returnType="boolean">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="user_id" type="string" required="yes">
	<cfargument name="ENTRY_ID" type="string" required="yes">

	<cfset var qry = "">
	<cfquery name="qry" datasource="#this.primarydb#" debug>
		DELETE FROM BLOG_SUBSCRIPTIONS
		WHERE 
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.entry_id#">
			AND USER_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.user_id#">
	</cfquery>
	<cfreturn true>
</cffunction>

<cffunction name="isSubscribed" access="public" output="no" returnType="boolean">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="user_id" type="string" required="yes">
	<cfargument name="ENTRY_ID" type="string" required="yes">

	<cfset var qry = "">
	<cfquery name="qry" datasource="#this.primarydb#">
	SELECT * FROM BLOG_SUBSCRIPTIONS
	WHERE
		BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
		AND USER_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.user_id#">
		AND ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.entry_id#">
	</cfquery>
	<cfif qry.recordCount is 0>
		<cfreturn false>
	<cfelse>
		<cfreturn true>
	</cfif>
</cffunction>

<cffunction name="getEntryLink" access="public" output="no" returnType="string">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="ENTRY_ID" type="string" required="yes">

	<cfset var qry = "">
	<cfset var entryFilePath = "">
	<cfset var entryFileName = "">
	<cfset var entryFileLink = "">
	<cfquery name="qry" datasource="#this.primarydb#">
		SELECT ENTRY_DATE, ENTRY_FILENAME FROM BLOG_ENTRIES
		WHERE
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.entry_id#">
	</cfquery>
	<cfset entryFileName = qry.ENTRY_FILENAME>
	<cfif entryFileName eq "">
		<cfset entryFileLink = "#getBlogConfigValue(arguments.blog_id,"WEBROOT")#/entry.cfm?entry_id=#entry_id#">
	<cfelse>
		<cfset entryFilePath = "#this.documentroot##this.dirsep##arguments.blog_id##this.dirsep##Year(qry.entry_date)##this.dirsep##DateFormat(qry.entry_date,'mm')##this.dirsep##entryFileName#">
		<cfif getBlogConfigValue(arguments.blog_id, "CREATE_ENTRY_FILES") is 1 AND FileExists(entryFilePath)>
			<cfset entryFileLink = "#getBlogConfigValue(arguments.blog_id,"WEBROOT")#/#arguments.blog_id#/#Year(qry.entry_date)#/#DateFormat(qry.entry_date,'mm')#/#entryFileName#">
		<cfelse>
			<cfset entryFileLink = "#getBlogConfigValue(arguments.blog_id,"WEBROOT")#/entry.cfm?entry_id=#entry_id#">
		</cfif>
	</cfif>
	<cfreturn entryFileLink>
</cffunction>

<cffunction name="makeEntryLink" access="public" output="no" returnType="boolean">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="ENTRY_ID" type="string" required="yes">

	<cfset var qry = "">
	<cfset var entryFilePath = "">
	<cfset var entryFileName = "">
	<cfset var entryFileLink = "">
	<Cfset var monthDir = "">
	<cfset var yearDir = "">
	<cfset var prefix = Ucase(FormatBaseN(RandRange(16,255), 16))>
	<cfset var prefix2 = Ucase(FormatBaseN(RandRange(16,255), 16))>
	<cfset var prefix3 = Ucase(FormatBaseN(RandRange(16,255), 16))>
	
	<cfquery name="qry" datasource="#this.primarydb#" DEBUG>
		SELECT ENTRY_DATE, TITLE 
		FROM BLOG_ENTRIES
		WHERE
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.entry_id#">
	</cfquery>
	<cfif qry.recordCount is 0>
		<cfreturn false>
	</cfif>
	<cfset entryFileName = Replace(qry.title," ","ZXZXZ","ALL")>
	<cfset entryFileName = REReplace(entryFileName,"[^A-Za-z0-9]+","","ALL")>
	<cfset entryFileName = Replace(entryFileName,"ZXZXZ","-","ALL")>
	<cfif entryFilename eq "index">
		<cfset entryfilename = "x.index">
	</cfif>
	<cfset tmp = entryFileName & ".cfm">
	<cfset entryFileName = tmp>
	<cfset entryFilePath = "#this.documentroot##this.dirsep##arguments.blog_id##this.dirsep##Year(qry.entry_date)##this.dirsep##DateFormat(qry.entry_date,'mm')##this.dirsep##entryFileName#">

	<cfif fileExists(entryFilePath)>
		<!--- attach the prefix .. this SHOULD make it unique --->
		<cfset entryFileName = prefix2 & "." & entryFileName>
		<cfset entryFilePath = "#this.documentroot##this.dirsep##arguments.blog_id##this.dirsep##Year(qry.entry_date)##this.dirsep##DateFormat(qry.entry_date,'mm')##this.dirsep##entryFileName#">
	</cfif>
	<cfif fileExists(entryFilePath)>
		<!--- attach the second prefix .. this SHOULD make it unique --->
		<cfset entryFileName = prefix2 & "." & entryFileName>
		<cfset entryFilePath = "#this.documentroot##this.dirsep##arguments.blog_id##this.dirsep##Year(qry.entry_date)##this.dirsep##DateFormat(qry.entry_date,'mm')##this.dirsep##entryFileName#">
	</cfif>
	<cfif fileExists(entryFilePath)>
		<!--- fail --->
		<cfreturn false>
	</cfif>
	<cfset yearDir = "#this.documentRoot##this.dirSep##arguments.blog_id##this.dirsep##Year(qry.entry_date)#">
	<cfif NOT directoryExists(yearDir)>
		<cfdirectory action="CREATE" directory="#yearDir#">
	</cfif>
	<cfset monthDir = "#this.documentRoot##this.dirSep##arguments.blog_id##this.dirsep##Year(qry.entry_date)##this.dirSep##DateFormat(qry.entry_date,'mm')#">
	<cfif NOT directoryExists(monthDir)>
		<cfdirectory action="CREATE" directory="#monthDir#">
	</cfif>
	<cfset indexFile = monthDir & this.dirsep & "index.cfm">
	<cfif NOT fileExists(indexFile)>
		<cffile action="WRITE" file="#indexFile#" output="<cfset year = #Year(qry.entry_date)#>#chr(10)#<cfset month = #Month(qry.entry_date)#>#chr(10)#<cfinclude template=#Chr(34)###application.blogcfm.mapping##index.cfm#chr(34)#>" addnewline="Yes">
	</cfif>
	<cffile action="WRITE" file="#entryFilePath#" output="<cfset ENTRY_ID=#Chr(34)##arguments.ENTRY_ID##Chr(34)#>#Chr(10)#<cfinclude template=#Chr(34)###application.blogcfm.mapping##entry.cfm#Chr(34)#>" addnewline="Yes">
	<cfquery name="qry" datasource="#this.primarydb#">
		UPDATE BLOG_ENTRIES
		SET ENTRY_FILENAME=<cfqueryparam cfsqltype="cf_sql_varchar" value="#entryFilename#">
		WHERE
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.blog_id#">
			AND ENTRY_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.entry_id#">
	</cfquery>
	<cfreturn true>
</cffunction>




<cffunction name="saveGallery" access="public" output="no" returntype="struct">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="details" type="struct" required="yes">
	<cfargument name="fieldnames" type="string" required="no" default="">

	<!---
		BLOG_ID, GALLERY_ID, CATEGORY_ID,
		CREATED, LAST_UPDATED, GALLERY_NAME, 
		GALLERY_DESC, PRIVATE
	--->
 	
	<cfset var qry = "">
	<cfset var galleryDirectory = "">
	<cfset var uploadDirectory = "">
	<cfset var retVal = STructNew()>
	<cfset retVal.errorCode = 0>
	<cfset retVal.errorMessage = "">
	
	<cfset arguments.details.blog_id = arguments.blog_id>
	<cfif arguments.details.gallery_id is 0>
		<cfparam name="arguments.details.category_id" default="0">
		<cfparam name="arguments.details.gallery_name" default="">
		<cfparam name="arguments.details.gallery_desc" default="">
		<cfquery name="qry" datasource="#this.primaryDb#">
			select max(gallery_id) as max_gallery_id 
			from GALLERIES
			where
				blog_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#arguments.blog_id#">
		</cfquery>
		<cfif qry.recordcount is 0 or not isNumeric(qry.max_gallery_id)>
			<cfset retval.gallery_id = 1>
		<cfelse>
			<cfset retval.gallery_id = qry.max_gallery_id + 1>
		</cfif>

		<cfquery name="qry" datasource="#this.primarydb#">
		INSERT INTO GALLERIES
		(
			BLOG_ID,
			GALLERY_ID,
			CATEGORY_ID,
			CREATED,
			LAST_UPDATED,
			GALLERY_NAME,
			GALLERY_DESC,
			PRIVATE
		) VALUES (
			<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.details.BLOG_ID#">,
			<cfqueryparam cfsqltype="cf_sql_integer" value="#retVal.GALLERY_ID#">,
			<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.details.CATEGORY_ID#">,
			#CreateODBCDateTime(Now())#,
			#CreateODBCDateTime(Now())#,
			<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.details.GALLERY_NAME#">,
			<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.details.GALLERY_DESC#">,
			0
		)
		</cfquery>
		<cfset galleryDirectory = getBlogConfigValue(arguments.blog_id, "PHOTOGALLERYROOT") & this.dirsep & retVal.gallery_id>
		<cfif not directoryExists(galleryDirectory)>
			<cfdirectory action="CREATE" directory="#galleryDirectory#">
		</cfif>
		<cfset uploadDirectory = getBlogConfigValue(arguments.blog_id, "PHOTOGALLERYROOT") & this.dirsep & "tmp">
		<cfif not directoryExists(uploadDirectory)>
			<cfdirectory action="CREATE" directory="#uploadDirectory#">
		</cfif>
		<cfreturn retVal>
	<cfelse>
		<cfquery name="qry" datasource="#this.primarydb#">
		UPDATE GALLERIES
		SET
			<cfif isDefined("arguments.details.GALLERY_NAME")>GALLERY_NAME=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.details.GALLERY_NAME#">,</cfif>
			<cfif isDefined("arguments.details.GALLERY_DESC")>GALLERY_DESC=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.details.GALLERY_DESC#">,</cfif>
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.BLOG_ID#">
		WHERE
			BLOG_ID=<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.BLOG_ID#">
			AND GALLERY_ID=<cfqueryparam cfsqltype="cf_sql_integer" value="#arguments.details.GALLERY_ID#">
		
		</cfquery>
		<cfset retVal.GALLERY_ID = arguments.details.GALLERY_ID>
		<cfreturn retVal>
	</cfif>	
	<cfreturn retVal>
</cffunction>

<cffunction name="getGallery" access="public" output="no" returntype="query">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="GALLERY_ID" type="numeric" required="yes">
	
	<cfset var qry = "">
	<CFQUERY NAME="qry" DATASOURCE="#this.PrimaryDB#">
		SELECT 
			A.GALLERY_ID, A.GALLERY_NAME, A.GALLERY_DESC, A.PRIVATE, 
			COUNT(B.PHOTO_ID) AS CNT, 
			MAX(B.THUMB_FILENAME) AS THUMB 
		FROM 
			GALLERIES A LEFT JOIN GALLERY_PHOTOS B ON A.GALLERY_ID=B.GALLERY_ID 
		WHERE
			A.blog_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#arguments.blog_id#">
			and A.gallery_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#arguments.gallery_id#">
		GROUP BY A.GALLERY_ID, A.GALLERY_NAME, A.GALLERY_DESC, A.PRIVATE
		ORDER BY GALLERY_NAME DESC
	</CFQUERY>
	<cfreturn qry>
</cffunction>

<cffunction name="listGALLERIES" access="public" output="no" returntype="query">
	<cfargument name="BLOG_ID" type="numeric" required="yes">

	<cfset var qry = "">
	
	<CFQUERY NAME="qry" DATASOURCE="#this.PrimaryDB#">
		SELECT 
			A.GALLERY_ID, A.GALLERY_NAME, A.GALLERY_DESC, A.CREATED, A.LAST_UPDATED,
			COUNT(B.PHOTO_ID) AS CNT, 
			MAX(B.THUMB_FILENAME) AS THUMB 
		FROM 
			GALLERIES A LEFT JOIN GALLERY_PHOTOS B ON A.GALLERY_ID=B.GALLERY_ID 
		WHERE
			A.blog_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#arguments.blog_id#">
		GROUP BY A.GALLERY_ID, A.GALLERY_NAME, A.GALLERY_DESC, A.CREATED, A.LAST_UPDATED
		ORDER BY GALLERY_NAME DESC
	</CFQUERY>
	<cfreturn qry>
	
</cffunction>

<cffunction name="deleteGallery" access="public" output="no" returntype="boolean">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="GALLERY_ID" type="numeric" required="yes">
	
	<cfset var qry1 = "">
	<cfset var qry2 = "">
	<cfset var results = "">
	<cfset var galleryDirectory = getBlogConfigValue(arguments.blog_id, "PHOTOGALLERYROOT") & this.dirsep & gallery_id>


	<CFQUERY NAME="qry1" DATASOURCE="#this.primarydb#">
		SELECT * 
		FROM GALLERY_PHOTOS 
		WHERE
			blog_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#arguments.blog_id#">
			and gallery_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#arguments.gallery_id#">
	</CFQUERY>
	<CFQUERY NAME="qry2" DATASOURCE="#this.primarydb#">
		DELETE FROM GALLERIES
		WHERE
			blog_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#arguments.blog_id#">
			and gallery_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#arguments.gallery_id#">
	</CFQUERY>

	<cfloop query="qry1">
		<cfset results = deletePhoto(arguments.blog_id, arguments.gallery_id, qry1.photo_id)>
	</cfloop>
	<cftry>
		<cfdirectory action="DELETE" directory="#galleryDirectory#">
		<cfcatch type="any">

		</cfcatch>
	</cftry>
	<cfreturn true>
</cffunction>

<cffunction name="deletePhoto" access="public" output="no" returntype="boolean">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="GALLERY_ID" type="numeric" required="yes">
	<cfargument name="PHOTO_ID" type="numeric" required="yes">
	
	<cfset var qry1 = "">
	<cfset var qry2 = "">
	<cfset var galleryDirectory = getBlogConfigValue(arguments.blog_id, "PHOTOGALLERYROOT") & this.dirsep & gallery_id>

	<CFQUERY NAME="qry1" DATASOURCE="#this.primarydb#">
		SELECT * 
		FROM GALLERY_PHOTOS 
		WHERE 
			blog_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#arguments.blog_id#">
			and gallery_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#arguments.gallery_id#">
			and photo_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#arguments.photo_id#">
	</CFQUERY>
	<CFQUERY NAME="qry2" DATASOURCE="#this.primarydb#">
		DELETE FROM GALLERY_PHOTOS 
		WHERE 
			blog_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#arguments.blog_id#">
			and gallery_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#arguments.gallery_id#">
			and photo_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#arguments.photo_id#">
	</CFQUERY>

	<cfloop query="qry1">
		<cfset file1 = galleryDirectory & this.dirsep & qry1.filename>
		<cfset file2 = galleryDirectory & this.dirsep & qry1.thumb_filename>
		<cfif fileExists(file1)>
			<cftry>
				<cffile action="DELETE" file="#file1#">
				<cfcatch type="any">
					
				</cfcatch>
			</cftry>
		</cfif>
		<cfif fileExists(file2)>
			<cftry>
				<cffile action="DELETE" file="#file2#">
				<cfcatch type="any">
				
				</cfcatch>
			</cftry>
		</cfif>
	</cfloop>
	<cfreturn true>
</cffunction>

<cffunction name="savePhoto" access="public" output="no" returntype="struct">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="details" type="struct" required="yes">
	<cfargument name="fieldnames" type="string" required="no" default="">
	
	<!--- 
		BLOG_ID, GALLERY_ID, PHOTO_ID, FILENAME,
		PHOTO_DESC, ORIG_FILENAME, THUMB_FILENAME 
	--->
	<cfset var qry = "">
	<cfset var form = "">
	<Cfset var photoFileName = "">
	<Cfset var photoFilePath = "">
	<cfset var tmp = "">
	<cfset var results = "">
	<cfset var prefix = Ucase(FormatBaseN(RandRange(16,255), 16))>
	<cfset var prefix2 = Ucase(FormatBaseN(RandRange(16,255), 16))>
	<cfset var retVal = StructNew()>
	<cfset retVal.errorCode = 0>
	<cfset retVal.errorMessage = "">

	
	<cfif arguments.details.photo_id eq 0>
		<cfquery name="qry" datasource="#this.primaryDb#">
			select max(photo_id) as max_photo_id from GALLERY_PHOTOS
			where
				blog_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#arguments.blog_id#">
				and gallery_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#arguments.details.gallery_id#">
		</cfquery>
		<cfif qry.recordcount is 0 or not isNumeric(qry.max_photo_id)>
			<cfset retVal.photo_id = 1>
		<cfelse>
			<cfset retVal.photo_id = qry.max_photo_id + 1>
		</cfif>
		<cfset photoFilename = Replace(arguments.details.orig_filename," ","ZXZXZ","ALL")>
		<cfset photoFileName = REReplace(photoFileName,"[^A-Za-z0-9\.]+","","ALL")>
		<cfset photoFileName = Replace(photoFileName,"ZXZXZ","-","ALL")>
		<cfset tmp = photoFileName>
		<cfset photoFileName = tmp>
		<cfset photoFilePath = getBlogConfigValue(arguments.blog_id, "PHOTOGALLERYROOT") & this.dirsep & arguments.details.gallery_id & this.dirsep>
		<cfif fileExists("#photoFilePath##photoFileName#")>
			<cfset photoFileName = prefix & "." & photoFileName>
		</cfif>
		<cfif fileExists("#photoFilePath##photoFileName#")>
			<cfset photoFileName = prefix2 & "." & photoFileName>
		</cfif>
		<cfset retval.FILENAME = photoFilename>
		<cfset retval.THUMB_FILENAME = "thumb_" & photoFilename>

		
		<cfquery name="qry" datasource="#this.primarydb#">
			INSERT INTO GALLERY_PHOTOS
			(
				BLOG_ID,
				GALLERY_ID,
				PHOTO_ID,
				FILENAME,
				PHOTO_DESC,
				ORIG_FILENAME,
				THUMB_FILENAME
			) VALUES (
				<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.BLOG_ID#">,
				<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.details.GALLERY_ID#">,
				<cfqueryparam cfsqltype="cf_sql_char" value="#retVal.PHOTO_ID#">,
				<cfqueryparam cfsqltype="cf_sql_char" value="#retVal.FILENAME#">,
				<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.details.PHOTO_DESC#">,
				<cfqueryparam cfsqltype="cf_sql_char" value="#arguments.details.ORIG_FILENAME#">,
				<cfqueryparam cfsqltype="cf_sql_char" value="#retVal.THUMB_FILENAME#">
			)
		</cfquery>
		<cfreturn retVal>
	<cfelse>
		<cfquery name="qry" datasource="#this.primarydb#">
			UPDATE GALLERY_PHOTOS
			SET
				<cfif isDefined("arguments.details.filename")>FILENAME=<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.details.filename#">,</cfif>
				<cfif isDefined("arguments.details.photo_desc")>PHOTO_DESC=<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.details.photo_desc#">,</cfif>
				<cfif isDefined("arguments.details.orig_filename")>ORIG_FILENAME=<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.details.orig_filename#">,</cfif>
				<cfif isDefined("arguments.details.thumb_filename")>THUMB_FILENAME=<cfqueryparam cfsqltype="cf_sql_varchar" value="#arguments.details.thumb_filename#">,</cfif>
				blog_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#arguments.blog_id#">
			WHERE
				blog_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#arguments.blog_id#">
				and gallery_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#arguments.details.gallery_id#">
				and photo_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#arguments.details.photo_id#">
		</cfquery>

		<cfset results = getPhoto(arguments.blog_id, arguments.details.gallery_id, arguments.details.photo_id)>
		<cfset retVal.FILENAME = results.FILENAME>
		<cfset retVal.PHOTO_ID = PHOTO_ID>
		<cfset retVal.THUMB_FILENAME = results.THUMB_FILENAME>
	</cfif>
	<cfreturn retVal>
</cffunction>

<cffunction name="getPhoto" access="public" output="no" returnType="query">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="GALLERY_ID" type="numeric" required="yes">
	<cfargument name="PHOTO_ID" type="numeric" required="yes">	
	
	<cfset var qry = "">
	<CFQUERY NAME="qry" DATASOURCE="#this.PrimaryDB#">
		SELECT * 
		FROM GALLERY_PHOTOS
		where 
			blog_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#blog_id#">
			AND gallery_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#gallery_id#">
			AND PHOTO_ID=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#photo_id#">
	</CFQUERY>
	<cfreturn qry>
</cffunction>

<cffunction name="listPhotos" access="public" output="no" returnType="query">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="GALLERY_ID" type="numeric" required="yes">	
	
	<cfset var qry = "">
	<CFQUERY NAME="qry" DATASOURCE="#this.PrimaryDB#">
		SELECT * FROM GALLERY_PHOTOS
		where 
			blog_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#blog_id#">
			and gallery_id=<cfqueryparam cfsqltype="CF_SQL_INTEGER" value="#GALLERY_ID#">
	</CFQUERY>
	<cfreturn qry>

</cffunction>

<cffunction name="getGalleryInfo" access="public" output="no" returnType="Struct">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="GALLERY_ID" type="numeric" required="yes">	

	<cfset var retVal = StructNew()>
	<cfset retVal.errorCode = 0>
	<cfset retVal.errorMessage = "">
	
	<cfset retVal.galleryInfo = getGallery(arguments.blog_id, arguments.gallery_id)>
	<cfset retVal.photos = listPhotos(arguments.blog_id, arguments.gallery_id)>
	<cfreturn retVal>
</cffunction>

<cffunction name="generateRSS" access="remote" returnType="string" output="no">
	<cfargument name="BLOG_ID" type="numeric" required="yes">
	<cfargument name="mode" type="string" required="false" default="short" hint="If mode=short, show EXCERPT chars of entries. Otherwise, show all.">
	<cfargument name="params" type="struct" required="false" default="#structNew()#" hint="Passed to getEntries. Note, maxEntries can't be bigger than 15.">

<!--- removed excerpt argument --->
		
	<cfset var articles = "">
	<cfset var qryCatInfo = "">
	<cfset var cats = "">
	<cfset var z = getTimeZoneInfo()>
	<cfset var header = "">
	<cfset var channel = "">
	<cfset var items = "">
	<cfset var dateStr = "">
	<cfset var rssStr = "">

	<cfparam name="params.fromDate" default="#CreateDate(1970,1,1)#">
	<cfparam name="params.toDate" default="#Now()#">
	<cfparam name="params.category_id" default="">
	<cfparam name="params.criteria" default="">
	<cfparam name="params.maxEntries" default="30">
	
	<cfset articles = getEntries(arguments.blog_id, params.fromDate, params.toDate, params.category_id, params.criteria, params.maxEntries)>
	<cfsavecontent variable="header">
	<cfoutput>
<?xml version="1.0" encoding="iso-8859-1"?>

<rdf:RDF 
	xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns##"
	xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns="http://purl.org/rss/1.0/"
>
		</cfoutput>
		</cfsavecontent>

		<cfsavecontent variable="channel">
		<cfoutput>
	<channel rdf:about="#getBlogConfigValue(arguments.blog_id, "WEBROOT")#">
	<title>#xmlFormat(getBlogConfigValue(arguments.blog_id, "BLOG_TITLE"))#</title>
	<description>Powered by BlogCFM</description>
	<link>#xmlFormat(getBlogConfigValue(arguments.blog_id, "WEBROOT"))#</link>
	
	<items>
		<rdf:Seq>
			<cfset last_entry_id = "">
			<cfloop query="articles">
			<cfif last_entry_id neq entry_id>
				<cfset last_entry_id eq entry_id>
			<rdf:li rdf:resource="#xmlFormat(getEntryLink(arguments.blog_id, entry_id))#" />
			</cfif>
			</cfloop>
		</rdf:Seq>
	</items>
	
	</channel>
		</cfoutput>
		</cfsavecontent>

		<cfsavecontent variable="items">
		<cfset last_entry_id = "">
		<cfloop query="articles">
		<cfif last_entry_id neq entry_id>
		<cfset last_entry_id eq entry_id>
		<cfset dateStr = dateFormat(ENTRY_DATE,"yyyy-mm-dd")>
		<cfset dateStr = dateStr & "T" & timeFormat(ENTRY_DATE,"HH:mm:ss") & "-" & numberFormat(z.utcHourOffset,"00") & ":00">
		<cfoutput>
  	<item rdf:about="#xmlFormat(getEntryLink(arguments.blog_id, entry_id))#">
	<title>#xmlFormat(TITLE)#</title>
	<description>#xmlFormat(CONTENT)#</description>
	<link>#xmlFormat(getEntryLink(arguments.blog_id, entry_id))#</link>
	<dc:date>#dateStr#</dc:date>
	<cfwddx action="WDDX2CFML" input="#catInfo#" output="qryCatInfo">
	<dc:subject><cfloop query="qryCatInfo"><cfset cats = ListAppend(cats,xmlFormat(CATEGORY_NAME))></cfloop>#xmlFormat(cats)#</dc:subject>
	</item>
	</cfoutput>
	</cfif>
 	</cfloop>
	</cfsavecontent>

	<cfset rssStr = trim(header & channel & items & "</rdf:RDF>")>
	
	<cfreturn rssStr>
	
</cffunction>


<!--- ################################################ --->
<!--- ################################################ --->
<!---                                                  --->
<!---                         UDFs                     --->
<!---                                                  --->
<!--- ################################################ --->
<!--- ################################################ --->


<cffunction name="trimElements" access="public" output="no" returnType="Struct">
	<cfargument name="str" required="yes" type="Struct">

	<cfset var work = arguments.str>
	<cfloop collection="#work#" item="key">
		<cfset val = StructFind(work, key)>
		<cfif isSimpleValue(val)>
			<cfset val = trim(val)>
			<cfset StructUpdate(work, key, val)>
		<cfelseif isStruct(val)>
			<cfset val = trimElements(val)>
			<cfset StructUpdate(work, key, val)>
		</cfif>
	</cfloop>
	<cfreturn work>
</cffunction>

<CFFUNCTION ACCESS="public" NAME="tagStripper" OUTPUT="no" RETURNTYPE="string">
	<CFARGUMENT NAME="SOURCE" REQUIRED="YES" TYPE="string">
	<CFARGUMENT NAME="EXCLUDE" REQUIRED="YES" TYPE="string">
	


	<!-- if there are exclusions, mark them with NOSTRIP -->
	<CFIF EXCLUDE neq "">
	        <CFLOOP INDEX="ExcludeTag" LIST="#EXCLUDE#">
	                <CFSET EndLoop = 0>
	                <CFSET StartPosition = 1>
	                <CFLOOP CONDITION="EndLoop neq 1">
	                        <CFSET StartPosition = REFindNoCase("</*#EXCLUDETAG#([[:space:]]|>)",SOURCE)>
	                        <CFIF StartPosition gt 0>
	                                <CFSET SOURCE = Insert("___TEMP___NOSTRIP___",SOURCE,StartPosition)>
	                                <CFSET SOURCE = RemoveChars(SOURCE,StartPosition,1)>
	                                <CFSET StartPosition = 1>
	                        <CFELSE>
	                                <CFSET EndLoop = 1>
	                        </CFIF>
	                </CFLOOP>
	        </CFLOOP>
	</CFIF>
	<!-- loop through and strip all tags -->
	<CFSET EndLoop = 0>
	<CFSET StartPosition = 1>
	<CFLOOP CONDITION="EndLoop neq 1">
	        <CFSET StartPosition = REFindNoCase("</*[[:alpha:]]",SOURCE)>
	        <CFIF StartPosition gt 0>
	                <CFSET EndPosition = Find(">",SOURCE,StartPosition)>
	                <CFIF EndPosition gt 0>
	                        <CFSET SOURCE = RemoveChars(SOURCE,StartPosition,EndPosition-StartPosition+1)>
	                        <CFSET StartPosition = 1>
	                </CFIF>
	        <CFELSE>
	                <CFSET EndLoop = 1>
	        </CFIF>
	</CFLOOP>
	<CFIF NOT ListContains(LCase(EXCLUDE),"comments")>
	        <CFSET EndLoop = 0>
	        <CFSET StartPosition = 1>
	        <CFLOOP CONDITION="EndLoop neq 1">
	                <CFSET StartPosition = REFindNoCase("<!--",SOURCE)>
	                <CFIF StartPosition gt 0>
	                        <CFSET EndPosition = Find("-->",SOURCE,StartPosition)>
	                        <CFIF EndPosition gt 0>
	                                <CFSET SOURCE = RemoveChars(SOURCE,StartPosition,EndPosition-StartPosition+3)>
	                                <CFSET StartPosition = 1>
	                        </CFIF>
	                <CFELSE>
	                        <CFSET EndLoop = 1>
	                </CFIF>
	        </CFLOOP>
	</CFIF>
	<!--- convert excluded tags back to normal --->
	<CFSET SOURCE = Replace(SOURCE,"___TEMP___NOSTRIP___","<","ALL")>
	<CFRETURN SOURCE>

</CFFUNCTION>

<cfscript>
/**
 * Converts a query object into an array of structures.
 * 
 * @param query 	 The query to be transformed 
 * @return This function returns a structure. 
 * @author Nathan Dintenfass (nathan@changemedia.com) 
 * @version 1, September 27, 2001 
 */
function QueryToArrayOfStructures(theQuery){
	var theArray = arraynew(1);
	var cols = ListtoArray(theQuery.columnlist);
	var row = 1;
	var thisRow = "";
	var col = 1;
	for(row = 1; row LTE theQuery.recordcount; row = row + 1){
		thisRow = structnew();
		for(col = 1; col LTE arraylen(cols); col = col + 1){
			thisRow[cols[col]] = theQuery[cols[col]][row];
		}
		arrayAppend(theArray,duplicate(thisRow));
	}
	return(theArray);
}
</cfscript>


<cffunction name="sendPings" access="private" output="false" returntype="void">
	<cfargument name="UrlLIST" type="string" required="yes" hint="A list of URLs seperated by ;">
	
	<cfset var pingUrl = "">
	<cfloop list="#urlList#" delimiters="#Chr(10)#" index="pingUrl">
		<cfhttp url="#pingUrl#" throwonerror="no"></cfhttp>
	</cfloop>
</cffunction>

</cfcomponent>
