<cfif isDefined("form.blogConfig")>
	<cfparam name="FORM.FLAG_HTML_EDITOR_ADMIN" default="1">
	<cfparam name="FORM.CREATE_ENTRY_FILES" default="1">
	<cfparam name="FORM.SESSION_IP_SECURITY" default="0">
	<cfparam name="FORM.REQUIRE_LOGIN" default="0">
	<cfparam name="FORM.MONITOR_LEVEL" default="0">
	<cfparam name="FORM.ENABLE_SUBSCRIPTIONS" default="0">
	<cfparam name="FORM.ENABLE_CAPTCHA" default="0">
	<cfparam name="FORM.PING_ON_UPDATE" default="">

	<cfparam name="FORM.DISABLE_COMMENTS" default="0">
	<cfparam name="FORM.COMMENT_DISABLE_AGE" default="0">
	<cfif not isNumeric(FORM.COMMENT_DISABLE_AGE)>
		<cfset form.COMMENT_DISABLE_AGE = 0>
	</cfif>
	
	<cfset structDelete(form,"blogConfig")>
	<Cfset errorMessage = "">
	<cfif not isEmail(FORM.ADMIN_EMAIL)>
		<cfset errorMessage = errorMessage & "<li>The email address is not valid." & chr(10)>
	</cfif>
	<Cfif trim(BLOG_TITLE) eq "">
		<cfset errorMessage = errorMessage & "<li>You must enter a title for this blog.  IT is used in system emails.</li>" & chr(10)>
	</CFIF>
	<cfif errorMessage eq "">
		<cfset saveBlogConfig = application.blogcfm.saveBlogConfig(variables.blog_id, form)>
	</cfif>
</cfif>
<cfset blogConfig = application.blogcfm.getBlogConfig(variables.blog_id)>
<cfset blogConfig = QueryRowToStruct(blogConfig)>
<CFINCLUDE TEMPLATE="above.cfm">
<H3>Blog Configuration</H3>
<cfif isDefined("errorMessage") and errorMessage neq "">
	<div class="errorMessage"><ul>#errorMessage#</ul></div>
</cfif>
<cfform scriptsrc="./cfform.js" action="index.cfm">
<input type="hidden" name="blogConfig" value="1">
Blog Administrator Email Address:<br>
<cfinput type="text" size="40" maxlength="255" name="ADMIN_EMAIL" value="#blogConfig.ADMIN_EMAIL#" required="Yes" MESSAGE="Please fill out all required fields.">
<p>
Blog Title:<BR>
<cfinput type="text" size="40" maxlength="255" name="BLOG_TITLE" value="#blogConfig.BLOG_TITLE#" required="Yes" MESSAGE="Please fill out all required fields.">
<p>
<input type="checkbox" name="REQUIRE_LOGIN" value="1"<cfif blogConfig.REQUIRE_LOGIN is 1> CHECKED</cfif>>Require user authentication for commenting.<br>
<input type="checkbox" name="MONITOR_LEVEL" value="1"<cfif blogConfig.MONITOR_LEVEL is 1> CHECKED</cfif>>Notify administrator of all new comments.<br>
<input type="checkbox" name="ENABLE_SUBSCRIPTIONS" value="1"<cfif blogConfig.ENABLE_SUBSCRIPTIONS is 1> CHECKED</cfif>>Allow authenticated users to receive subscription updates.<br>
<br>
<b>Commenting Options</b><br>
<input type="checkbox" name="DISABLE_COMMENTS" value="1"<cfif blogConfig.DISABLE_COMMENTS is 1> CHECKED</cfif>>Disable commenting.<br>
<p>
Disable comments after 
<cfinput type="text" size="4" name="COMMENT_DISABLE_AGE" required="yes" value="#blogConfig.COMMENT_DISABLE_AGE#" validate="integer" range="0,9999" message="To disable comments after a certain number of days, you must enter a valid integer between 0 and 9999."> days.<br>
This setting can be overridden on individual entries.
<p>

<b>Security Options</b><br>
<input type="checkbox" name="SESSION_IP_SECURITY" value="1"<cfif blogConfig.SESSION_IP_SECURITY is 1> CHECKED</cfif>>Enable strict session IP security. <a href="javascript:alert('This restricts each login session to its original IP address.  If a user\'s IP changes, they will no longer be logged in.');">what's this?</A><br>
<cfif fileExists(application.blogcfm.captchaFont)>
	<input type="checkbox" name="ENABLE_CAPTCHA" value="1"<cfif blogConfig.ENABLE_CAPTCHA IS 1> CHECKED</cfif>>Enable CAPTCHA authentication <a href="javascript:alert('CAPTCHA authentication forces unregistered users to enter the text from an obscured image during account registration and posting of comments.  This helps prevent spambots.');">what's this?</a>
<cfelse>
	<input type="hidden" name="enable_captcha" value="1">
</cfif>
<p>
<b>Remote Notification Options</b><br>
Ping the following url(s) whenever an entry is updated:<br>
<textarea rows="3" cols="50" wrap="no" name="PING_ON_UPDATE"><cfoutput>#blogConfig.PING_ON_UPDATE#</cfoutput></textarea>
<br>
<i>Enter one URL per line in the textarea above.)</i>
<p>
<b>CSS Override</b><br>
Enter any CSS below you would like to override CSS styles in the template:<br>
<textarea rows="5" cols="50" wrap="no" name="CSS_OVERRIDE"><cfoutput>#blogConfig.CSS_OVERRIDE#</cfoutput></textarea>
<p>
<input type="submit" value="Save Changes">
<p>

</cfform>
<CFINCLUDE TEMPLATE="below.cfm">
