<cfset variables.fileTypesOK = "image/jpeg,image/pjpeg"><!--- image.cfc can only handle jpeg right now --->

<cftry>
	<cfparam name="GALLERY_ID" type="numeric">
	<cfcatch type="any">
		<cflocation url="galleries.cfm" addtoken="No">
	</cfcatch>
</cftry>
<cfparam name="action" default="">
<cfif action eq "removePhoto">
	<cftry>
		<cfparam name="PHOTO_ID" type="numeric">
		<cfcatch type="any">
			<cflocation url="gallery.cfm?GALLERY_ID=#GALLERY_ID#" addtoken="No">
		</cfcatch>
	</cftry>
	<cfset results = application.blogcfm.deletePhoto(variables.blog_id, GALLERY_ID, PHOTO_ID)>
	<cfset action = "">
<cfelseif action eq "removeGallery">
	<cfset results = application.blogcfm.deleteGallery(variables.blog_id, GALLERY_ID)>
	<cflocation url="galleries.cfm" addtoken="No">
<cfelseif action eq "removeGallery">
	<cfset results = application.blogcfm.deleteGallery(variables.blog_id, GALLERY_ID)>
	<cflocation url="galleries.cfm" addtoken="No">
<cfelseif action eq "uploadPhoto">
	<cftry>
		<cfparam name="PHOTO_ID" type="numeric">
		<cfcatch type="any">
			<cflocation url="gallery.cfm" addtoken="No">
		</cfcatch>
	</cftry>
	<CFPARAM NAME="RESIZE_WIDTH" DEFAULT="500">
	<cfparam name="image_upload" default="">
	
	<cfset errorMessage = "">
	<cfset uploadStatus = 0>
	<cfif trim(image_upload) neq "">
		<cfset uploadDirectory = "#blogConfig.photoGalleryRoot##application.blogcfm.dirsep#tmp">
		<cffile action="upload" filefield="image_upload" nameconflict="overwrite" 
			accept="#variables.FileTypesOK#" destination="#uploadDirectory#" >
		<cfif cffile.fileWasSaved>
			<cfset ORIG_FILENAME = cffile.serverFile>
			<cfif reFindNoCase(".*\.jpg$",cffile.serverFile) is 0>
				<cffile action="delete" file="#uploadDirectory##application.blogcfm.dirsep##cffile.serverFile#">
				<cfset errorMessage = errorMessage & "Sorry, but due to limitations with the image manipulation library, BlogCFM currently only supports jpg images in photo galleries.">
			<cfelse>
				<cfset args = StructNew()>
				<cfset args.GALLERY_ID = GALLERY_ID>
				<cfset args.PHOTO_ID = PHOTO_ID>
				<cfset args.PHOTO_DESC = PHOTO_DESC>
				<cfset args.ORIG_FILENAME = ORIG_FILENAME>
				
				<cfset results = application.blogcfm.savePhoto(variables.blog_id, args,"BLOG_ID,GALLERY_ID,PHOTO_ID,ORIG_FILENAME,PHOTO_DESC")>
				<cffile action="move" source="#uploadDirectory##application.blogcfm.dirsep##cffile.serverFile#" DESTINATION="#blogConfig.photoGalleryRoot##application.blogcfm.dirsep##gallery_id##application.blogcfm.dirsep##results.FILENAME#">
				<cftry>
					<cfset uploadStatus = 1>
					<cfscript>
						imageCFC = createObject("component","image");
						base_file = "#blogConfig.photoGalleryRoot##application.blogcfm.dirsep##gallery_id##application.blogcfm.dirsep##results.FILENAME#";
						thumb_file = "#blogConfig.photoGalleryRoot##application.blogcfm.dirsep##gallery_id##application.blogcfm.dirsep##results.THUMB_FILENAME#";
						imageCFC.readImage("file",base_file);
						if (imageCFC.width() gt 150) {
							imageCFC.resize(150,0);
						}
						imageCFC.writeImage(thumb_file);
		
						imageCFC.readImage("file",base_file);
						ACTUAL_WIDTH = imageCFC.width();
						if (ACTUAL_WIDTH gt RESIZE_WIDTH) {
							imageCFC.resize(RESIZE_WIDTH, 0);
							imageCFC.writeImage(base_file);
						}
					</cfscript>
					<cfcatch type="any">
						<cfset errorMessage = cfcatch.message & " - " & cfcatch.detail>
						<cfset results = application.blogcfm.deletePhoto(variables.blog_id, GALLERY_ID, PHOTO_ID)>
					</cfcatch>
				</cftry>
			</cfif>
		</cfif>
	<cfelseif photo_id neq 0>
		<!--- we have a photo_id, and there is no image upload, so we must just be changing the properties --->
		<cfset args = StructNew()>
		<cfset args.GALLERY_ID = GALLERY_ID>
		<cfset args.PHOTO_ID = PHOTO_ID>
		<cfset args.PHOTO_DESC = PHOTO_DESC>
		<cfset args.ORIG_FILENAME = ORIG_FILENAME>
		<cfset results = application.blogcfm.savePhoto(variables.blog_id, args,"BLOG_ID,GALLERY_ID,PHOTO_ID,ORIG_FILENAME,PHOTO_DESC")>
		<cfif results.errorCode gt 0>
			<cfset errorMessage = results.errorMessage>
		</cfif>
	</cfif>
	<cfif errorMessage eq "">
		<cflocation url="gallery.cfm?GALLERY_ID=#GALLERY_ID#" addtoken="No">
	<cfelse>
		<cfset errorMessage = "The image was not uploaded correctly.<p><ul>#errorMessage#</ul>">
	</cfif>
<cfelseif action eq "resize">
	<cftry>
		<cfparam name="PHOTO_ID" type="numeric">
		<cfcatch type="any">
			<cflocation url="gallery.cfm?GALLERY_ID=#GALLERY_ID#" addtoken="No">
		</cfcatch>
	</cftry>
	<cftry>
		<cfparam name="RESIZE_WIDTH" type="numeric">
		<cfcatch type="any">
			<cflocation url="gallery.cfm?GALLERY_ID=#GALLERY_ID#" addtoken="No">
		</cfcatch>
	</cftry>
	
	<cfset getPhoto = application.blogcfm.getPhoto(variables.blog_id, GALLERY_ID, PHOTO_ID)>
	<cfif getPhoto.recordCount is 0>
		<cflocation url="galleries.cfm?GALLERY_ID=#GALLERY_ID#">
	</cfif>
	<cfscript>
		imageCFC = createObject("component","image");
		base_file = "#blogConfig.photoGalleryRoot##application.blogcfm.dirsep##gallery_id##application.blogcfm.dirsep##getPhoto.FILENAME#";
	
		imageCFC.readImage("file",base_file);
		imageCFC.resize(RESIZE_WIDTH,0);
		imageCFC.writeImage(base_file);
	</cfscript>
	<cflocation addtoken="no" url="gallery.cfm?GALLERY_ID=#GALLERY_ID#&RESIZE_WIDTH=#RESIZE_WIDTH#">
</cfif>

<CFPARAM NAME="RESIZE_WIDTH" DEFAULT="500">
<cfset imageCFC = createObject("component","image")>
<cfset getGallery = application.blogcfm.getGallery(variables.blog_id, GALLERY_ID)>
<CFIF GetGallery.RecordCount IS 0>
	<CFLOCATION URL="galleries.cfm">
</cfif>
<CFSET GALLERY_NAME = GetGallery.GALLERY_NAME>
<CFSET GALLERY_DESC = GetGallery.GALLERY_DESC>
<CFSET CNT = GetGallery.CNT>
<cfset getPhotos = application.blogcfm.listPhotos(variables.blog_id, GALLERY_ID)>

<CFINCLUDE TEMPLATE="above.cfm">
<H3>Photo Gallery Management</H3>
<cfif isDefined("errorMessage") and len(errorMessage) gt 0>
	<cfinclude template="messages.cfm">
</cfif>
<ul>
<li><A HREF="galleries.cfm">Return to list of photo galleries</A>.</li>
</ul>
<p>
<TABLE CELLPADDING=2 CELLSPACING=0 BORDER=1 WIDTH="100%">
<TR><TD COLSPAN=3 BGCOLOR="e0e0e0"><B>Current Photo Gallery</B></TD></TR>
<CFOUTPUT query="getGallery">
<TR>
	<TD VALIGN="top"><A 
		HREF="javascript:if(confirm('Are you sure you want to permanently delete this photo gallery and all of the pictures in it?')){ window.location.href='gallery_remove.cfm?GALLERY_ID=#GALLERY_ID#';}"><IMG SRC="icons/iconDelete.gif" ALT="Delete" BORDER="0"></A>&nbsp;<A 
		HREF="#variables.blogConfig.webRoot#/gallery.cfm?GALLERY_ID=#GALLERY_ID#"><IMG SRC="icons/iconEyeball.gif" ALT="View Photo Gallery" TARGET="_blank" BORDER="0"></A></TD>
	<td VALIGN="top">#CNT#&nbsp;<cfif CNT IS 1>image<cfelse>images</cfif></td>
	<TD VALIGN="top" WIDTH="100%">
		<b>#GALLERY_NAME#</b><BR>
		<I>#GALLERY_DESC#</I>
	</td>
</tr>
</cfoutput>
</table>

<CFSET form.GALLERY_NAME = ReplaceNoCase(Trim(GALLERY_NAME),'&quot;','"','ALL')>
<CFSET form.GALLERY_DESC = ReplaceNoCase(Trim(GALLERY_DESC),'&quot;','"','ALL')>
<cfset form.gallery_id = gallery_id>
<cfinclude template="frmGallery.cfm">
<P>
<cfform scriptsrc="./cfform.js" ACTION="gallery.cfm" NAME="frmUpload" ENCTYPE="multipart/form-data">
<input type="hidden" name="action" value="uploadPhoto">
<INPUT TYPE="HIDDEN" NAME="GALLERY_ID" VALUE="<CFOUTPUT>#GALLERY_ID#</CFOUTPUT>">
<INPUT TYPE="HIDDEN" NAME="PHOTO_ID" VALUE="0">

<fieldset>
	<legend><b>Upload a new photo to this gallery:</b></legend>
<INPUT TYPE="file" NAME="IMAGE_UPLOAD" SIZE="30" ACCEPT="<cfoutput>#variables.fileTypesOK#</cfoutput>"> (JPG only!)
<BR>Description:<CFINPUT TYPE="TEXT" NAME="PHOTO_DESC" SIZE="50" MAXLENGTH="255" REQUIRED="No">
<BR>Resize (scale width) to: <CFINPUT TYPE="TEXT" SIZE="3" MAXLENGTH="3" NAME="RESIZE_WIDTH" VALIDATE="integer" RANGE="150,750" REQUIRED="YES" MESSAGE="You must enter a width to resize this image to.  The image will only be resized if it is larger than the size you specify." VALUE="#RESIZE_WIDTH#"> pixels.
<INPUT TYPE="SUBMIT" VALUE="Upload Image">

</fieldset>
</CFFORM>
<P>
<CFIF GetPhotos.RecordCount IS 0>
	<B>There are no photos in this gallery.</B>
</CFIF>
<CFOUTPUT QUERY="GetPhotos">
<cfset image_width = 0>
<cfset image_height = 0>
<cftry>
<cfscript>
	base_file = "#blogConfig.photoGalleryRoot##application.blogcfm.dirsep##gallery_id##application.blogcfm.dirsep##FILENAME#";
	imageCFC.readImage("file",base_file);
	IMAGE_WIDTH = imageCFC.width();
	IMAGE_HEIGHT = imageCFC.height();
</cfscript>
	<cfcatch type="any">
	
	</cfcatch>
</cftry>
<a name="photo#PHOTO_ID#"></a>
<TABLE CELLPADDING=3 CELLSPACING=0 BORDER=1 WIDTH="100%">
<TR>
	<TD VALIGN="top" BGCOLOR="e0e0e0"><FONT FACE="ARIAL,HELVETICA" SIZE="2"><B>Actions:</B></FONT></TD>
	<TD VALIGN="top" WIDTH="100%">
		<FONT FACE="ARIAL,HELVETICA" SIZE="2">
		<b><A HREF="gallery_photo_edit.cfm?GALLERY_ID=#GALLERY_ID#&PHOTO_ID=#PHOTO_ID#"><img src="icons/iconCamera.gif" BORDER="0" ALIGN="ABSMIDDLE" ALT="Upload New Image">Upload New Image</A> &nbsp; 
		<A HREF="gallery.cfm?ACTION=removePhoto&GALLERY_ID=#GALLERY_ID#&PHOTO_ID=#PHOTO_ID#"><IMG SRC="icons/iconDelete.gif" ALIGN="ABSMIDDLE" ALT="Remove Image" BORDER="0">Remove Image</A></b>
		</FONT>
	</TD>
	<TD ROWSPAN=4><IMG SRC="#blogConfig.photoGalleryWebRoot#/#GALLERY_ID#/#THUMB_FILENAME#" WIDTH="150" BORDER="1"></TD>
</TR>
<TR>
	<TD VALIGN="top" BGCOLOR="e0e0e0"><FONT FACE="ARIAL,HELVETICA" SIZE="2"><B>Original Filename:</B></FONT></TD>
	<TD VALIGN="top" WIDTH="100%"><FONT FACE="ARIAL,HELVETICA" SIZE="2">#ORIG_FILENAME#</FONT></TD>
</TR>
<TR>
	<TD VALIGN="top" BGCOLOR="e0e0e0"><FONT FACE="ARIAL,HELVETICA" SIZE="2"><B>Description:</B></FONT></TD>
	<cfform scriptsrc="./cfform.js" action="gallery.cfm">
	<INPUT TYPE="HIDDEN" NAME="action" value="uploadPhoto">
	<INPUT TYPE="HIDDEN" NAME="GALLERY_ID" VALUE="#GALLERY_ID#">
	<INPUT TYPE="HIDDEN" NAME="PHOTO_ID" VALUE="#PHOTO_ID#">
	<INPUT TYPE="HIDDEN" NAME="ACTION" VALUE="SAVE_DESC">
	<INPUT TYPE="HIDDEN" NAME="ORIG_FILENAME" VALUE="#Replace(ORIG_FILENAME,Chr(34),"&quot;","ALL")#">
	<TD VALIGN="top" WIDTH="100%">
		<FONT FACE="ARIAL,HELVETICA" SIZE="2">
		<cfif PHOTO_DESC eq ""><I>None</I><CFELSE>#PHOTO_DESC#</cfif><br>
		Change Description: <input type="text" NAME="PHOTO_DESC" VALUE="" STYLE="width: 85%;"><input type="submit" value="Go!">
		</FONT>
	</TD>
	</cfform>
</TR>
<TR>
	<TD VALIGN="top" BGCOLOR="e0e0e0"><FONT FACE="ARIAL,HELVETICA" SIZE="2"><B>Size:</B></FONT></TD>
	<cfform scriptsrc="./cfform.js" action="gallery.cfm">
	<INPUT TYPE="HIDDEN" NAME="action" value="resizePhoto">
	<INPUT TYPE="HIDDEN" NAME="GALLERY_ID" VALUE="#GALLERY_ID#">
	<INPUT TYPE="HIDDEN" NAME="PHOTO_ID" VALUE="#PHOTO_ID#">
	<TD VALIGN="top" WIDTH="100%">
		<FONT FACE="ARIAL,HELVETICA" SIZE="2">
		#IMAGE_WIDTH#x#IMAGE_HEIGHT#
		<br>
		Resize (scale width) to: <CFINPUT VALUE="#RESIZE_WIDTH#" TYPE="TEXT" SIZE="3" NAME="RESIZE_WIDTH" REQUIRED="YES" VALIDATE="integer" RANGE="1,9999" MESSAGE="Pleae enter a valid width in pixels."> pixels.
		<input type="submit" value="Go!">
		</FONT>
	</TD>
	</cfform>
</TR>
</TABLE>
</CFOUTPUT>
<P>
<CFINCLUDE TEMPLATE="below.cfm">

