<?php
/*
#===========================================================================
#= Script : Blog Mod
#= Version: 0.2.1
#= Author : Ryan Thian
#= Email  : ryan@bloggingdoctor.com
#= Website: http://www.bloggingdoctor.com
#===========================================================================
#= Copyright (c) 2003 Ryan Thian
#= You are free to use and modify this script as long as this header
#= section stays intact. This file is part of BLOG MOD.
#=
#= This program is free software; you can redistribute it and/or modify
#= it under the terms of the GNU General Public License as published by
#= the Free Software Foundation; either version 2 of the License, or
#= (at your option) any later version.
#=
#= This program is distributed in the hope that it will be useful,
#= but WITHOUT ANY WARRANTY; without even the implied warranty of
#= MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#= GNU General Public License for more details.
#=
#= You should have received a copy of the GNU General Public License
#= along with BLOG MOD files; if not, write to the Free Software
#= Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#===========================================================================
#= Blog Mod is a modified version of Blog
#= Version: 1.51 beta
#= Author : Jonathan Beckett
#= Email  : jonbeckett@pluggedout.com
#= Website: http://www.pluggedout.com/projects_blog.php
#= Support: http://www.pluggedout.com/forums/viewforum.php?f=5
#===========================================================================
*/

// fixed constants
$months = Array("January","February","March","April","May","June","July","August","September","October","November","December");
$days = Array("Sun","Mon","Tue","Wed","Thu","Fri","Sat");

if ($_GET["selfview"] == "1") {
	$ownerview = "selfview=1";
}

// Function	: zonechange
// Description	: Change the time of the Blog to the user's local time
// Arguments	: $current - Server's  Time Zone
//		: $target - User's Time Zone
// Returns	: User's Local Time
// Author		: Ryan Thian
// Last Change	: 2003-12-29
function zonechange ($current, $target) {
	$current = -1 * $current;
	$zonedate = mktime(date('G'), date('i'), date('s'), date('n'),date('j'), date('Y'), 1) + (($current + $target) * 3600);
	return $zonedate;
}

// Function	: is_email
// Description	: Checks if an email address looks like a valid email address
// Arguments	: $email - the email address to check
// Returns	: true/false
// Author		: Jonathan Beckett
// Modified by	: Ryan Thian
// Last Change	: 2003-12-29
function is_email($email) {
	$validEmailExpr = "^[0-9a-z]([-_.]?[0-9a-z])*@[0-9a-z]([-.]?[0-9a-z])*\\.[a-z]{2,3}$";
	if (eregi($validEmailExpr,$email) ) {
		return true;
	} else {
		return false;
	}
}


// Function    : is_alphanumeric
// Description : Checks if a value is alphanumeric or not
// Arguments   : $value - the value to check
// Returns     : true/false
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function is_alphanumeric($input) {
	if ( preg_match("/[^a-zA-Z0-9]/",$userid) ) {
		return true;
	} else {
		return false;
	}
}


// Function    : get_date_part
// Description : Returns part of an SQL standard date (yyyy-mm-dd)
// Arguments   : $sqldate - the date to grab bits from
//               $part    - the part of the day to grab
// Returns     : a substring of the data passed to it
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function get_date_part($sqldate,$part) {
	// expects date in format yyyy-mm-dd hh:nn:ss
	switch ($part)
	{
		case "day":
			$result = substr($sqldate,8,2);
			break;
		case "month":
			$result = substr($sqldate,5,2);
			break;
		case "year":
			$result = substr($sqldate,0,4);
			break;
	}
	return $result;
}


// Function    : clean_text
// Description : Swaps carriage returns for html breaks (<br>) in supplied data
// Arguments   : $input - data to perform operation on
// Returns     : transformed data
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function clean_text($input){
	$result = ereg_replace("\n","<br>",$input);
	return $result;
}


?>