<?php
/*
#===========================================================================
#= Script : Blog Mod
#= Version: 0.2.1
#= Author : Ryan Thian
#= Email  : ryan@bloggingdoctor.com
#= Website: http://www.bloggingdoctor.com
#===========================================================================
#= Copyright (c) 2003 Ryan Thian
#= You are free to use and modify this script as long as this header
#= section stays intact. This file is part of BLOG MOD.
#=
#= This program is free software; you can redistribute it and/or modify
#= it under the terms of the GNU General Public License as published by
#= the Free Software Foundation; either version 2 of the License, or
#= (at your option) any later version.
#=
#= This program is distributed in the hope that it will be useful,
#= but WITHOUT ANY WARRANTY; without even the implied warranty of
#= MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#= GNU General Public License for more details.
#=
#= You should have received a copy of the GNU General Public License
#= along with BLOG MOD files; if not, write to the Free Software
#= Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#===========================================================================
#= Blog Mod is a modified version of Blog
#= Version: 1.51 beta
#= Author : Jonathan Beckett
#= Email  : jonbeckett@pluggedout.com
#= Website: http://www.pluggedout.com/projects_blog.php
#= Support: http://www.pluggedout.com/forums/viewforum.php?f=5
#===========================================================================
*/

// Function    : show_error
// Description : In the event of a database connection error, thus kills the attempt
// Arguments   : None
// Returns     : Nothing
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function show_error()
{
	die("Error " . mysql_errno() . " : " . mysql_error());
}


// Function    : sql_quote
// Description : Returns data passed to it surrounded with single quotes
// Arguments   : $input - the data to be transformed
// Returns     : the transformed data
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function sql_quote($input)
{
	return "'".$input."'";
}


// Function    : db_connect
// Description : Connects to the blog database (using global variables to do so)
// Arguments   : None
// Returns     : handle for database connection
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function db_connect()
{

	global $db_server;
	global $db_username;
	global $db_password;
	global $db_name;

	$con = mysql_connect($db_server,$db_username,$db_password);
	if (!(mysql_select_db($db_name,$con)))
	{
		show_error();
	}

	return $con;
}


// Function    : db_disconnect
// Description : Closes a database connection
// Arguments   : $con - database connection handle
// Returns     : Nothing
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function db_disconnect($con)
{
	close($con);
}


// Function	: db_prepare
// Description	: Fills the blog_view, blog_list and blog_view_comments arrays with data
// Arguments	: None (it works from GET parameters)
// Returns	: Nothing (it effects global arrays)
// Author		: Jonathan Beckett
// Modified by	: Ryan Thian
// Last Change	: 2003-12-29
// Blog Mod ver.	: 0.2.1
function db_prepare(){

	global $viewmode;
	
	global $day;
	global $month;
	global $year;
	
	global $list_rows;
	global $view_rows;
	global $view_comment_rows;

	global $viewcomments;
	global $pref_hits;
	global $first_blog;

	// connect to the database
	$con = db_connect();

	$date_today = getdate();

	// work out what to show based on URL parameters
	$blogid="";

	if ($_GET["view"]!="") {
		$blogid = $_GET["view"];
	} else {
		$blogid = $_GET["blogid"];
	}

	$search = $_GET["search"];
	if (!$search) {
		if (($_GET["blogid"]!="") || ($_GET["view"]!="")) {

			// get the blog entry from the database to find out what month it was (for the list and view sql)
			if ($_GET["day"]!=""){
				$sql_findmonth = "SELECT *,MONTH(dEntryDate) AS month,YEAR(dEntryDate) AS year,DAYOFMONTH(dEntryDate) AS day FROM blog WHERE nIdCode=".$blogid;
			} else {
				$sql_findmonth = "SELECT *,MONTH(dEntryDate) AS month,YEAR(dEntryDate) AS year FROM blog WHERE nIdCode=".$blogid;
			}

			$result = mysql_query($sql_findmonth,$con);
			if ($result!=false) {
				$row = mysql_fetch_array($result);
				$month = $row["month"];
				$year = $row["year"];
			} else {
				// revert to nothing sent
				$blogid="";
			}

			if ($_GET["day"]!=""){
				$sql_list = "SELECT * FROM blog WHERE MONTH(dEntryDate)=".$month." AND YEAR(dEntryDate)=".$year." AND DAYOFMONTH(dEntryDate)=".$_GET["day"]." ORDER BY dEntryDate DESC;";
			} else {
				$sql_list = "SELECT * FROM blog WHERE MONTH(dEntryDate)=".$month." AND YEAR(dEntryDate)=".$year." ORDER BY dEntryDate DESC;";
			}

			if ($viewmode=="single"){
				$sql_view = "SELECT * FROM blog WHERE nIdCode=".$blogid." LIMIT 1;";
			} else {
				if ($_GET["day"]!=""){
					$sql_view = "SELECT * FROM blog WHERE MONTH(dEntryDate)=".$month." AND YEAR(dEntryDate)=".$year."  AND DAYOFMONTH(dEntryDate)=".$_GET["day"]." ORDER BY dEntryDate DESC;";
				} else {
					$sql_view = "SELECT * FROM blog WHERE MONTH(dEntryDate)=".$month." AND YEAR(dEntryDate)=".$year." ORDER BY dEntryDate DESC;";
				}
			}
		}

		if ($blogid=="") {

			// Figure out what parts of the date we have got

			if ($_GET["day"]!="" || $_GET["month"]!="" || $_GET["year"]!=""){

				if ($_GET["day"]!=""){
					$day = $_GET["day"];
				} else {
					$day = "";
				}

				if ($_GET["month"]!=""){
					$month = $_GET["month"];
				} else {
					$month = $date_today["mon"];
				}

				if ($_GET["year"]!=""){
					$year = $_GET["year"];
				} else {
					$year = $date_today["year"];
				}

			} else {

				$day = "";
				$month = $date_today["mon"];
				$year = $date_today["year"];

			}

			// Build the SQL statements

			if ($day!=""){

				$sql_list = "SELECT * FROM blog WHERE MONTH(dEntryDate)=".$month." AND YEAR(dEntryDate)=".$year." AND DAYOFMONTH(dEntryDate)=".$day." ORDER BY nIdCode DESC;";
				if ($viewmode == "single"){
					$sql_view = "SELECT * FROM blog WHERE MONTH(dEntryDate)=".$month." AND YEAR(dEntryDate)=".$year." AND DAYOFMONTH(dEntryDate)=".$day." ORDER BY nIdCode DESC LIMIT 1;";
				} else {
					$sql_view = "SELECT * FROM blog WHERE MONTH(dEntryDate)=".$month." AND YEAR(dEntryDate)=".$year."  AND DAYOFMONTH(dEntryDate)=".$day." ORDER BY nIdCode DESC;";
				}

			} else {

				$sql_list = "SELECT * FROM blog WHERE MONTH(dEntryDate)=".$month." AND YEAR(dEntryDate)=".$year." ORDER BY nIdCode DESC;";
				if ($viewmode == "single"){
					$sql_view = "SELECT * FROM blog WHERE MONTH(dEntryDate)=".$month." AND YEAR(dEntryDate)=".$year." ORDER BY nIdCode DESC LIMIT 1;";
				} else {
					$sql_view = "SELECT * FROM blog WHERE MONTH(dEntryDate)=".$month." AND YEAR(dEntryDate)=".$year." ORDER BY nIdCode DESC;";
				}
			}
		}

	} else {
		$sql_list = "SELECT * FROM blog WHERE cTitle LIKE '%$search%' OR cBody LIKE '%$search%' ORDER BY nIdCode DESC";
		if ($viewmode == "single"){
			if ($blogid=="") {
				$sql_view = "SELECT * FROM blog WHERE cTitle LIKE '%$search%' OR cBody LIKE '%$search%' ORDER BY nIdCode DESC  LIMIT 1;";
			} else {
				$sql_view = "SELECT * FROM blog WHERE nIdCode=".$blogid." LIMIT 1;";
			}
		} else {
			$sql_view = "SELECT * FROM blog WHERE cTitle LIKE '%$search%' OR cBody LIKE '%$search%' ORDER BY nIdCode DESC";
		}
	}

	// Get data from the database (store in arrays)

	$list_result = mysql_query($sql_list,$con);
	$view_result = mysql_query($sql_view,$con);

	// Build List Array
	if ($list_result!=false) {
		$i=0;
		while ($list_row =@ mysql_fetch_array($list_result)){
			$i++;
			$list_rows[$i] = $list_row;
		}
	} else {
		$problem = "1";
	}

	// Build View Array
	if ($view_result!=false) {
		$i=0;
		while ($view_row =@ mysql_fetch_array($view_result)){

			if ($first_blog == "") {
				$first_blog = $view_row["nIdCode"];
			}

			if ((!$year) && (!$month) && ($search)) {
				$sql_findcalender = "SELECT *,MONTH(dEntryDate) AS month,YEAR(dEntryDate) AS year FROM blog WHERE nIdCode=".$view_row['nIdCode'];
				$result = mysql_query($sql_findcalender,$con);
				if ($result!=false) {
					$row = mysql_fetch_array($result);
					$month = $row["month"];
					$year = $row["year"];
				}	
			}

			$i++;
			$view_rows[$i] = $view_row;
			// build view_comments array
			if ($viewcomments=="yes") {
				$sql = "SELECT * FROM blog_comments WHERE nBlogId=".$view_row["nIdCode"]." ORDER BY nIdCode DESC";
				$result = mysql_query($sql,$con);
				if ($result!=false){
					$j=0;
					while ($comment_row =@ mysql_fetch_array($result)){
						$j++;
						$view_comment_rows[$i][$j] = $comment_row;
					}
				}
			}
		}
	} else {

		$problem = "2";
	}

	if ((!$year) && (!$month) && ($search)) {
		$day = "";
		$month = $date_today["mon"];
		$year = $date_today["year"];
	}
	// increment view counter for either the single blog being shown
	// or ALL blogs being shown


if ($_SESSION["userid"]==""){
	if ($pref_hits == "yes") {
		if ($_GET["selfview"] != "1") {
			if ($view_rows[1]["nIdCode"]!=""){
				if ($viewmode=="single"){
					$blogid = $view_rows[1]["nIdCode"];
					$sql = "UPDATE blog SET nViews=nViews+1 WHERE nIdCode=".$blogid;
				} else {
					for ($i=1;$i<=count($view_rows);$i++){
						$blog_array[$i] = $view_rows[$i]["nIdCode"];
					}
					$blogids = implode(",",$blog_array);
					$sql = "UPDATE blog SET nViews=nViews+1 WHERE nIdCode IN (".$blogids.")";
				}
				$result = mysql_query($sql,$con);
				if ($result==false){
					print "<li>Problem with SQL<br>[".$sql."]</li>\n";
				}
			}
		}
	}
}


}


// Function    : db_hitcount
// Description : Returns the total number of views of all blogs
//                (currently un-used)
// Arguments   : None
// Returns     : Result of calculation
// Author      : Jonathan Beckett
// Last Change : 2003-11-11
function db_hitcount(){
	$con = db_connect();
	$sql = "SELECT SUM(nViews) AS nTotal FROM blog";
	$result = mysql_query($sql,$con);
	if ($result!=false){
		$row = mysql_fetch_array($result);
		$total = $row["nTotal"];
	} else {
		$total = 0;
	}
	return $total;
}

?>