<?php
/*
#===========================================================================
#= Script : Blog Mod
#= Version: 0.2.1
#= Author : Ryan Thian
#= Email  : ryan@bloggingdoctor.com
#= Website: http://www.bloggingdoctor.com
#===========================================================================
#= Copyright (c) 2003 Ryan Thian
#= You are free to use and modify this script as long as this header
#= section stays intact. This file is part of BLOG MOD.
#=
#= This program is free software; you can redistribute it and/or modify
#= it under the terms of the GNU General Public License as published by
#= the Free Software Foundation; either version 2 of the License, or
#= (at your option) any later version.
#=
#= This program is distributed in the hope that it will be useful,
#= but WITHOUT ANY WARRANTY; without even the implied warranty of
#= MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#= GNU General Public License for more details.
#=
#= You should have received a copy of the GNU General Public License
#= along with BLOG MOD files; if not, write to the Free Software
#= Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#===========================================================================
#= Blog Mod is a modified version of Blog
#= Version: 1.51 beta
#= Author : Jonathan Beckett
#= Email  : jonbeckett@pluggedout.com
#= Website: http://www.pluggedout.com/projects_blog.php
#= Support: http://www.pluggedout.com/forums/viewforum.php?f=5
#===========================================================================
*/

require "./lib/session.php";
require "./lib/config.php";
require "./lib/database.php";
require "./lib/html.php";
require "./lib/misc.php";
require "./lib/html_user.php";

// get the data from the database
$result = db_prepare();

// start outputting the page

// head tag
print html_pageheader("Blog 2");

// body tag
print html_pagebody();

// banner
print html_pagestart();

if ($_SESSION["userid"]=="") {

	// login attempted - no session data
	if ($_GET["action"]=="postlogin"){
		$html = "<br><table width='400' class='comment' cellspacing='1' cellpadding='1' align='center'>\n"
			."  <tr><td class='title' align='center'><span class='small'><b>Login Failure</b></span></td></tr>\n"
			."  <tr><td class='background' align='center'>\n"
			."<p class='normal' align='center'>You have attempted to login and the login has failed. This could be for a number of reasons, such as an incorrect username and/or password, or a problem with session variables on your web server. If you cannot resolve the issue, please report it to (<a href='http://www.bloggingdoctor.com'>www.bloggingdoctor.com</a>)</p>\n"
			."  </td></tr>\n"
			."</table>\n";
		print $html;
	}

	// show a login form
	$html = "<br><br>"
		."<form method='POST' action='".form_url("blog_exec.php?action=login")."'>\n"
		."<table align='center' class='comment' cellspacing='1' cellpadding='2'>\n"
		."<tr><td colspan='2' class='title' align='center'><span class='small'>Login Form</span></td></tr>\n"
		."<tr><td class='body'><span class='normal'>Username</span></td><td class='body'><input type='text' class='text' name='username' size='20'></td></tr>\n"
		."<tr><td class='body'><span class='normal'>Password</span></td><td class='body'><input type='password' class='text' name='password' size='20'></td></tr>\n"
		."<tr><td colspan='2' class='body' align='center'><input type='submit' value='Login'></td></tr>\n"
		."</table>\n"
		."  <input type='hidden' name='referer' value='".form_url($_SERVER["HTTP_REFERER"])."'>\n"
		."</form>\n";
	print $html;		


} else {
	if ($_GET["action"]=="add_blog") {
		// show the add blog form
		$html = "<table class='comment' cellspacing='1' cellpadding='1' align='center'>\n"
			."  <tr><td class='title' align='center'><span class='small'><b>Add Blog</b></span></td></tr>\n"
			."  <tr><td class='background' align='center'>\n"
			."<form method='POST' action='".form_url("blog_exec.php?action=add_blog")."'>\n"
			."<table border='0' cellspacing='1' cellpadding='1' align='center'>\n"
			."  <tr><td class='body'><span class='normal'>Title</span></td><td class='body'><input type='text' name='title' size='75'></td></tr>\n"
			."  <tr><td class='body'><span class='normal'>Body</span></td><td class='body'><textarea name='body' cols='75' rows='15'></textarea></td></tr>\n"
			."  <tr><td class='body' colspan='2' align='center'><input type='submit' value='Add Blog Entry'></td></tr>\n"
			."</table>\n"
			."</form>\n"
			."  </td></tr>\n"
			."</table>\n";
		print $html;
	}

	if ($_GET["action"]=="edit_blog") {
		// get blog from database
		$con = db_connect();
		$sql = "SELECT * FROM blog WHERE nIdCode=".$_GET["blogid"];
		$result = mysql_query($sql,$con);
		if ($result!=false) {
			// show blog editing form
			$row = mysql_fetch_array($result);

			$html = "<table class='comment' cellspacing='1' cellpadding='1' align='center'>\n"
				."  <tr><td class='title' align='center'><span class='small'><b>Edit Blog</b></span></td></tr>\n"
				."  <tr><td class='background' align='center'>\n"
				."<form method='POST' action='".form_url("blog_exec.php?action=edit_blog")."'>\n"
				."  <input type='hidden' name='blogid' value='".$row["nIdCode"]."'>\n"
				."  <table border='0' cellspacing='1' cellpadding='1' align='center'>\n"
				."  <tr><td class='body'><span class='normal'>Title</span></td><td class='body'><input type='text' name='title' size='75' value='".stripslashes($row["cTitle"])."'></td></tr>\n"
				."  <tr><td class='body'><span class='normal'>Body</span></td><td class='body'><textarea name='body' cols='75' rows='15'>".stripslashes($row["cBody"])."</textarea></td></tr>\n"
				."  <tr><td class='body' colspan='2' align='center'><input type='submit' value='Make Changes'></td></tr>\n"
				."  </table>\n"
				."</form>\n"
				."</td></tr></table>\n";
			print $html;
		}
	}


	if ($_GET["action"]=="remove_blog") {
		// get blog from database
		$con = db_connect();
		$sql = "SELECT * FROM blog WHERE nIdCode=".$_GET["blogid"];
		$result = mysql_query($sql,$con);
		if ($result!=false) {
			// show blog editing form
			$row = mysql_fetch_array($result);

			$html = "<table class='comment' cellspacing='1' cellpadding='1' align='center' width='60%'>\n"
				."  <tr><td class='title' align='center'><span class='small'><b>Remove Blog</b></span></td></tr>\n"
				."  <tr><td class='background' align='center'>\n"
				."<form method='POST' action='".form_url("blog_exec.php?action=remove_blog")."'>\n"
				."  <input type='hidden' name='blogid' value='".$row["nIdCode"]."'>\n"
				."  <table border='0' cellspacing='1' cellpadding='1' align='center' width='100%'>\n"
				."  <tr><td class='body'><span class='normal'>Date</span></td><td class='body'>".$row["dEntryDate"]."</td></tr>\n"
				."  <tr><td class='body'><span class='normal'>Title</span></td><td class='body'>".stripslashes($row["cTitle"])."</td></tr>\n"
				."  <tr><td class='body'><span class='normal'>Body</span></td><td class='body'>".clean_text(stripslashes($row["cBody"]))."</td></tr>\n"
				."  <tr><td class='body' colspan='2' align='center'><input type='submit' value='Delete Current Blog'></td></tr>\n"
				."  </table>\n"
				."</form>\n"
				."</td></tr></table>\n";
			print $html;
		}
	}


	if ($_GET["action"]=="edit_blog_comment") {
		$con = db_connect();
		$sql = "SELECT * FROM blog_comments WHERE nIdCode=".$_GET["blogidc"];
		$result = mysql_query($sql,$con);
		if ($result!=false) {
			// show comment editing form
			$row = mysql_fetch_array($result);
			$html_name = stripslashes($row["cUsername"]);
			$html_email = stripslashes($row["cEMail"]);
			$html_url = stripslashes($row["cURL"]);
			$html_comment = stripslashes($row["cComment"]);

			$html = "<table class='comment' cellspacing='1' cellpadding='1' align='center' width='60%'>\n"
				."  <tr><td class='title' align='center'><span class='small'><b>Edit Blog Comment</b></span></td></tr>\n"
				."  <tr><td class='background' align='center'>\n"
				."<form method='POST' action='".form_url("blog_exec.php?action=edit_blog_comment")."'>\n"
				."  <input type='hidden' name='blogidc' value='".$row["nIdCode"]."'>\n"
				."  <input type='hidden' name='i' value='".$i."'>\n"
				."  <table border='0' cellspacing='1' cellpadding='1' align='center' width='100%'>\n"
				."  <tr><td class='body'><span class='normal'>Name</span></td><td class='body'><input type='text' name='name' size='75' value=\"".$html_name."\"></td></tr>\n"
				."  <tr><td class='body'><span class='normal'>Email</span></td><td class='body'><input type='text' name='email' size='75' value=\"".$html_email."\"></td></tr>\n"
				."  <tr><td class='body'><span class='normal'>URL</span></td><td class='body'><input type='text' name='url' size='75' value=\"".$html_url."\"></td></tr>\n"
				."  <tr><td class='body'><span class='normal'>Comments</span></td><td class='body'><textarea name='body' cols='75' rows='15'>".$html_comment."</textarea></td></tr>\n"
				."  <tr><td class='body' colspan='2' align='center'><input type='submit' value='Edit Blog Comment'></td></tr>\n"
				."  </table>\n"
				."</form>\n"
				."</td></tr></table>\n";
			print $html;
		}

	}

	if ($_GET["action"]=="remove_blog_comment") {

		$con = db_connect();
		$sql = "SELECT * FROM blog_comments WHERE nIdCode=".$_GET["blogidc"];
		$result = mysql_query($sql,$con);

		if ($result!=false) {
			$row = mysql_fetch_array($result);
			$html_name = stripslashes($row["cUsername"]);
			$html_email = stripslashes($row["cEMail"]);
			$html_url = stripslashes($row["cURL"]);
			$html_comment = clean_text(stripslashes($row["cComment"]));

			if ($html_url!="") {
				$url = "[<a href='".$html_url."'>Web</a>]";
			} else {
				$url = "";
			}
			if ($html_email) {
				$email = "[<a href='mailto:".$html_email."'>E-Mail</a>]";
			} else {
				$email = "";
			}

			$html = "<table class='comment' cellspacing='1' cellpadding='1' align='center' width='60%'>\n"
				."  <tr><td class='title' align='center'><span class='small'><b>Remove Blog Comment</b></span></td></tr>\n"
				."  <tr><td class='background' align='center'>\n"
				."<form method='POST' action='".form_url("blog_exec.php?action=remove_blog_comment")."'>\n"
				."  <input type='hidden' name='blogidc' value='".$row["nIdCode"]."'>\n"
				."  <input type='hidden' name='i' value='".$i."'>\n"
				."  <table border='0' cellspacing='1' cellpadding='1' align='center' width='100%'>\n"
				."  <tr><td class='body'><span class='normal'>".$html_name." wrote...".$email."&nbsp;".$url."</td></tr>\n"
				."  <tr><td class='body'><span class='normal'>".$html_comment."</td></tr>\n"
				."  <tr><td class='body' colspan='2' align='center'><input type='submit' value='Delete Blog Comment'></td></tr>\n"
				."  </table>\n"
				."</form>\n"
				."</td></tr></table>\n";
			print $html;
		}
	}
}

// put in any other stuff
print html_pageend();

// finish
print html_pagefooter();

?>