<!--- SourceSafe $Header: /capps/htdocs/capps/basket/showcott.cfm 638   5/02/97 3:24p Mjruser $

	Basket Display (Order Details) Page functions

		1. Empty basket
		2. Remove items
		3. Display Contents of basket and If parameterexists (checking out) is NO then show Basket Nav buttons, checkout, keep shopping

		Accepts the following Params

				User_ID, Company_ID and CheckingOut (toggles the basket editing features on an off)  --->

<!--- If you add any graphics to this page be sure to FULLY qualify the image references. MULTIDOMAIN --->

<CFSET #RemoveItem# = 2> <!--- ACCEPTED VALUES (1) Form able to remove muliple items. OR (2) URL remove single item at a time --->

<CFIF #Parameterexists(Form.LineID)# IS "Yes" OR #Parameterexists(URL.LineID)# is "Yes"> <!--- Remove LINE Item(s) --->

        <CFQUERY NAME = "RemoveItems" DATASOURCE = "#ACBMainDS#">
        DELETE FROM OrderDetails
                WHERE OrderDetail_ID IN (#LineID#)
        </CFQUERY>
        <CFQUERY NAME = "CheckforZeroItems" DATASOURCE = "#ACBMainDS#">
        Select Order_ID FROM OrderDetails
                WHERE Order_ID = #GetOrder.Order_ID#
        </CFQUERY>

        <CFIF #CheckforZeroItems.RecordCount# is 0>
                     <CFSET #KeepShopping# = "YES">    <! ---  Continue Shopping --->
			<CFINCLUDE TEMPLATE="baskmain.cfm">
                        <CFABORT>
        </CFIF>

</CFIF>

<!--- If Shipping or Taxes already exist in the order then delete them --->

<CFIF #Parameterexists(Checkingout)# Is "NO">

        <CFQUERY NAME = "CheckForRefresh1" DATASOURCE="#ACBMainDS#">

                SELECT OrderDetails.OrderDetail_ID, OrderDetails.Order_ID, Orders.Company_ID,
                             OrderDetails.Product_ID, Orders.User_ID, Orders.Orderdate, Orders.Order_ID
                        	FROM Orders INNER JOIN OrderDetails ON Orders.Order_ID = OrderDetails.Order_ID
                        	WHERE (((Orders.User_ID)=#User_ID#) AND ((Orders.Orderdate) Is Null))
                                AND (((OrderDetails.Product_ID)=99999998) OR ((OrderDetails.Product_ID)=99999999)
                                OR ((OrderDetails.Product_ID)=99999997) AND ((Orders.Company_ID) = #CID#))

	</CFQUERY>

	<CFIF #Parameterexists(Form.EmptyBasket)# IS "Yes"><! ---  Remove all Items in basket --->

                        <CFQUERY NAME="RemoveOrderDetails" DATASOURCE = "#ACBMainDS#">
                        DELETE FROM OrderDetails WHERE OrderDetails.Order_ID=#GetOrder.Order_ID#

                        </CFQUERY>

                        <CFQUERY NAME="RemoveOrder" DATASOURCE = "#ACBMainDS#">

                        DELETE FROM Orders WHERE User_ID=#User_ID# and Company_ID=#CID# and Orderdate is Null

                        </CFQUERY>

			<CFSET #KeepShopping# = "YES">    <! ---  Continue Shopping --->
			<CFINCLUDE TEMPLATE="baskmain.cfm">
			<CFABORT>
	</CFIF>


        <CFIF #CheckForRefresh1.RecordCount# IS NOT 0>

                <CFINCLUDE TEMPLATE="#Root#/basket/cancel.cfm">

        </CFIF>

</CFIF>

<!--- Select the line items from orderdetails, the price of the product plus its options as bprice and
	price of the product plus its options times the qty for extended price --->


<CFQUERY NAME = "showcont" DATASOURCE = "#ACBMainDS#">

        SELECT  OrderDetails.OrderDetail_ID, OrderDetails.Order_ID, Orders.Company_ID,
        		OrderDetails.Product_ID, OrderDetails.Qty, OrderDetails.Price, OrderDetails.ProductTitle,
        		OrderDetails.Weight, OrderDetails.Opt_IDs, OrderDetails.OptTitles, OrderDetails.OptsWeight,
                        OrderDetails.OptsPrice, OrderDetails.PartNumber, ((Price + OptsPrice)) AS bprice,
                (qty * (Price + optsPrice)) AS extprice, Orders.User_ID, Orders.Orderdate, Orders.Order_ID
					FROM OrderDetails INNER JOIN Orders ON OrderDetails.Order_ID = Orders.Order_ID
                			WHERE (((Orders.User_ID)=#User_ID#) AND ((Orders.Orderdate) Is Null) AND ((Orders.Company_ID) = #CID#)) Order by Company_ID, Product_ID

</CFQUERY>

<!--- Insert into the Total table the extended price of each line --->

<CFIF #ShowCont.RecordCount# is not 0>

        <CFQUERY NAME = "TempTotals" DATASOURCE = "#ACBMainDS#">

             INSERT INTO total (Order_ID, Extprice)
                        SELECT Orders.Order_ID, (QTY * (Price + optsprice)) AS EXTPRICE
                        FROM Orders INNER JOIN OrderDetails ON Orders.Order_ID = OrderDetails.Order_ID
                        WHERE (((Orders.User_ID)=#User_ID#) AND ((Orders.Orderdate) Is Null) AND ((Orders.Company_ID) = #CID#))

        </CFQUERY>

		<!--- Select from the Total the sum of all the extprice --->
        <CFQUERY NAME = "total" DATASOURCE = "#ACBMainDS#">
                SELECT Sum (total.extprice) AS Totalprice
					FROM Total
						WHERE Order_ID = #Showcont.Order_ID#

		</CFQUERY>

		<!--- Clean up the Totals Table --->
        <CFQUERY NAME = "DELETEtotal" DATASOURCE = "#ACBMainDS#">
                DELETE FROM Total
					WHERE ((Total.Order_ID=#ShowCont.Order_ID#))
		</CFQUERY>

<CFELSE>


	        <CFSET #ERRORMessage# = "La orden esta vacia, usar el boton 'Seguir comprando'.">  <!--- Error Message to send to user if the Basket is empty --->
	        <CFSET #BasketMessage# = "Contenido actual de la Orden">

</CFIF>

<!--- Default basket Message to send to user, otherwise set in another file.--->

<CFIF #Parameterexists(BasketMessage)# is "NO">

				<CFSET #BasketMessage# = "Detalles de la Orden Actual">
</CFIF>


<CFIF #Parameterexists(NOStartAndEndHTMLTags)# is "NO">  <!--- Showcott.cfm (basket display) can be called alone or cfincluded into other templates --->

        <HTML>
        <HEAD>
                <title><CFOUTPUT>#BasketMessage#</CFOUTPUT> (Contenido de la Orden)</title>
        </head>

        <CFOUTPUT>

<TITLE>#Company.CompanyName# Liquidacin</TITLE>

</HEAD>

        <BODY <CFIF #trim(Company.BGImage)# IS NOT "">BACKGROUND="/#Company.directory#/images/#Company.BGImage#"</CFIF>
                                <CFIF #trim(Company.BGColor)# IS NOT "">BGCOLOR="###Company.BGColor#"</CFIF>
                                <CFIF #trim(Company.Btext)# IS NOT "">TEXT="###Company.Btext#"</CFIF>
                                <CFIF #trim(Company.Link)# IS NOT "">LINK="###Company.Link#"</CFIF>
                                <CFIF #trim(Company.ALink)# IS NOT "">ALINK="###Company.ALink#"</CFIF>
                                <CFIF #trim(Company.VLink)# IS NOT "">VLINK="###Company.VLink#"</CFIF>>
</CFOUTPUT>

</CFIF>

<CENTER>
<CFIF #parameterexists(checkingout)# is "NO">      <!--- CHECKOUT DIFFERENCE --->
<CFOUTPUT>
        <FORM ACTION="#AHrefString_Root#basket/showcott.cfm#Form_ID_String#" METHOD=POST>
</CFOUTPUT>
</CFIF>

<table width=600 border=0 cellpadding=2 cellspacing=0>
<tr>

<!--- CHECKOUT DIFFERENCE - TABLE DATA IS 5 COLUMNS WITH REMOVE OPTION, OTHERWISE 4 COLUMN --->

	<td COLSPAN=<CFIF #parameterexists(checkingout)# is "NO">5<CFELSE>4</CFIF> align=CENTER>
                <font FACE="<CFOUTPUT>#FontFace#" size=4><B>#BasketMessage#</CFOUTPUT></b></font>
                <BR>
	</TD>
	</TR>

	<tr>

        <td width=330 align=left BGCOLOR="#ef eF eF">
                <font size=2 FACE="<CFOUTPUT>#FontFace#</CFOUTPUT>"><b>Item(s) en la Orden</b></font>
                <CFIF #parameterexists(checkingout)# is "NO">
                <font size=2 FACE="<CFOUTPUT>#FontFace#</CFOUTPUT>"> (siga el nombre linkeado para modificar)</font>
                </CFIF>
	</td>

        <td width=50 align=center BGCOLOR="#ef eF eF">
                <font size=2 FACE="<CFOUTPUT>#FontFace#</CFOUTPUT>"><b>Cant.</b></font>
	</td>

        <td width=70 align=right BGCOLOR="#ef eF eF">
                <font size=2 FACE="<CFOUTPUT>#FontFace#</CFOUTPUT>"><b>Costo unit.</b></font>
	</td>

        <td width=80 align=right BGCOLOR="#ef eF eF">
                <font size=2 FACE="<CFOUTPUT>#FontFace#</CFOUTPUT>"><b>Precio Tot</b></font>
	</td>


	<CFIF #parameterexists(checkingout)# is "NO">         <!--- CHECKOUT DIFFERENCE  - DONT SHOW REMOVE HEADER--->
                <td width=70 align=center BGCOLOR="#ef eF eF">
                        <font size=2 FACE="<CFOUTPUT>#FontFace#</CFOUTPUT>"><b>Remover</b></font><br>
		</td>
	</CFIF>

	</tr>

      <CFIF #Parameterexists(ErrorMessage)# is "Yes">
       <TR>
       <TD COLSPAN=5 ALIGN=CENTER>

                <font FACE="<CFOUTPUT>#FontFace#" size=3><B>#ErrorMessage#</B></CFOUTPUT></FONT>
       </TD>
       </TR>

<CFELSE>
<CFOUTPUT QUERY="showcont">

	<tr>
        <td <CFIF #Product_ID# is 99999999 or #Product_ID# is 99999998 or #Product_ID# is 99999997> <CFIF #Product_ID# is not 999999971>WIDTH=500 ALIGN=RIGHT COLSPAN=3 <CFELSE>WIDTH=580 COLSPAN=4</CFIF> <CFELSE>WIDTH=330
        </CFIF>>
        <FONT FACE="#FontFace#" SIZE=2><CFIF #Trim(showcont.PartNumber)# is Not "">#showcont.PartNumber# - </FONT></CFIF>

        <CFIF #parameterexists(checkingout)# is "NO">    <!--- CHECKOUT DIFFERENCE - DONT SHOW LINKED ProductTitle--->
                <a href = "#AHrefString_Root#basket/editdetl.cfm#ID_String#&Product_ID=#showcont.product_ID#&Line_ID=#Showcont.OrderDetail_ID#&ECompany_ID=#showcont.Company_ID#">
          <FONT SIZE=2 FACE="#FontFace#"><B>#showcont.ProductTitle#</B></FONT></a>
        <CFELSE>
                <FONT SIZE=2 FACE="#FontFace#"><B>#showcont.ProductTitle#</B></FONT>
        </CFIF>

        <CFIF #showcont.OptTitles# is not ""><BR>
                <FONT FACE="#FontFace#" SIZE=1>#showcont.optTitles# </FONT><CFIF #showcont.optsprice# is not 0><FONT FACE="#FontFace#" SIZE=2><EM>Options Total:</EM> #DollarFormat(Showcont.optsPrice)#</font></CFIF>
        </CFIF>
	</td>

        <CFIF #Product_ID# is not 99999998 and #Product_ID# is not 99999999 AND #Product_ID# is not 99999997>

                <td width=50 align=center><FONT FACE="#FontFace#" SIZE=2><B>#showcont.Qty#</B></FONT></td>

                <td width=70 align=right><FONT FACE="#FontFace#" SIZE=2>#DollarFormat(showcont.bprice)# </FONT></td>
        </CFIF>

        <CFIF #Product_ID# is not 999999971>
                <td width=80 align=right BGCOLOR="##ef eF eF"><FONT FACE="#FontFace#" SIZE=2><B>#DollarFormat(showcont.extprice)#</B></FONT></td>
        </CFIF>

	<CFIF #parameterexists(checkingout)# is "NO">            <!--- CHECKOUT DIFFERENCE - DON'T DISPLAY REMOVE CHECKBOX--->
		<td width=70 align=center>
						<CFIF #RemoveItem# is 1>
                        			<input type=checkbox name = "lineid" VALUE ="#Showcont.OrderDetail_ID#">
						<CFELSE>
                                                                <font FACE="#FontFace#" size=2><A HREF = "#AHrefString_Root#basket/showcott.cfm#ID_String#&LineID=#Showcont.OrderDetail_ID#">X</A></FONT>
						</CFIF>
		<br></td>
       	</CFIF>
	</tr>
                  <CFSET #LastCompanyDisplayed_ID# = #showCont.Company_ID#>

  </CFOUTPUT>

<CFOUTPUT>

<td COLSPAN=3 ALIGN=RIGHT>
        <FONT FACE="#FontFace#" SIZE=2><b>Subtotal: </b></FONT></td>
        <td width=80 align=right COLSPAN=1 ALIGN=RIGHT BGCOLOR="##cf cF cF">
                <FONT FACE="#FontFace#" SIZE=2><b>#DollarFormat(TOTAL.TOTALPRICE)#</b></FONT></td>

<!--- CHECKOUT DIFFERENCE --->
<CFIF #parameterexists(checkingout)# is "NO">
        <TD><PRE> </PRE></TD>
</CFIF>
</tr>

</CFOUTPUT>

</CFIF>

<CFIF #parameterexists(checkingout)# is "NO">                  <!--- CHECKOUT DIFFERENCE - DONT SHOW BASKET POST BUTTONS--->

	<TR>
		<TD COLSPAN=5>


			<CFIF #Parameterexists(ErrorMessage)# is "NO">
				<INPUT TYPE=Submit Name= "KeepShopping" value="Seguir comprando">
				<INPUT TYPE=Submit Name= "EmptyBasket" value="Cancelar Orden">

	                        	<CFIF #RemoveItem# is 1>
					<INPUT TYPE=Submit Name= "RemoveItems" value="Remover Item(s)">
				</CFIF>

				<INPUT TYPE=Submit Name= "CheckOut" value="    Liquidar orden     ">

			<CFELSE>

				<INPUT TYPE=Submit Name= "EmptyBasket" value="   Seguir comprando  ">

			</CFIF>
			<input type=hidden name = "Line_ID" value = "99999999999">

		</TD>
	</TR>

	</TABLE>
	</FORM>

<CFELSE>
	</TABLE>
</CFIF>

</CENTER>


<CFIF #Parameterexists(NOStartAndEndHTMLTags)# is "NO">

        </BODY></HTML>

</CFIF>