
<!--- SourceSafe $Header: /capps/template/capps/Shared/functions/form2sql.cfm 403   4/23/97 8:32p Mjruser $ --->

<!--- **** DON'T ALLOW form.tablename or url.tablename to be used --->

<CFIF #ParameterExists(FORM.TableName)# IS "Yes" OR #ParameterExists(URL.TableName)# IS "Yes">
        Not allowed..<CFABORT>
</CFIF>

<!---   (THIS TEMPLATE MUST BE CFINCLUDED INTO THE FILE BEING CALLED BY THE FORM ACTION)

        Template Uses Form.FieldNames and Evaluate to create lists based on form submission.:

                1. Dynamic SQL Statements Insert, Update Select supported.
                2. Special delimited list with custom delimiters

        Requires following variables:

                1. #Form.FieldNames#    List of form fields submitted by user
                2. #TableName#          Name of Table To be updated
                3. [#IDVarNames#]       IF (U)pdating a List of ID Varitables for WHERE ie Form.Category_ID, or URL.Category_ID.

                                        or idea if extra values need to be inserted into the database then this could be used. ie for (I)nsert

        Resulting variables are:

                1. #ValidFormFieldList#    After purging with ExcludedFormList Results: SUBJECT,COMMENTTYPE,MESSAGETEXT
                2. #FieldCount#            Number of fields to be modified.
                3. #FieldList#             Results: ('#Form.SUBJECT#,#Form.COMMENTTYPE#,#Form.MESSAGETEXT#') for use in evaluate.
                4. #ListWithQuotes#        Results of evaluate: 'Subject', 'Request', 'Testing Testing'
                5. #ListDelimitedSpecial#  Results of evaluate: [begin]~Subject~[delimiter]~Comment~[delimiter]~Testing Testing~[end]
                6. #ValidInsertList#       SUBJECT='Subject', COMMENTTYPE='Request', MESSAGETEXT='Testing Testing'

                7. #ValidInsertStatement#  SUBJECT='Subject', COMMENTTYPE='Request', MESSAGETEXT='Testing Testing',
                                                WHERE PrefixRemoved.#IDVarNames# = #Form.Category_ID#  (Var and string form)

       Optional Parameters:

                1. ValidateNumeric, ValidateDateTime DEFAULT 'YES' IF set to 'NO' Numeric and/or DateTime are handled as TEXT and wrapped in single quotes.
                2. EVERY CFPARAM below can be modified. --->


<CFPARAM NAME="ReturnWQNamed"         DEFAULT = "ListWithQuotes">       <!--- Default return list as 'Variable Named' --->
<CFPARAM NAME="ReturnVFFNamed"        DEFAULT = "ValidFormFieldList">
<CFPARAM NAME="ReturnDSNamed"         DEFAULT = "ListDelimitedSpecial">
<CFPARAM NAME="ReturnVINamed"         DEFAULT = "ValidInsertList">
<CFPARAM NAME="ValidateNumeric"       DEFAULT = "YES">                <!--- If numeric wrap in '' or not ? --->
<CFPARAM NAME="ValidateDateTime"      DEFAULT = "YES">                <!--- If date convert to ODBC date format or just wrap as text ''.--->
<CFPARAM NAME="ExcludedFormList"      DEFAULT = "NOTH!ING">           <!--- Form fields to be excluded from the action i.e. Submit buttons with names. --->
<CFPARAM NAME="Form2SQLType"          DEFAULT = "I">                  <!--- (I)nsert, (U)pdate, (D)ebug, (N)othing  Default to (I)--->
<CFPARAM NAME="Form2SQLDS"            DEFAULT = "#ACBMainDS#">        <!--- The Datasource for the query Default to #ACBMainDS# 'StoreBuilder' --->
<CFPARAM NAME="IDVarNames"            DEFAULT = "">                   <!--- Will Error if left blank --->
<CFPARAM NAME="IDVarNamesSep"         DEFAULT = "AND">                <!--- If more than one criteria and/or criteria together --->

<!--- For Creating the specially delimited list --->

<CFPARAM NAME="ListDelimitedSpecial"    DEFAULT ="~~begin~~">
<CFPARAM NAME="SEP5"                    DEFAULT ="~~delimiter~~">
<CFPARAM NAME="SEP6"                    DEFAULT ="~~end~~">

<CFSET #TRASHSTRING# = "">
<CFSET #LoopCount# = 0>
<CFSET #FieldCount# = 0>

<!--- Changes below here have not been tested well so DON'T --->

<!--- Optional to update 1 to x Fields named Field1,Field2,Field3... --->

<CFSET #NumberedInsertList# = "">
<CFSET #SEP1# = ",">

<!--- FORM.Values List I.E the values of the fields submitted--->

<CFSET #FieldList# = "('">           <!--- Left side of string --->
<CFSET #SEP2# = ",">                 <!--- Delimited with commas --->
<CFSET #ListWithQuotes# ="">         <!--- The initial values --->

<!--- For Creating the dynamic Update Statement --->

<CFSET #ValidFormFieldList# = "">
<CFSET #SEP3# = ",">

<!--- For Creating the dynamic Insert Statement --->

<CFSET #ValidInsertList# = "">
<CFSET #SEP4# = "=">

<!--- Form.fieldNames is tested against ExcludedFormList to create ValidFormFieldList --->

<CFLOOP INDEX="CountFieldNames" LIST="#Form.FieldNames#" DELIMITERS=",">

        <CFIF (#ExcludedFormList# DOES NOT CONTAIN "#CountFieldNames#" AND #TRIM(Evaluate('Form.#CountFieldNames#'))# IS NOT "")>

                <CFSET #FieldCOUNT# = #FieldCOUNT# + 1>
                <CFSET #ValidFormFieldList# ="#ValidFormFieldList##CountFieldNames#,"> <!--- FIXED SEPERATOR --->

        </CFIF>

</CFLOOP>    <!--- Catch if 0 drop out ? --->


<!--- Remove the end comma and ValidFormFieldList is valid --->

<CFSET #ValidFormFieldList# = #RemoveChars(ValidFormFieldList, (Len(ValidFormFieldList)), 1)#>


<!--- Loop Throught the list using Evaluate('Form.#ListFormFieldsNames#') creating 2 LISTS 1. ListWithQuotes 2. ValidInsertList   --->

<CFLOOP INDEX="ListFormFieldNames" LIST="#ValidFormFieldList#" DELIMITERS=",">

        <CFSET #LoopCount# = #LoopCount# + 1>

        <CFIF #LoopCount# is #FieldCount#> <!--- If Last Change Seperator --->
                <CFSET #Sep1# = ",">
                <CFSET #Sep2# = "')">
                <CFSET #Sep5# = "#Sep6#">

        </CFIF>

        <CFSET #NumberedInsertList# = "#NumberedInsertList# Field#LoopCount# #Sep1#">              <!--- Ignore --->

        <CFSET #FieldList# = "#FieldList###Form.#ListFormFieldNames####Sep2#">                     <!--- Creating the #Form.FieldName# need for evaluate --->

         <CFIF #IsDate(Evaluate('Form.#ListFormFieldNames#'))# AND #ValidateDateTime# IS "Yes">    <!--- IF DATE TIME STRING CONVERT TO ODBC DATE TIME --->

                <CFSET #ListWithQuotes# =       "#ListWithQuotes##CreateODBCDateTime(Evaluate('Form.#ListFormFieldNames#'))#,">
                <CFSET #ValidInsertList# =      "#ValidInsertList##ListFormFieldNames##Sep4##CreateODBCDateTime(Evaluate('Form.#ListFormFieldNames#'))#, ">
                <CFSET #ListDelimitedSpecial# = "#ListDelimitedSpecial##CreateODBCDateTime(Evaluate('Form.#ListFormFieldNames#'))##Sep5#">

        <CFELSEIF #IsNumeric(Evaluate('Form.#ListFormFieldNames#'))# AND #ValidateNumeric# IS "Yes"><!--- ELSEIF Numeric set to value --->

                <CFSET #ListWithQuotes# =       "#ListWithQuotes##Evaluate('Form.#ListFormFieldNames#')#,">
                <CFSET #ValidInsertList# =      "#ValidInsertList##ListFormFieldNames##Sep4##Evaluate('Form.#ListFormFieldNames#')#, ">
                <CFSET #ListDelimitedSpecial# = "#ListDelimitedSpecial##Evaluate('Form.#ListFormFieldNames#')##Sep5#">

        <CFELSE>                                                                                    <!--- ELSE Text wrap in quotes --->
                <CFSET #TRASHSTRING#  =         "#Evaluate('Form.#ListFormFieldNames#')#">
                <CFSET #TRASHSTRING#  =         "#ReReplace("#TRASHSTRING#", "'", "''", "ALL")#">
                <CFSET #ListWithQuotes# =       "#ListWithQuotes#'#PreserveSingleQuotes(TRASHSTRING)#',">
                <CFSET #ValidInsertList# =      "#ValidInsertList##ListFormFieldNames##Sep4#'#PreserveSingleQuotes(TRASHSTRING)#', ">
                <CFSET #ListDelimitedSpecial# = "#ListDelimitedSpecial##Evaluate('Form.#ListFormFieldNames#')##Sep5#">

        </CFIF>

</CFLOOP>


<!--- Complete the list creation by removing extra end chars and renaming as needed --->

<CFSET #NumberedInsertList# =   #RemoveChars(NumberedInsertList, (Len(NumberedInsertList)), 1)#>                  <!--- Remove end Comma --->

<CFSET #TRASHSTRING# = #SETVariable(ReturnWQNamed, RemoveChars(ListWithQuotes, (Len(ListWithQuotes)), 1))#>
<CFSET #TRASHSTRING# = #SETVariable(ReturnVFFNamed, RemoveChars(ValidFormFieldList, (Len(ValidFormFieldList)), 0))#>  <!---- Did nothing ---->
<CFSET #TRASHSTRING# = #SETVariable(ReturnDSNamed, ListDelimitedSpecial)#>
<CFSET #TRASHSTRING# = #SETVariable(ReturnVINamed, RemoveChars(ValidInsertList, (Len(ValidInsertList)-1), 2))#>


<!--- Finish up creating the SQL Insert statment here --->
<CFIF #IDVarNames# IS NOT "">

        <CFSET #GetPeriodPosition# = "#FindNoCase('.', '#IDVarNames#')#">

        <CFSET #ValidInsertStatement# = "#ValidInsertList#  WHERE #RemoveChars(IDVarNames, 1, GetPeriodPosition)# = #Evaluate('###IDVarNames###')#">

<CFELSEIF #Form2SQLtype# is NOT "U">            <!--- Create a sample output formatted the same for use in (D)ebug --->

        <CFSET #ValidInsertStatement# = "#ValidInsertList#  WHERE Company_ID=2">

<CFELSE>

        Error: IDVarNames is Required!<br>
        IF (U)pdating a List of ID Varitables for WHERE ie Form.Category_ID, or URL.Category_ID.<CFABORT>

</CFIF>


<CFIF #Form2SQLType# IS "I">

        <CFQUERY NAME= "Form2SQLTypeI" DATASOURCE = "#ACBMainDS#">
                Insert into #TableName# (#ValidFormFieldList#, Company_ID)
                        VALUES (#PreserveSingleQuotes(ListWithQuotes)#, #CID#)
        </CFQUERY>

<CFELSEIF #Form2SQLType# IS "U">

<CFQUERY NAME= "Form2SQLTypeU" DATASOURCE = "#Form2SQLDS#">
        UPDATE #TableName# SET #PreserveSingleQuotes(ValidInsertStatement)#
</CFQUERY>

<CFELSEIF #Form2SQLType# IS "D" OR #Form2SQLType# IS "N">

           <CFIF #Form2SQLType# IS "N"><!--<CFELSE></CFIF>

        <CFOUTPUT> <font size=2>
                <B>Incoming Data: (Form.FieldNames)</B><BR>#Form.FieldNames#

                <hr><B>FieldCount:</B> (#FieldCOUNT#)<B>ValidFormFieldList</B> after compair with <B>ExcludedFormList:</B> #ExcludedFormList#: #ValidFormFieldList#

                <hr><B>Evaluate('#ReturnWQNamed#'):</B> #Evaluate('#ReturnWQNamed#')#

                <hr><B>FieldList:</B> #FieldList#



                <hr WIDTH=50% NOSHADE><B>Evaluate(FieldList):</B> #Evaluate(FieldList)#

                <hr>SQL="Insert into <B>#TableName#</B> (<B>#ValidFormFieldList#</B>)
                        VALUES (<B>#Evaluate('ListWithQuotes')#</B>)">

                <HR>SQL="UPDATE <B>#TableName#</B> SET <B>#ValidInsertStatement#</B>">

                <HR WIDTH=50% NOSHADE><B>ValidInsertStatement(After word 'SET' Above):</B><br>  #ValidInsertStatement#

                <HR><B>ValidInsertList:</B><br>#ValidInsertList#

                <HR><B>ListDelimitedSpecial:</B><br> #ListDelimitedSpecial#</FONT>

        </CFOUTPUT>

      <CFIF #Form2SQLType# IS "N">--><CFELSE></CFIF>

</CFIF>