
<!--- SourceSafe $Header: /capps/template/capps/Security/getuser.cfm 263   4/28/97 10:31p Mjruser $
	Authenticates a given user identity
	Include this template at the top of any page you need to secure.

	Authentication attempts are made in the following order:
	(Existence of the token/password is assumed.)
		(1) [Login] Form.Username and Form.Password
		(2) [URL parameters] User_ID and st
		(C) #Client.CAPPS_User_ID# AND #Client.CFToken#
		(3) Cookie.CAPPS_User_ID and Cookie.CAPPS_st
		(4) If #AutoCreateUser#="YES", create a new user and proceed.
		(5) Username "Guest" and an empty password ("").

	When authentication fails we do one of the following:
		(1) Jump to a failure page if we're authenticating a login form.
		(2) Prompt the user to login.

	REQUIRED INPUT (typically declared in Project.cfm)
	SecurityDS: ODBC Datasource name of security database
	SecurityMapping: Mapping to the security templates path
	AutoCreateUser: "YES" to log unknown users and allow them to proceed.
		- (Note that PreviousSession="" indicates a new user)
	SessionTimeout: for usage tracking;
		- Log a new session to TimeLastSessionBegan if SessionTimeout < (Now - TimeLastAuthenticated).
	RequireSessionLogin: "YES" to force a login the session has timed out.

	OPTIONAL INPUT (typically declared in Project.cfm)
	CustomLoginFailureTemplate: template to include for failed login attempts
		- (defaults to "/#SecurityMapping#/logininv.cfm")

	OUTPUT
	User.* (All fields from the Users table; i.e. User_ID, FirstName, etc.)
	User.AuthenticatedBy: "Form", "URL", "Cookies", "AutoUser", or "Guest"
	ID_String: &User_ID=#User_ID#&st=#st# or empty ("")
		- This is set only for non-cookie browsers in order to pass info on the URL.
--->


<!--- If client's browser supports cookies we are not updating field TimeLastAuthenticated
	unless new session occured. However we are updating every time the cookie CAPPS_TimeLastAuthenticated.
	Therefore we have to use in following queries cookie if it exists or field if not.
--->

<CFPARAM NAME="SecurityDS" DEFAULT = "#DSMaster.SecurityDS#">

<CFSET CookieUser_ST = "#DSMaster.DSCookieName#_ST">
<CFSET CookieUser_ID = "#DSMaster.DSCookieName#_USER_ID">
<CFSET CookieUser_OID = "#DSMaster.DSCookieName#_OBJECT_ID">
<CFSET CookieUser_LA = "#DSMaster.DSCookieName#_TIMELASTAUTHENTICATED">

<CFSET #NST#=((Now()-Int(Now())+Rand())*90000 Mod 9000+1000)>

<CFIF #ParameterExists(DisableCookies)# IS "no">
        <CFSET #DisableCookies# = "NO">
</CFIF>

<CFIF #DisableCookies# IS "NO" AND NOT Parameterexists(NCP)>
<CFIF Evaluate("Parameterexists(Cookie.#CookieUser_ID#)")>
<CFIF Evaluate("Parameterexists(Cookie.#CookieUser_ST#)")>

        <CFSET #CookieAuthenticationEnabled# = "">
</CFIF>
</CFIF>
</CFIF>
<CFIF Evaluate("Parameterexists(Cookie.#CookieUser_LA#)") >
        <CFSET #TimeLastAuthenticated# = Evaluate("Cookie.#CookieUser_LA#")>
<CFELSE>
        <CFSET #TimeLastAuthenticated# = "Users.TimeLastAuthenticated">
</CFIF>

<!--- Get the user record --->

<CFIF #ParameterExists(Form.userName)# is "NO">
        <CFSET #UserName# = "">
<CFELSE>
        <CFSET #UserName# = "#Form.UserName#">
</CFIF>


<!--- Are we validating a login prompt? --->
<CFIF (#ParameterExists(Form.Username)# IS "YES" AND #Len(#UserName#)# GTE 1)>

	<CFQUERY NAME="User" DATASOURCE=#SecurityDS#>
		SELECT Users.*,
			'Form' AS AuthenticatedBy,
                        '&User_ID=' + {fn CONVERT(Users.User_ID,SQL_VARCHAR)} + '&st=' + {fn CONVERT(Users.st,SQL_VARCHAR)} AS ID_String,
			{fn NOW()} AS CurrentTime,
			( { fn YEAR( { fn NOW() })} - { fn YEAR( #PreserveSingleQuotes(TimeLastAuthenticated)# )} ) * 525600 +
			( { fn DAYOFYEAR( { fn NOW() })} - { fn DAYOFYEAR( #PreserveSingleQuotes(TimeLastAuthenticated)# )} ) * 1440 +
			( { fn HOUR( { fn NOW() })} - { fn HOUR( #PreserveSingleQuotes(TimeLastAuthenticated)# )} ) * 60 +
		    ( { fn MINUTE( { fn NOW() })} - { fn MINUTE( #PreserveSingleQuotes(TimeLastAuthenticated)# )} ) AS TimeSinceLastAuthenticated
		    FROM Users
			WHERE Username='#Form.Username#'
			AND Password='#Form.Password#'
	</CFQUERY>
	<CFSET #TimeSinceLastAuthenticated# = #User.TimeSinceLastAuthenticated#>
        <CFSET #IsNewSession# = "YES">
<CFELSE>

<!--- Is User_ID passed on the URL? --->
<CFIF #ParameterExists(User_ID)# IS "YES">
	<CFQUERY NAME="User" DATASOURCE=#SecurityDS#>
		SELECT Users.*,	'URLParams' AS AuthenticatedBy,

                   <CFIF #ParameterExists(CookieAuthenticationEnabled)# IS "yes">
                                 <CFIF Evaluate("Cookie.#CookieUser_ID#") IS #User_ID#>
                                        '' AS ID_String,
                                 <CFELSE>
                                         '&User_ID=' + {fn CONVERT(Users.User_ID,SQL_VARCHAR)} + '&st=' + {fn CONVERT(Users.st,SQL_VARCHAR)} AS ID_String,
                                 </CFIF>

                       <CFELSE>

                        '&User_ID=' + {fn CONVERT(Users.User_ID,SQL_VARCHAR)} + '&st=' + {fn CONVERT(Users.st,SQL_VARCHAR)} AS ID_String,

                        </CFIF>

			 {fn NOW()} AS CurrentTime,
			( { fn YEAR( { fn NOW() })} - { fn YEAR( #PreserveSingleQuotes(TimeLastAuthenticated)# )} ) * 525600 +
			( { fn DAYOFYEAR( { fn NOW() })} - { fn DAYOFYEAR( #PreserveSingleQuotes(TimeLastAuthenticated)# )} ) * 1440 +
			( { fn HOUR( { fn NOW() })} - { fn HOUR( #PreserveSingleQuotes(TimeLastAuthenticated)# )} ) * 60 +
		    ( { fn MINUTE( { fn NOW() })} - { fn MINUTE( #PreserveSingleQuotes(TimeLastAuthenticated)# )} ) AS TimeSinceLastAuthenticated

			FROM Users
			WHERE User_ID=#User_ID#
			AND st=#st#
	</CFQUERY>

	<CFSET #TimeSinceLastAuthenticated# = #User.TimeSinceLastAuthenticated#>

<CFELSE>

<CFIF #ParameterExists(CookieAuthenticationEnabled)# IS "yes">
<!--- Are there user cookies? --->
	<!--- Note: Checking the existence of a cookie creates it. --->
        <CFIF Evaluate("Cookie.#CookieUser_ID#") GT 0>
                <CFQUERY NAME="User" DATASOURCE=#SecurityDS#>
                        SELECT Users.*,
				'Cookies' AS AuthenticatedBy,
				'' AS ID_String,
				{fn NOW()} AS CurrentTime,
				( { fn YEAR( { fn NOW() })} - { fn YEAR( #PreserveSingleQuotes(TimeLastAuthenticated)# )} ) * 525600 +
				( { fn DAYOFYEAR( { fn NOW() })} - { fn DAYOFYEAR( #PreserveSingleQuotes(TimeLastAuthenticated)# )} ) * 1440 +
				( { fn HOUR( { fn NOW() })} - { fn HOUR( #PreserveSingleQuotes(TimeLastAuthenticated)# )} ) * 60 +
			    ( { fn MINUTE( { fn NOW() })} - { fn MINUTE( #PreserveSingleQuotes(TimeLastAuthenticated)# )} ) AS TimeSinceLastAuthenticated
			    FROM Users
                                WHERE User_ID=#Evaluate("#CookieUser_ID#")#
                                AND st=#Evaluate("#CookieUser_ST#")#
                </CFQUERY>

		<CFSET #TimeSinceLastAuthenticated# = #User.TimeSinceLastAuthenticated#>

        </CFIF>
<CFELSE>

<!--- No user info was passed; Create a new user? --->
<CFIF #AutoCreateUser# IS "YES">
	<!--- Insert a new user record --->
        <CFQUERY NAME="CreateUser" DATASOURCE="#SecurityDS#">
                INSERT INTO Users
                        (Username, Password, IP, Host, Browser, HttpFrom, ST
                        )
			VALUES
			('',
			'',
			'#CGI.REMOTE_ADDR#',
                        '#CGI.HTTP_HOST#',
			'#CGI.HTTP_USER_AGENT#',
                        '#CGI.HTTP_FROM#',
                        #NST#
                        )
        </CFQUERY>

	<!--- Get the new user record --->
        <CFQUERY NAME="User" DATASOURCE=#SecurityDS# MAXROWS=1>
                SELECT Users.*,
			'AutoUser' AS AuthenticatedBy,
			'&User_ID=' + {fn CONVERT(Users.User_ID, SQL_VARCHAR)} + '&st=' + {fn CONVERT(Users.st, SQL_VARCHAR)} AS ID_String,
			{fn NOW()} AS CurrentTime,
		    0 AS TimeSinceLastAuthenticated
		    FROM Users
                        WHERE IP='#CGI.REMOTE_ADDR#'
			AND Username=''
                        ORDER BY User_ID DESC
        </CFQUERY>

	<CFSET #TimeSinceLastAuthenticated# = #User.TimeSinceLastAuthenticated#>

<!---WHERE IP='#CGI.REMOTE_ADDR#'--->

<CFELSE>

<!--- ELSE Attempt to login as 'Guest' --->
<CFQUERY NAME="User" DATASOURCE=#SecurityDS#>
        SELECT Users.*,
		'Guest' AS AuthenticatedBy,
		'&User_ID=' + {fn CONVERT(Users.User_ID,SQL_VARCHAR)} + '&st=' + {fn CONVERT(Users.st,SQL_VARCHAR)} AS ID_String,
		{fn NOW()} AS CurrentTime,
		( { fn YEAR( { fn NOW() })} - { fn YEAR( #PreserveSingleQuotes(TimeLastAuthenticated)# )} ) * 525600 +
		( { fn DAYOFYEAR( { fn NOW() })} - { fn DAYOFYEAR( #PreserveSingleQuotes(TimeLastAuthenticated)# )} ) * 1440 +
		( { fn HOUR( { fn NOW() })} - { fn HOUR( #PreserveSingleQuotes(TimeLastAuthenticated)# )} ) * 60 +
	    ( { fn MINUTE( { fn NOW() })} - { fn MINUTE( #PreserveSingleQuotes(TimeLastAuthenticated)# )} ) AS TimeSinceLastAuthenticated
	    FROM Users
		WHERE Username='Guest'
                AND Password=''
</CFQUERY>
		<CFSET #TimeSinceLastAuthenticated# = #User.TimeSinceLastAuthenticated#>
</CFIF>
</CFIF>
</CFIF>
</CFIF>

<!--- Is the user valid? --->
<CFIF #User.RecordCount# EQ 1>
	<!--- The user is valid, but we may force a login --->
	<!--- Is this a new "session" (i.e. is LastVisit old) ? --->
        <CFIF #TimeSinceLastAuthenticated# GREATER THAN #SessionTimeout#>
                <CFIF #SessionTimeout# IS NOT 0>
                        <CFSET #IsNewSession# = "YES">
			<!--- Require a session login? --->
                        <CFIF #RequireSessionLogin# IS "YES">
                                <CFIF #ParameterExists(Form.Username)# IS "no">
                                        <CFIF #ParameterExists(CustomLoginFailureTemplate)# IS "YES">
                                                <CFINCLUDE TEMPLATE="#CustomLoginTemplate#">
                                        <CFELSE>
                                                <CFINCLUDE TEMPLATE="/#SecurityMapping#/Login.cfm">
                                        </CFIF>
                                        <CFABORT>
                                </CFIF>
                        </CFIF>
                </CFIF>
        </CFIF>
        <CFIF #ParameterExists(IsNewSession)# IS "no">
                <CFSET #IsNewSession# = "NO">
        </CFIF>

	<!--- Update user profile --->
	<CFIF #IsNewSession# IS "YES">
                <CFQUERY NAME="UpdateUser" DATASOURCE="#SecurityDS#">

                        UPDATE Users SET
					TimePreviousSessionBegan=Users.TimeLastSessionBegan,
					TimeLastSessionBegan={fn NOW()},
					IP='#CGI.REMOTE_ADDR#',
					Host='#CGI.HTTP_HOST#',
					Browser='#CGI.HTTP_USER_AGENT#',
					HttpFrom='#CGI.HTTP_FROM#',
                                        TimeLastAuthenticated={fn NOW()}
                                        WHERE User_ID=#User.User_ID#
                </CFQUERY>

                <CFELSE>


                <CFIF Evaluate("Parameterexists(Cookie.#CookieUser_LA#)") is "no">

                        <CFQUERY NAME="UpdateUser" DATASOURCE="#SecurityDS#">
                                UPDATE Users SET
						TimeLastAuthenticated={fn NOW()}
                                                WHERE User_ID=#User.User_ID#
                        </CFQUERY>

                </CFIF>

	</CFIF>


        <!--- Set cookies --->
        <CFIF #DisableCookies# is "NO">
                <CFCOOKIE NAME="#CookieUser_ID#" VALUE= "#User.User_ID#" EXPIRES="7">
                <CFCOOKIE NAME="#CookieUser_ST#" VALUE= "#User.st#" EXPIRES="7">
                <CFCOOKIE NAME="#CookieUser_LA#" VALUE= "#now()#" EXPIRES="7">
        </CFIF>

        <CFIF Evaluate("Parameterexists(Cookie.#CookieUser_ID#)") is "NO">
                <CFSET #ID_String# = #User.ID_String#>
        <CFELSE>
                <CFSET #ID_String# = "">
        </CFIF>

<CFELSE>
	<!--- Invalid or unknown user... --->
	<!--- Failed login prompt? --->
        <CFIF #ParameterExists(CustomLoginFailureTemplate)# IS "YES">

                <CFIF #Parameterexists(OUser_ID)# is "Yes">
                       <CFLOCATION URL="#AHrefString_Root#Basket/checkout.cfm&User_ID=#OUser_ID#&st=#OST#">
                <CFELSE>
                        <CFINCLUDE TEMPLATE="#CustomLoginFailureTemplate#">
                </CFIF>

        <CFELSE>
                <CFINCLUDE TEMPLATE="/#SecurityMapping#/logininv.cfm">
        </CFIF>
</CFIF>


<CFIF #Parameterexists(OUser_ID)# is "Yes">

        <CFQUERY Name="ConvertContentsToCurrentUser" DataSource="#ACBMainDS#">

                Update Orders Set User_ID=#User.User_ID#
                        Where User_ID=#OUser_ID#
        </CFQUERY>

</CFIF>