<CFIF #ParameterExists(form.a6)# is "Yes">

    <!--- Products are copied...now for their options --->

    <!--- Get all of the Product Options from the company that we are copying --->

    <CFQUERY NAME="GetProductOptionsToCopy" DATASOURCE="#form.CopyFrom_DS#">
            SELECT * FROM Options WHERE Company_ID = #form.CopyCompany_ID#
    </CFQUERY>

    <!--- Set a counter for dynamic Query names --->

    <CFPARAM NAME="OptionCount" DEFAULT="0">

    <!--- need to keep track of the old Opt_ID so that we --->
    <!--- can attach the options back to their products   --->
    <!--- Also setting up some variables for looping across    --->
    <!--- large datasets.                                       --->

    <CFIF ParameterExists(form.OldOption_ID_List) is "NO">
        <CFPARAM NAME="OldOption_ID_List" DEFAULT="">
    <CFELSE>
        <CFSET #OldOption_ID_List# = #form.OldOption_ID_List#>
    </CFIF>
    <CFIF ParameterExists(form.NewOption_ID_List) is "NO">
        <CFPARAM NAME="NewOption_ID_List" DEFAULT="">
    <CFELSE>
        <CFSET #NewOption_ID_List# = #form.NewOption_ID_List#>
    </CFIF>
    <CFIF ParameterExists(form.OptStart) is "NO">
        <CFSET #OptStart# = 1>
    <CFELSE>
        <CFSET #OptStart# = #form.OptStart#>
    </CFIF>
    <CFIF ParameterExists(form.OptStop) is "NO">
        <CFSET #OptStop# = 50>
    <CFELSE>
        <CFSET #OptStop# = #form.OptStop#>
    </CFIF>
    <CFIF #OptStop# GTE #GetProductOptionsToCopy.RecordCount#>
        <CFSET #OptStop# = #GetProductOptionsToCopy.RecordCount#>
    </CFIF>

    <CFTRANSACTION>

        <!--- Loop across the results of the Options query and --->
        <!--- insert them into the database                    --->

        <CFLOOP QUERY="GetProductOptionsToCopy" STARTROW="#OptStart#" ENDROW="#OptStop#">
            <CFSET #OptionCount# = #OptionCount# + 1>
            <CFQUERY NAME="O#OptionCount#" DATASOURCE="#form.CopyTo_DS#">
                    INSERT INTO Options (OptPartNumber, OptTitle, OptPrice,
                                            Company_ID, OptLevel, OptWeight, OrderByString)
                            VALUES ('#GetProductOptionsToCopy.OptPartNumber#', '#GetProductOptionsToCopy.OptTitle#',
                                    #GetProductOptionsToCopy.OptPrice#, #form.MaxCompany_ID#,
                                    #GetProductOptionsToCopy.OptLevel#, #GetProductOptionsToCopy.OptWeight#,
                                    '#GetProductOptionsToCopy.OrderByString#')
            </CFQUERY>

            <!--- Find out the ID of the first Product inserted --->

            <CFIF #OptionCount# is 1>
                <CFQUERY NAME="GetCurrentMaxOption" DATASOURCE="#form.CopyTo_DS#">
                        SELECT Max(Opt_ID) As MaxOption_ID
                        FROM Options
                </CFQUERY>

            <!--- We want the MaxOpt_ID to actually be one less than the first inserted --->

            <CFSET #MaxOpt_ID# = #GetCurrentMaxOption.MaxOption_ID# - 1>

            </CFIF>

            <!--- Building the look-up lists for attaching Options to Products --->

            <CFSET #OldOption_ID_List# = ListAppend("#OldOption_ID_List#", "#GetProductOptionsToCopy.Opt_ID#")>
            <CFSET #NewOpt_ID# = #MaxOpt_ID# + #OptionCount#>
            <CFSET #NewOption_ID_List# = ListAppend("#NewOption_ID_List#", "#NewOpt_ID#")>
        </CFLOOP>

    </CFTRANSACTION>

    <HTML>
    <HEAD>
    <title>Copy Options</title>
    </HEAD>

    <BODY bgcolor = "#ff ff ff">

    <CENTER>

    <CFIF #GetProductOptionsToCopy.RecordCount# GT #OptStop#>
        <FORM ACTION = "copy7.cfm" METHOD=post>
        <CFIF #ParameterExists(a6)# is "Yes">
            <INPUT TYPE=hidden NAME="a6" VALUE="1">
            <CFSET #finished# = 0>

            <CFSET #last# = #OptStop#>
            <CFSET #OptStart# = #OptStart# + 50>
            <CFSET #OptStop# = #OptStop# + 50>

        </CFIF>
    <CFELSE>
        <CFIF #GetProductOptionsToCopy.RecordCount# is 0>
            <FORM ACTION = "copy9.cfm" METHOD=post>
        <CFELSE>
            <FORM ACTION = "copy8.cfm" METHOD=post>
        </CFIF>
        <CFSET #finished# = 1>
    </CFIF>

    <CFOUTPUT>
        <INPUT TYPE=hidden NAME="OptStart" VALUE="#OptStart#">
        <INPUT TYPE=hidden NAME="OptStop" VALUE="#OptStop#">
        <INPUT TYPE=hidden NAME="OldProduct_ID_List" VALUE="#OldProduct_ID_List#">
        <INPUT TYPE=hidden NAME="NewProduct_ID_List" VALUE="#NewProduct_ID_List#">
        <INPUT TYPE=hidden NAME="OldOption_ID_List" VALUE="#OldOption_ID_List#">
        <INPUT TYPE=hidden NAME="NewOption_ID_List" VALUE="#NewOption_ID_List#">
    </CFOUTPUT>

<CFELSE>

    <HTML>
    <HEAD>
    <title>Copy Options</title>
    </HEAD>

    <BODY bgcolor = "#ff ff ff">

    <CENTER>

    <FORM ACTION = "copy8.cfm" METHOD=post>
    <CFSET #finished# = 2>

</CFIF>

<TABLE WIDTH=350 BORDER=1 CELLPADDING=2 CELLSPACING=2 ALIGN=CENTER>
<TR>
<TD ALIGN="center" BGCOLOR="#cf cF cF">

    <FONT FACE=ARIAL COLOR="#000080"><B>Copy Options</B></FONT>

</TD>
</TR>

<TR>
<TD ALIGN=Center VALIGN="TOP">
    <FONT FACE=ARIAL COLOR="#000080">

    <CFIF #finished# is 2>
        Options not selected for copy
    <CFELSE>
        <CFIF #finished# is 1>
            Finished copying Options
        <CFELSE>
            Continue copying Options<BR>
            <CFOUTPUT>
                <FONT FACE=ARIAL SIZE=2>[ #last# of #GetProductOptionsToCopy.RecordCount# complete ]</FONT>
            </CFOUTPUT>
        </CFIF>

    </CFIF>

    </FONT>
</TD>
</TR>
<TR>
<TD align=center BGCOLOR="#cf cF cF" VALIGN="TOP">

<CFOUTPUT>
    <INPUT TYPE=hidden NAME="CopyCompany_ID" VALUE="#form.CopyCompany_ID#">
    <INPUT TYPE=hidden NAME="CopyFrom_DS" VALUE="#form.CopyFrom_DS#">
    <INPUT TYPE=hidden NAME="CopyTo_DS" VALUE="#form.CopyTo_DS#">
    <INPUT TYPE=hidden NAME="MaxCompany_ID" VALUE="#form.MaxCompany_ID#">
    <INPUT TYPE=hidden NAME="CopyIntoDS_ID" VALUE="#form.CopyIntoDS_ID#">
    <CFIF #ParameterExists(a6)# is "Yes">
        <INPUT TYPE=hidden NAME="a6" VALUE="1">
    </CFIF>
    <CFIF #ParameterExists(form.a3)# is "Yes">
        <INPUT TYPE=hidden NAME="a3" VALUE="1">
    </CFIF>
    <CFIF #ParameterExists(form.a2)# is "Yes">
        <INPUT TYPE=hidden NAME="a2" VALUE="1">
    </CFIF>

    <INPUT TYPE=submit VALUE="Continue">
</CFOUTPUT>

</TD>
</TR>
</TABLE>
</CENTER>
</FORM>
</BODY>
</HTML>