<!---  Copy the Groups --->

<CFIF #ParameterExists(form.a5)# is "Yes">

        <!--- Get all of the Groups from the company that we are copying --->

        <CFQUERY NAME="GetObjectGroupsToCopy" DATASOURCE="#form.CopyFrom_DS#">
                SELECT * FROM ObjectGroups WHERE Category_ID IN (#form.OldCategory_ID_List#)
        </CFQUERY>

        <!--- Set a counter for dynamic Query names --->

        <CFPARAM NAME="GroupCount" DEFAULT="0">

        <!--- Need to keep track of the old Group_ID so that we  --->
        <!--- can attach copies of Products if they are selected --->
        <!--- Also setting up some variables for looping across    --->
        <!--- large datasets.                                       --->

        <CFIF ParameterExists(form.OldGroup_ID_List) is "NO">
            <CFPARAM NAME="OldGroup_ID_List" DEFAULT="">
        <CFELSE>
            <CFSET #OldGroup_ID_List# = #form.OldGroup_ID_List#>
        </CFIF>
        <CFIF ParameterExists(form.NewGroup_ID_List) is "NO">
            <CFPARAM NAME="NewGroup_ID_List" DEFAULT="">
        <CFELSE>
            <CFSET #NewGroup_ID_List# = #form.NewGroup_ID_List#>
        </CFIF>
        <CFIF ParameterExists(form.GrpStart) is "NO">
            <CFSET #GrpStart# = 1>
        <CFELSE>
            <CFSET #GrpStart# = #form.GrpStart#>
        </CFIF>
        <CFIF ParameterExists(form.GrpStop) is "NO">
            <CFSET #GrpStop# = 40>
        <CFELSE>
            <CFSET #GrpStop# = #form.GrpStop#>
        </CFIF>
        <CFIF #GrpStop# GTE #GetObjectGroupsToCopy.RecordCount#>
            <CFSET #GrpStop# = #GetObjectGroupsToCopy.RecordCount#>
        </CFIF>

        <CFTRANSACTION>

            <!--- Loop across the results of the Groups query and --->
            <!--- insert them into the database                   --->

            <CFLOOP QUERY="GetObjectGroupsToCopy" STARTROW="#GrpStart#" ENDROW="#GrpStop#">
                <CFSET #GroupCount# = #GroupCount# + 1>
                <CFSET #Old_List_Order# = LISTFIND("#form.OldCategory_ID_List#", "#GetObjectGroupsToCopy.Category_ID#")>
                <CFSET #NewCat_ID# = LISTGETAT("#form.NewCategory_ID_List#", #Old_List_Order#)>
                <CFQUERY NAME="G#GroupCount#" DATASOURCE="#form.CopyTo_DS#">
                        INSERT INTO ObjectGroups (Category_ID, GroupTitle, GroupDescription,
                                                Active, GroupIcon, GroupIconWidth,
                                                GroupIconHeight, GroupImage, GroupImageWidth,
                                                GroupImageHeight, GroupPageOptions, OrderByString, TableBorderValue)
                               VALUES (#NewCat_ID#, '#GetObjectGroupsToCopy.GroupTitle#', '#GetObjectGroupsToCopy.GroupDescription#',
                                       #GetObjectGroupsToCopy.Active#, '#GetObjectGroupsToCopy.GroupIcon#', #GetObjectGroupsToCopy.GroupIconWidth#,
                                       #GetObjectGroupsToCopy.GroupIconHeight#, '#GetObjectGroupsToCopy.GroupImage#', #GetObjectGroupsToCopy.GroupImageWidth#,
                                       #GetObjectGroupsToCopy.GroupImageHeight#, '#GetObjectGroupsToCopy.GroupPageOptions#',
                                       '#GetObjectGroupsToCopy.OrderByString#', #GetObjectGroupsToCopy.TableBorderValue#)
                </CFQUERY>

                <!--- Find out the ID of the first Group inserted --->

                <CFIF #GroupCount# is 1>
                    <CFQUERY NAME="GetCurrentMaxGroup" DATASOURCE="#form.CopyTo_DS#">
                            SELECT Max(ObjectGroup_ID) As MaxGroup_ID
                            FROM ObjectGroups
                    </CFQUERY>

                <!--- We want the MaxGrp_ID to actually be one less than the first inserted --->

                <CFSET #MaxGrp_ID# = #GetCurrentMaxGroup.MaxGroup_ID# - 1>

                </CFIF>

                <!--- Building the look-up lists for attaching groups --->

                <CFSET #OldGroup_ID_List# = ListAppend("#OldGroup_ID_List#", "#GetObjectGroupsToCopy.ObjectGroup_ID#")>
                <CFSET #NewGrp_ID# = #MaxGrp_ID# + #GroupCount#>
                <CFSET #NewGroup_ID_List# = ListAppend("#NewGroup_ID_List#", "#NewGrp_ID#")>
            </CFLOOP>

        </CFTRANSACTION>

    <HTML>
    <HEAD>
    <title>Copy ObjectGroups</title>
    </HEAD>

    <BODY bgcolor = "#ff ff ff">

    <CENTER>

    <CFIF #GetObjectGroupsToCopy.RecordCount# GT #GrpStop#>
        <FORM ACTION = "copy5.cfm" METHOD=post>
        <CFIF #ParameterExists(a5)# is "Yes">
            <INPUT TYPE=hidden NAME="a5" VALUE="1">
            <CFSET #finished# = 0>

            <CFSET #last# = #GrpStop#>
            <CFSET #GrpStart# = #GrpStart# + 40>
            <CFSET #GrpStop# = #GrpStop# + 40>

        </CFIF>
    <CFELSE>
        <CFIF #GetObjectGroupsToCopy.RecordCount# is 0>
            <FORM ACTION = "copy9.cfm" METHOD=post>
        <CFELSE>
            <FORM ACTION = "copy6.cfm" METHOD=post>
        </CFIF>
        <CFSET #finished# = 1>
    </CFIF>

    <CFOUTPUT>
        <INPUT TYPE=hidden NAME="GrpStart" VALUE="#GrpStart#">
        <INPUT TYPE=hidden NAME="GrpStop" VALUE="#GrpStop#">
        <INPUT TYPE=hidden NAME="OldGroup_ID_List" VALUE="#OldGroup_ID_List#">
        <INPUT TYPE=hidden NAME="NewGroup_ID_List" VALUE="#NewGroup_ID_List#">
    </CFOUTPUT>

<CFELSE>

    <HTML>
    <HEAD>
    <title>Copy ObjectGroups</title>
    </HEAD>

    <BODY bgcolor = "#ff ff ff">

    <CENTER>

    <FORM ACTION = "copy6.cfm" METHOD=post>
    <CFSET #finished# = 2>

</CFIF>

<TABLE WIDTH=350 BORDER=1 CELLPADDING=2 CELLSPACING=2 ALIGN=CENTER>
<TR>
<TD ALIGN="center" BGCOLOR="#cf cF cF">

    <FONT FACE=ARIAL COLOR="#000080"><B>Copy ObjectGroups</B></FONT>

</TD>
</TR>

<TR>
<TD ALIGN=Center VALIGN="TOP">
    <FONT FACE=ARIAL COLOR="#000080">

    <CFIF #finished# is 2>
        ObjectGroups not selected for copy
    <CFELSE>
        <CFIF #finished# is 1>
            Finished copying ObjectGroups
        <CFELSE>
            Continue copying ObjectGroups<BR>
            <CFOUTPUT>
                <FONT FACE=ARIAL SIZE=2>[ #last# of #GetObjectGroupsToCopy.RecordCount# complete ]</FONT>
            </CFOUTPUT>

        </CFIF>

    </CFIF>

    </FONT>
</TD>
</TR>
<TR>
<TD align=center BGCOLOR="#cf cF cF" VALIGN="TOP">

<CFOUTPUT>
    <INPUT TYPE=hidden NAME="CopyCompany_ID" VALUE="#form.CopyCompany_ID#">
    <INPUT TYPE=hidden NAME="CopyFrom_DS" VALUE="#form.CopyFrom_DS#">
    <INPUT TYPE=hidden NAME="CopyTo_DS" VALUE="#form.CopyTo_DS#">
    <INPUT TYPE=hidden NAME="MaxCompany_ID" VALUE="#form.MaxCompany_ID#">
    <INPUT TYPE=hidden NAME="CopyIntoDS_ID" VALUE="#form.CopyIntoDS_ID#">
    <INPUT TYPE=hidden NAME="OldCategory_ID_List" VALUE="#OldCategory_ID_List#">
    <INPUT TYPE=hidden NAME="NewCategory_ID_List" VALUE="#NewCategory_ID_List#">

    <CFIF #ParameterExists(a6)# is "Yes">
        <INPUT TYPE=hidden NAME="a6" VALUE="1">
    </CFIF>
    <CFIF #ParameterExists(form.a3)# is "Yes">
        <INPUT TYPE=hidden NAME="a3" VALUE="1">
    </CFIF>
    <CFIF #ParameterExists(form.a2)# is "Yes">
        <INPUT TYPE=hidden NAME="a2" VALUE="1">
    </CFIF>
    <INPUT TYPE=submit VALUE="Continue">
</CFOUTPUT>

</TD>
</TR>
</TABLE>
</CENTER>
</FORM>
</BODY>
</HTML>