/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.uploadlist;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import ning.uploader.icon.ScalingParameters;
import ning.uploader.model.UploadItem;
import ning.uploader.resources.IconCreator;
import ning.uploader.swing.MultiLineLabel;
import ning.uploader.uploadlist.UploadListItem;

public class UploadListCellRenderer
extends DefaultListCellRenderer {
    private final Map<JList, IconCreator.IconListener> repaintListeners = new ConcurrentHashMap<JList, IconCreator.IconListener>();
    private final IconCreator iconCreator;
    private final ScalingParameters iconParams;
    private final Border border;
    private final Map<CacheKey, UploadListItem> baseItemsCache = new LRUCache<CacheKey, UploadListItem>(1000);

    public UploadListCellRenderer(IconCreator iconCreator, ScalingParameters iconParams, int borderInset) {
        this.iconCreator = iconCreator;
        this.iconParams = iconParams;
        this.border = new EmptyBorder(borderInset, borderInset, borderInset, borderInset);
    }

    public Component getListCellRendererComponent(final JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        final UploadItem item = (UploadItem)value;
        UploadListItem baseItem = this.getBaseItem(list, item);
        baseItem.setBorder(this.border);
        baseItem.setPreferredSize(new Dimension(list.getFixedCellWidth(), list.getFixedCellHeight()));
        baseItem.setSelected(isSelected);
        IconCreator.IconListener listener = this.repaintListeners.get(list);
        if (listener == null) {
            listener = new IconCreator.IconListener(){

                public void iconUpdated(ImageIcon icon) {
                    UploadListCellRenderer.this.getBaseItem(list, item).setIcon(icon);
                    list.repaint();
                }
            };
            this.repaintListeners.put(list, listener);
        }
        if (item.isImage()) {
            baseItem.setMaximumLines(0);
            baseItem.setAlignment(MultiLineLabel.Alignment.CENTER);
        } else {
            baseItem.setMaximumLines(2);
            baseItem.setAlignment(MultiLineLabel.Alignment.TOP_CENTER);
            baseItem.setText(item.getName());
            baseItem.setFont(baseItem.getFont().deriveFont(10.0f));
        }
        baseItem.setIcon(item.getIcon(this.iconCreator, this.iconParams, listener));
        baseItem.setIndex(index);
        baseItem.setToolTipText(item.getFile().getAbsolutePath());
        return baseItem;
    }

    public Border getBorder() {
        return this.border;
    }

    private synchronized UploadListItem getBaseItem(final JList list, UploadItem item) {
        CacheKey key = new CacheKey(list, item);
        UploadListItem baseItem = this.baseItemsCache.get(key);
        if (baseItem == null) {
            baseItem = new UploadListItem(){

                public void repaint() {
                    int index = this.getIndex();
                    Rectangle bounds = list.getCellBounds(index, index);
                    if (bounds != null) {
                        list.repaint(bounds);
                    }
                    super.repaint();
                }
            };
            this.baseItemsCache.put(key, baseItem);
        }
        return baseItem;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxEntries;

        public LRUCache(int maxEntries) {
            super(maxEntries + 1, 0.75f, true);
            this.maxEntries = maxEntries;
        }

        @Override
        public boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.maxEntries;
        }
    }

    private static final class CacheKey {
        private final JList list;
        private final UploadItem item;

        private CacheKey(JList list, UploadItem item) {
            this.list = list;
            this.item = item;
        }

        public UploadItem getItem() {
            return this.item;
        }

        public JList getList() {
            return this.list;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return !(this.item == null ? cacheKey.item != null : !this.item.equals(cacheKey.item)) && !(this.list == null ? cacheKey.list != null : !this.list.equals(cacheKey.list));
        }

        public int hashCode() {
            int result = this.item != null ? this.item.hashCode() : 0;
            result = 31 * result + (this.list != null ? this.list.hashCode() : 0);
            return result;
        }
    }
}

