/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.uploadlist;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JList;
import ning.uploader.alerter.Alerter;
import ning.uploader.alerter.AlerterHelper;
import ning.uploader.alerter.Callback;
import ning.uploader.alerter.Choices;
import ning.uploader.alerter.Chosen;
import ning.uploader.dnd.AbstractDragInsteadOfSelect;
import ning.uploader.filebrowser.FileChoiceListener;
import ning.uploader.icon.ScalingParameters;
import ning.uploader.logging.Logger;
import ning.uploader.model.UploadItem;
import ning.uploader.model.UploadItemFactory;
import ning.uploader.resources.IconCreator;
import ning.uploader.resources.ResourceLoader;
import ning.uploader.resources.Strings;
import ning.uploader.swing.Beardifier;
import ning.uploader.swing.FourSidedBorder;
import ning.uploader.swing.MultiLineLabel;
import ning.uploader.uploadlist.UploadListCellRenderer;
import ning.uploader.uploadlist.UploadListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadList
extends JList
implements FileChoiceListener {
    private static final Logger log = Logger.getLogger(UploadList.class);
    private int maxItems = 100;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final FileFilter filter;
    private final UploadItemFactory factory;
    private final UploadListModel model;
    private final AtomicBoolean doingDrag = new AtomicBoolean(false);
    private final AtomicBoolean dropIsOutside = new AtomicBoolean(false);
    private final AtomicReference<int[]> dragElements = new AtomicReference();
    private volatile Integer insertionIndex = null;
    private final int cellSize;
    private final int borderInset = 1;
    private final Alerter alerter;
    private Cursor dragCursor;
    private Integer dragInsertionIndex = null;
    private MultiLineLabel uploadMessage = new MultiLineLabel(){

        public void repaint() {
            if (UploadList.this.model.size() == 0) {
                UploadList.this.repaint();
            }
        }
    };
    private AbstractDragInsteadOfSelect<Integer> dragInsteadOfSelect = new AbstractDragInsteadOfSelect<Integer>(){

        @Override
        public void setSelection(Integer pendingSelection) {
            UploadList.this.setSelectionInterval(pendingSelection, pendingSelection);
        }
    };

    public UploadList(IconCreator iconCreator, ScalingParameters iconParams, UploadListModel backingList, FileFilter filter, UploadItemFactory factory, Alerter alerter) {
        super(backingList);
        this.filter = filter;
        this.factory = factory;
        this.cellSize = iconParams.getTargetWidth();
        this.alerter = alerter;
        this.model = (UploadListModel)this.getModel();
        FourSidedBorder border = new FourSidedBorder(new Insets(1, 1, 0, 1), new Color(240, 240, 240));
        this.setBorder(border);
        BufferedImage dragCursorImage = ResourceLoader.loadImage("batch-small.png");
        Point hotSpot = new Point(dragCursorImage.getWidth() / 2, dragCursorImage.getHeight() / 2);
        this.dragCursor = Toolkit.getDefaultToolkit().createCustomCursor(dragCursorImage, hotSpot, "Dragging Cursor");
        this.uploadMessage.setText(Strings.DRAG_IN_INSTRUCTIONS.get());
        this.uploadMessage.setFont(this.getFont().deriveFont(1, 18.0f));
        this.uploadMessage.setForeground(new Color(204, 204, 204, 255));
        this.uploadMessage.setLineSpacing(1.4f);
        BufferedImage arrowImage = ResourceLoader.loadImage("drop-arrow.png");
        if (arrowImage != null) {
            this.uploadMessage.setIcon(new ImageIcon(arrowImage));
        }
        this.setCellRenderer(new UploadListCellRenderer(iconCreator, iconParams, 1));
        this.setSelectionMode(2);
        this.setLayoutOrientation(2);
        this.setVisibleRowCount(-1);
        this.initializeDropTarget();
        this.dragInsteadOfSelect.install(this);
        final MouseMotionAdapter motionListener = new MouseMotionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseDragged(MouseEvent mouseEvent) {
                UploadList.this.doingDrag.set(true);
                UploadList.this.dropIsOutside.set(!UploadList.this.contains(mouseEvent.getPoint()));
                UploadList.this.setCursor(UploadList.this.dragCursor);
                UploadList.this.updateActiveInsertionIndex();
                Object object = UploadList.this.getTreeLock();
                synchronized (object) {
                    Graphics graphics = UploadList.this.getGraphics();
                    int index = UploadList.this.getActiveInsertionIndex();
                    if (UploadList.this.dragInsertionIndex == null || UploadList.this.dragInsertionIndex != index) {
                        if (UploadList.this.dragInsertionIndex != null) {
                            this.drawInsertion(graphics, UploadList.this.dragInsertionIndex, Color.WHITE, Color.WHITE);
                        }
                        UploadList.this.dragInsertionIndex = index;
                        this.drawInsertion(graphics, index, Color.LIGHT_GRAY, Color.LIGHT_GRAY);
                    }
                }
            }

            private void drawInsertion(Graphics graphics, int index, Color left, Color right) {
                Rectangle bounds2;
                Rectangle bounds1 = UploadList.this.getCellBounds(index, index);
                if (bounds1 != null) {
                    graphics.setColor(left);
                    graphics.drawLine(bounds1.x + bounds1.width - 2, bounds1.y, bounds1.x + bounds1.width - 2, bounds1.y + bounds1.height);
                }
                if ((bounds2 = UploadList.this.getCellBounds(index + 1, index + 1)) != null) {
                    graphics.setColor(right);
                    graphics.drawLine(bounds2.x, bounds2.y, bounds2.x, bounds2.y + bounds2.height);
                }
            }
        };
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                UploadList.this.dragElements.set(UploadList.this.getSelectedIndices());
                UploadList.this.addMouseMotionListener(motionListener);
                UploadList.this.repaint();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                Integer insertionIndex = UploadList.this.getActiveInsertionIndex();
                if (UploadList.this.doingDrag.getAndSet(false)) {
                    boolean dropIsOutside = UploadList.this.dropIsOutside.getAndSet(false);
                    int[] dragElements = UploadList.this.dragElements.getAndSet(null);
                    if (dragElements != null && dragElements.length > 0) {
                        UploadList.this.clearSelection();
                        if (dropIsOutside) {
                            UploadList.this.model.removeElements(dragElements);
                        } else if (insertionIndex != null) {
                            UploadList.this.model.moveElementsTo(insertionIndex + 1, dragElements);
                        }
                    }
                    UploadList.this.setCursor(Cursor.getDefaultCursor());
                }
                UploadList.this.removeMouseMotionListener(motionListener);
                UploadList.this.updateActiveInsertionIndex();
                UploadList.this.repaint();
            }

            public void mouseClicked(MouseEvent e) {
                try {
                    long mask = 960L;
                    if (e.getClickCount() == 2 && ((long)e.getModifiersEx() & mask) == mask) {
                        UploadItem item = (UploadItem)UploadList.this.model.getElementAt(UploadList.this.getSelectedIndex());
                        new Beardifier(ImageIO.read(item.getFile())).attach(UploadList.this);
                    }
                }
                catch (Exception ex) {
                    log.info("No easter egg for you!", ex);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 || e.getKeyCode() == 8) {
                    UploadList.this.model.removeElements(UploadList.this.getSelectedIndices());
                }
            }
        });
    }

    public boolean dropIsOutside() {
        return this.dropIsOutside.get();
    }

    @Override
    public int getFixedCellWidth() {
        return this.cellSize;
    }

    @Override
    public void setFixedCellWidth(int i) {
        throw new UnsupportedOperationException(String.format("Cell size is fixed at %d", this.cellSize));
    }

    @Override
    public int getFixedCellHeight() {
        return this.cellSize;
    }

    @Override
    public void setFixedCellHeight(int i) {
        throw new UnsupportedOperationException(String.format("Cell size is fixed at %d", this.cellSize));
    }

    @Override
    public void setSelectionInterval(int anchor, int lead) {
        if (!(this.doingDrag.get() || anchor == lead && this.dragInsteadOfSelect.delaySelect(anchor, this.isSelectedIndex(anchor)))) {
            super.setSelectionInterval(anchor, lead);
        }
    }

    public void updateActiveInsertionIndex() {
        Integer updatedIndex = null;
        if (this.doingDrag.get()) {
            int index;
            Rectangle bounds;
            Point point = this.getMousePosition();
            if (point != null && !(updatedIndex = Integer.valueOf((bounds = this.getCellBounds(index = this.locationToIndex(point), index)) == null ? 0 : (point.y > bounds.y + bounds.width ? index : (point.x - bounds.x < bounds.width / 2 ? index - 1 : index)))).equals(this.insertionIndex)) {
                this.insertionIndex = updatedIndex;
            }
        } else if (this.insertionIndex != null) {
            this.insertionIndex = null;
        }
    }

    public Integer getActiveInsertionIndex() {
        return this.insertionIndex;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = Math.min(maxItems, 100);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.model.size() == 0) {
            Rectangle bounds = this.getBounds();
            Graphics2D g2 = (Graphics2D)graphics.create();
            g2.setColor(this.getBackground());
            g2.fill(bounds);
            g2.translate(bounds.x + bounds.width / 6, bounds.y + bounds.height / 6);
            this.uploadMessage.setBounds(0, 0, 2 * bounds.width / 3, 2 * bounds.height / 3);
            this.uploadMessage.paint(g2);
            g2.dispose();
        } else {
            super.paintComponent(graphics);
        }
    }

    private void initializeDropTarget() {
        new DropTarget(this, new DropTargetListener(){

            private boolean canAccept(DropTargetDragEvent dtde) {
                return this.canAccept(dtde.getDropAction(), dtde.getTransferable());
            }

            private boolean canAccept(DropTargetDropEvent dtde) {
                return this.canAccept(dtde.getDropAction(), dtde.getTransferable());
            }

            private boolean canAccept(int action, Transferable transferable) {
                if ((action & 3) > 0) {
                    for (DataFlavor f : UploadList.this.factory.getSupportedFlavors()) {
                        if (!transferable.isDataFlavorSupported(f)) continue;
                        return true;
                    }
                }
                return false;
            }

            public void dragEnter(DropTargetDragEvent dtde) {
                if (this.canAccept(dtde)) {
                    dtde.acceptDrag(dtde.getDropAction());
                    UploadList.this.requestFocus();
                } else {
                    dtde.rejectDrag();
                }
                UploadList.this.repaint();
            }

            public void dragOver(DropTargetDragEvent dtde) {
                if (this.canAccept(dtde)) {
                    dtde.acceptDrag(dtde.getDropAction());
                    UploadList.this.requestFocus();
                } else {
                    dtde.rejectDrag();
                }
                UploadList.this.repaint();
            }

            public void dropActionChanged(DropTargetDragEvent dtde) {
                if (this.canAccept(dtde)) {
                    dtde.acceptDrag(dtde.getDropAction());
                } else {
                    dtde.rejectDrag();
                }
                UploadList.this.repaint();
            }

            public void dragExit(DropTargetEvent dte) {
                UploadList.this.repaint();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void drop(DropTargetDropEvent dtde) {
                try {
                    if (!this.canAccept(dtde)) ** GOTO lbl22
                    dtde.acceptDrop(dtde.getDropAction());
                    try {
                        transferable = dtde.getTransferable();
                        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                            UploadList.access$800(UploadList.this, (List)transferable.getTransferData(DataFlavor.javaFileListFlavor));
                        } else if (UploadList.access$900(UploadList.this, 1)) {
                            try {
                                UploadList.access$000(UploadList.this).addElementsAt(UploadList.access$000(UploadList.this).getSize(), new UploadItem[]{UploadList.access$700(UploadList.this).createItem(transferable)});
                            }
                            catch (Exception e) {
                                UploadList.access$600().info(String.format("Unexpected exception adding %s", new Object[]{transferable}), e);
                                AlerterHelper.error(UploadList.access$1000(UploadList.this), Strings.ERROR_UNEXPECTED_TITLE, Strings.ERROR_UNEXPECTED_DESCRIPTION, new String[0]);
                            }
                        }
                        dtde.dropComplete(true);
                        return;
                    }
                    catch (Exception e) {
                        UploadList.access$600().warn("Failed to drop", e);
lbl22:
                        // 2 sources

                        dtde.rejectDrop();
                    }
                }
                finally {
                    UploadList.access$100(UploadList.this).set(false);
                    UploadList.this.clearSelection();
                    UploadList.this.repaint();
                }
            }
        });
    }

    @Override
    public void onFilesChosen(File ... files) {
        this.addFiles(Arrays.asList(files));
    }

    private boolean canAdd(int size) {
        if (this.model.getSize() + size > this.maxItems) {
            AlerterHelper.warning(this.alerter, Strings.ERROR_TOO_MANY_TITLE, Strings.ERROR_TOO_MANY_DESCRIPTION, Integer.toString(this.maxItems));
            return false;
        }
        return true;
    }

    private void addFiles(List<File> files) {
        final List<File> flattenedFiles = this.flattenDirectories(files);
        this.executor.submit(new Runnable(){

            public void run() {
                try {
                    ArrayList<UploadItem> items = new ArrayList<UploadItem>();
                    for (File f : flattenedFiles) {
                        if (!UploadList.this.canAdd(items.size() + 1)) break;
                        if (UploadList.this.filter.accept(f)) {
                            try {
                                items.add((UploadItem)UploadList.this.factory.createItem(f));
                            }
                            catch (Exception e) {
                                log.info(String.format("Unexpected exception adding %s", f), e);
                                AlerterHelper.error(UploadList.this.alerter, Strings.ERROR_UNEXPECTED_TITLE, Strings.ERROR_UNEXPECTED_DESCRIPTION, new String[0]);
                            }
                            continue;
                        }
                        if (UploadList.this.shouldContinue(f, flattenedFiles.size() == 1 ? Choices.OKAY : Choices.CANCEL_CONITNUE)) continue;
                        break;
                    }
                    if (!items.isEmpty()) {
                        UploadList.this.model.addElementsAt(UploadList.this.model.getSize(), items);
                    }
                }
                catch (Throwable t) {
                    log.info("Error adding files", t);
                }
            }
        });
    }

    private List<File> flattenDirectories(List<File> files) {
        ArrayList<File> results = new ArrayList<File>();
        ArrayList<File> toVisit = new ArrayList<File>(files);
        HashSet<File> visited = new HashSet<File>();
        while (!toVisit.isEmpty()) {
            File f = (File)toVisit.remove(0);
            if (f.isDirectory()) {
                if (visited.contains(f)) continue;
                visited.add(f);
                toVisit.addAll(Arrays.asList(f.listFiles()));
                continue;
            }
            if (!files.contains(f) && !this.filter.accept(f)) continue;
            results.add(f);
            if (results.size() <= this.maxItems) continue;
            return results;
        }
        return results;
    }

    private boolean shouldContinue(File unsupportedFile, Choices choices) {
        final AtomicBoolean continueWithOthers = new AtomicBoolean(false);
        final Semaphore choiceMade = new Semaphore(0);
        AlerterHelper.warning(this.alerter, Strings.ERROR_UNSUPPORTED_FILE_TITLE, Strings.ERROR_UNSUPPORTED_FILE_DESCRIPTION, choices, new Callback(){

            public void onChosen(Chosen chosen) {
                continueWithOthers.set(chosen == Chosen.CONTINUE);
                choiceMade.release();
            }
        }, unsupportedFile.getName());
        try {
            choiceMade.acquire();
        }
        catch (InterruptedException e) {
            log.info("Interrupted waiting for choice to be made", e);
            Thread.currentThread().interrupt();
        }
        return continueWithOthers.get();
    }

    static /* synthetic */ void access$800(UploadList x0, List x1) {
        x0.addFiles(x1);
    }
}

