/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.swing;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiLineLabel
extends JComponent
implements ImageObserver {
    private ImageIcon icon = null;
    private String text = null;
    private float lineSpacing = 1.0f;
    private int maximumLines = 2;
    private Alignment alignment = Alignment.CENTER;
    private boolean selected = false;

    @Override
    public boolean imageUpdate(Image image, int flags, int x, int y, int width, int height) {
        if (this.icon != null && this.icon.getImage() == image && super.imageUpdate(image, flags, x, y, width, height)) {
            this.repaint();
            return true;
        }
        return false;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(float lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public int getMaximumLines() {
        return this.maximumLines;
    }

    public void setMaximumLines(int maximumLines) {
        this.maximumLines = maximumLines;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Rectangle bounds = this.getInsetBounds();
        Graphics2D g2 = (Graphics2D)graphics.create();
        FontMetrics metrics = g2.getFontMetrics();
        int labelPadding = 4;
        if (this.isOpaque()) {
            g2.setColor(this.getBackground());
            g2.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        if (this.isSelected()) {
            Insets insets = this.getInsets();
            g2.setColor(new Color(196, 196, 196));
            g2.fillRoundRect(insets.left, insets.top, bounds.width - insets.left - insets.right + 1, bounds.height - insets.top - insets.bottom + 1, 10, 10);
        }
        Point iconPosition = this.calculateIconPosition(metrics);
        if (this.icon != null) {
            this.icon.paintIcon(this, graphics, iconPosition.x, iconPosition.y);
        }
        if (this.text != null) {
            g2.setFont(this.getFont());
            g2.setColor(this.getForeground());
            float y = iconPosition.y + (this.icon == null ? 0 : this.icon.getIconHeight());
            for (String line : this.splitText(this.text, metrics, bounds.width - 2 * labelPadding, this.maximumLines)) {
                float x = (bounds.width - 2 * labelPadding - metrics.stringWidth(line)) / 2 + labelPadding;
                g2.drawString(line, x, y += this.lineSpacing * (float)metrics.getAscent());
            }
        }
        g2.dispose();
    }

    private Rectangle getInsetBounds() {
        Rectangle bounds = this.getBounds();
        Insets insets = this.getInsets();
        bounds.x += insets.left;
        bounds.width -= insets.left + insets.right;
        bounds.y += insets.top;
        bounds.height -= insets.top + insets.bottom;
        return bounds;
    }

    private float getTextHeight(FontMetrics metrics) {
        return this.lineSpacing * (float)metrics.getAscent() * (float)this.maximumLines;
    }

    private Point calculateIconPosition(FontMetrics metrics) {
        Rectangle bounds = this.getInsetBounds();
        Point iconPosition = new Point(0, 0);
        switch (this.alignment) {
            case TOP_CENTER: 
            case BOTTOM_CENTER: 
            case CENTER: {
                iconPosition.x = iconPosition.x + (bounds.width - (this.icon == null ? 0 : this.icon.getIconWidth())) / 2;
                break;
            }
            case TOP_RIGHT: 
            case BOTTOM_RIGHT: 
            case CENTER_RIGHT: {
                iconPosition.x = iconPosition.x + (bounds.width - (this.icon == null ? 0 : this.icon.getIconWidth()));
                break;
            }
        }
        switch (this.alignment) {
            case CENTER: 
            case CENTER_RIGHT: 
            case CENTER_LEFT: {
                iconPosition.y = (int)((float)iconPosition.y + ((float)(bounds.height - (this.icon == null ? 0 : this.icon.getIconHeight())) - this.getTextHeight(metrics)) / 2.0f);
                break;
            }
            case BOTTOM_CENTER: 
            case BOTTOM_RIGHT: 
            case BOTTOM_LEFT: {
                iconPosition.y = iconPosition.y + (bounds.height - (this.icon == null ? 0 : this.icon.getIconHeight()));
                break;
            }
        }
        return iconPosition;
    }

    protected List<String> splitText(String text, FontMetrics metrics, int maxWidth, int maxLines) {
        ArrayList<String> result = new ArrayList<String>();
        if (text != null) {
            this.splitText(text.split(" "), 0, metrics, result, maxWidth, maxLines);
        }
        return result;
    }

    private void splitText(String[] words, int start, FontMetrics metrics, List<String> result, int maxWidth, int maxLines) {
        if (start >= words.length || maxWidth < metrics.stringWidth("...")) {
            return;
        }
        if (maxLines <= 0 && !result.isEmpty()) {
            String lastLine = result.get(result.size() - 1) + " " + words[start];
            while (metrics.stringWidth(lastLine + "...") > maxWidth) {
                lastLine = lastLine.substring(0, lastLine.length() - 1);
            }
            result.set(result.size() - 1, lastLine + "...");
        } else {
            StringBuilder sb = new StringBuilder();
            while (start < words.length && metrics.stringWidth(sb.toString() + words[start]) <= maxWidth) {
                sb.append(words[start]).append(" ");
                ++start;
            }
            if (sb.length() == 0) {
                String longWord = words[start];
                while (metrics.stringWidth(longWord + "...") > maxWidth) {
                    longWord = longWord.substring(0, longWord.length() - 1);
                }
                result.add(longWord + "...");
                ++start;
            } else {
                sb.deleteCharAt(sb.length() - 1);
                result.add(sb.toString());
            }
            while (start < words.length && words[start].length() == 0) {
                ++start;
            }
            this.splitText(words, start, metrics, result, maxWidth, maxLines - 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Alignment {
        TOP_LEFT,
        TOP_RIGHT,
        TOP_CENTER,
        CENTER_LEFT,
        CENTER_RIGHT,
        CENTER,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        BOTTOM_CENTER;

    }
}

