/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class FourSidedBorder
implements Border {
    public static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private Color leftColor;
    private Color rightColor;
    private Color topColor;
    private Color bottomColor;
    private final Insets insets;

    public FourSidedBorder(Insets insets, Color color) {
        this.insets = insets;
        this.topColor = this.bottomColor = color;
        this.rightColor = this.bottomColor;
        this.leftColor = this.bottomColor;
    }

    public FourSidedBorder(int padding, Color color) {
        this(new Insets(padding, padding, padding, padding), color);
    }

    public void paintBorder(Component component, Graphics graphics, int x, int y, int width, int height) {
        if (this.topColor != TRANSPARENT) {
            graphics.setColor(this.topColor);
            graphics.fillRect(x - this.insets.left, y, width + this.insets.left + this.insets.right, this.insets.top);
        }
        if (this.bottomColor != TRANSPARENT) {
            graphics.setColor(this.bottomColor);
            graphics.fillRect(x - this.insets.left, y + height - this.insets.bottom, width + this.insets.left + this.insets.right, this.insets.bottom);
        }
        if (this.leftColor != TRANSPARENT) {
            graphics.setColor(this.leftColor);
            graphics.fillRect(x, y, this.insets.left, height);
        }
        if (this.rightColor != TRANSPARENT) {
            graphics.setColor(this.rightColor);
            graphics.fillRect(x + width - this.insets.right, y, this.insets.right, height);
        }
    }

    public Insets getBorderInsets(Component component) {
        return this.insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void setColors(Color color) {
        this.rightColor = this.bottomColor = color;
        this.topColor = this.bottomColor;
        this.leftColor = this.bottomColor;
    }

    public void setColors(Color leftColor, Color topColor, Color rightColor, Color bottomColor) {
        this.leftColor = leftColor;
        this.topColor = topColor;
        this.rightColor = rightColor;
        this.bottomColor = bottomColor;
    }

    public Color getLeftColor() {
        return this.leftColor;
    }

    public void setLeftColor(Color leftColor) {
        this.leftColor = leftColor;
    }

    public Color getRightColor() {
        return this.rightColor;
    }

    public void setRightColor(Color rightColor) {
        this.rightColor = rightColor;
    }

    public Color getTopColor() {
        return this.topColor;
    }

    public void setTopColor(Color topColor) {
        this.topColor = topColor;
    }

    public Color getBottomColor() {
        return this.bottomColor;
    }

    public void setBottomColor(Color bottomColor) {
        this.bottomColor = bottomColor;
    }
}

