/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;

public class FixedLayout
implements LayoutManager2 {
    private final Grow grow;
    private final Map<Component, DynamicRectangle> componentBounds = new HashMap<Component, DynamicRectangle>();
    private Size layoutSize = new Size(0, 0);

    public FixedLayout(Grow grow) {
        this.grow = grow;
    }

    public synchronized void addLayoutComponent(Component comp, Object constraints) {
        DynamicRectangle bounds;
        if (constraints instanceof Rectangle) {
            final Rectangle rect = new Rectangle((Rectangle)constraints);
            bounds = new DynamicRectangle(){

                public Rectangle getRectangle() {
                    return rect;
                }
            };
        } else if (constraints instanceof DynamicRectangle) {
            bounds = (DynamicRectangle)constraints;
        } else {
            throw new IllegalArgumentException(String.format("Expected %s or %s but got %s", Rectangle.class.getName(), DynamicRectangle.class.getName(), constraints.getClass().getName()));
        }
        this.componentBounds.put(comp, bounds);
        this.layoutSize.expand(bounds);
    }

    public synchronized Dimension maximumLayoutSize(Container target) {
        Dimension d = this.preferredLayoutSize(target);
        return new Dimension(this.grow == Grow.BOTH || this.grow == Grow.HORIZONTAL ? Integer.MAX_VALUE : (int)d.getWidth(), this.grow == Grow.BOTH || this.grow == Grow.VERTICAL ? Integer.MAX_VALUE : (int)d.getHeight());
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    public void invalidateLayout(Container target) {
        this.layoutSize = new Size(0, 0);
        for (DynamicRectangle bounds : this.componentBounds.values()) {
            this.layoutSize.expand(bounds);
        }
    }

    public void addLayoutComponent(String name, Component comp) {
        throw new UnsupportedOperationException("Use addLayoutComponent(Component comp, Rectangle constraints) instead");
    }

    public synchronized void removeLayoutComponent(Component comp) {
        this.componentBounds.remove(comp);
        this.layoutSize = new Size(0, 0);
        for (DynamicRectangle bounds : this.componentBounds.values()) {
            this.layoutSize.expand(bounds);
        }
    }

    public synchronized Dimension preferredLayoutSize(Container parent) {
        Insets padding = parent.getInsets();
        return new Dimension(this.layoutSize.width + padding.left + padding.right, this.layoutSize.height + padding.top + padding.bottom);
    }

    public synchronized Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public synchronized void layoutContainer(Container parent) {
        Insets padding = parent.getInsets();
        for (Component c : parent.getComponents()) {
            if (!this.componentBounds.containsKey(c)) continue;
            Rectangle r = new Rectangle(this.componentBounds.get(c).getRectangle());
            r.x += padding.left;
            r.y += padding.top;
            c.setBounds(r);
        }
    }

    private static class Size {
        public int width;
        public int height;

        public Size(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public void expand(DynamicRectangle bounds) {
            this.expand(bounds.getRectangle());
        }

        public void expand(Rectangle r) {
            if (this.width < r.x + r.width) {
                this.width = r.x + r.width;
            }
            if (this.height < r.y + r.height) {
                this.height = r.y + r.height;
            }
        }
    }

    public static interface DynamicRectangle {
        public Rectangle getRectangle();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Grow {
        NONE,
        HORIZONTAL,
        VERTICAL,
        BOTH;

    }
}

