/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.resources;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import netscape.javascript.JSObject;
import ning.uploader.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Strings {
    FILE_BROWSER_HEADER("My Computer"),
    FILE_ROOT("My Computer"),
    FILE_INFORMATION_HEADER("Information"),
    UPLOAD_HEADER("Files to Upload"),
    DRAG_OUT_INSTRUCTIONS("Drag files out to remove them"),
    DRAG_IN_INSTRUCTIONS("Drag Files Here"),
    SELECT_INSTRUCTIONS("Select a File"),
    FILES("Files"),
    TOTAL_SIZE("Total Size"),
    FILE_NAME("Name"),
    FILE_SIZE("Size"),
    NEXT_BUTTON("Next >"),
    OKAY_BUTTON("Okay"),
    YES_BUTTON("Yes"),
    NO_BUTTON("No"),
    UPLOAD_BUTTON("Upload"),
    CANCEL_BUTTON("Cancel"),
    BACK_BUTTON("Back"),
    CONTINUE_BUTTON("Continue"),
    UPLOADING_LABEL("Uploading..."),
    UPLOADING_STATUS("Uploading ${0} of ${1}"),
    UPLOADING_INSTRUCTIONS("Please leave this window open while your upload is in progress"),
    UPLOAD_LIMIT_WARNING("You can upload ${0} files"),
    UPLOAD_LIMIT_COUNTDOWN(null){

        protected String getValue(String ... parameters) {
            int remaining = Integer.parseInt(parameters[0]);
            switch (remaining) {
                case 0: {
                    return "You've added the maximum number of files.";
                }
                case 1: {
                    return "You can upload 1 more file.";
                }
            }
            return "You can upload " + remaining + " more files.";
        }
    }
    ,
    I_HAVE_THE_RIGHT("I have the right to upload these files under the <a href='http://www.ning.com/about/tos.html'>Terms of Service</a>"),
    UPDATE_JAVA_TITLE("Update Java"),
    UPDATE_JAVA_DESCRIPTION("The bulk uploader requires a more recent version of Java. Click \"Okay\" to get Java."),
    BATCH_EDITOR_LABEL("Edit Information for All Items"),
    APPLY_THIS_INFO("Apply this info to the files below"),
    TITLE_PROPERTY("Title"),
    DESCRIPTION_PROPERTY("Description"),
    TAGS_PROPERTY("Tags"),
    VIEWABLE_BY_PROPERTY("Can be viewed by"),
    VIEWABLE_BY_EVERYONE("Anyone"),
    VIEWABLE_BY_FRIENDS("Just My Friends"),
    VIEWABLE_BY_ME("Just Me"),
    ALBUM_PROPERTY("Album"),
    ARTIST_PROPERTY("Artist"),
    ENABLE_DOWNLOAD_LINK_PROPERTY("Enable download link"),
    ENABLE_PROFILE_USAGE_PROPERTY("Allow people to put this song on their pages"),
    LICENSE_PROPERTY("License"),
    CREATIVE_COMMONS_VERSION("3.0"),
    SELECT_LICENSE("\u2014 Select license \u2014"),
    COPYRIGHT("\u00a9 All Rights Reserved"),
    CC_BY_X("Creative Commons Attribution ${0}"),
    CC_BY_SA_X("Creative Commons Attribution Share Alike ${0}"),
    CC_BY_ND_X("Creative Commons Attribution No Derivatives ${0}"),
    CC_BY_NC_X("Creative Commons Attribution Non-commercial ${0}"),
    CC_BY_NC_SA_X("Creative Commons Attribution Non-commercial Share Alike ${0}"),
    CC_BY_NC_ND_X("Creative Commons Attribution Non-commercial No Derivatives ${0}"),
    PUBLIC_DOMAIN("Public Domain"),
    OTHER("Other"),
    ERROR_UNEXPECTED_TITLE("Oops!"),
    ERROR_UNEXPECTED_DESCRIPTION("There's been an error. Please try again."),
    ERROR_TOO_MANY_TITLE("Too Many Items"),
    ERROR_TOO_MANY_DESCRIPTION("We're sorry, but you can only upload ${0} items at a time."),
    ERROR_NOT_A_MEMBER_TITLE("Not Allowed"),
    ERROR_NOT_A_MEMBER_DESCRIPTION("We're sorry, but you need to be a member to upload."),
    ERROR_CONTENT_TYPE_NOT_ALLOWED_TITLE("Not Allowed"),
    ERROR_CONTENT_TYPE_NOT_ALLOWED_DESCRIPTION("We're sorry, but you're not allowed to upload this type of content."),
    ERROR_UNSUPPORTED_FORMAT_TITLE("Oops!"),
    ERROR_UNSUPPORTED_FORMAT_DESCRIPTION("We're sorry, but we don't support this type of file."),
    ERROR_UNSUPPORTED_FILE_TITLE("Oops!"),
    ERROR_UNSUPPORTED_FILE_DESCRIPTION("${0} is in an unsupported format."),
    ERROR_UPLOAD_UNEXPECTED_TITLE("Oops!"),
    ERROR_UPLOAD_UNEXPECTED_DESCRIPTION(null){

        protected String getValue(String ... parameters) {
            if (parameters.length == 0) {
                return "There appears to be a problem with the file at the top of the list. Please remove it before uploading the rest of your files.";
            }
            return String.format("There appears to be a problem with the %s file. Please remove it from the list before uploading the rest of your files.", parameters[0]);
        }
    }
    ,
    CANCEL_UPLOAD_TITLE("Cancel Upload?"),
    CANCEL_UPLOAD_DESCRIPTION("Are you sure you want to cancel the remaining uploads?"),
    UPLOAD_SUCCESSFUL_TITLE("Upload Completed"),
    UPLOAD_SUCCESSFUL_DESCRIPTION("Please wait while we take you to your uploads\u2026"),
    UPLOAD_PENDING_DESCRIPTION("Your files were successfully uploaded and are awaiting approval."),
    PHOTOS_UPLOAD_HEADER("Photos to Upload"),
    PHOTOS_DRAG_OUT_INSTRUCTIONS("Drag photos out to remove them"),
    PHOTOS_DRAG_IN_INSTRUCTIONS("Drag Photos Here"),
    PHOTOS_SELECT_INSTRUCTIONS("Select a Photo"),
    PHOTOS_FILES("Photos"),
    PHOTOS_UPLOADING_STATUS("Uploading Photo ${0} of ${1}"),
    PHOTOS_ERROR_TOO_MANY_TITLE("Too Many Photos"),
    PHOTOS_ERROR_TOO_MANY_DESCRIPTION("We're sorry, but you can only upload ${0} photos at a time."),
    PHOTOS_ERROR_CONTENT_TYPE_NOT_ALLOWED_DESCRIPTION("We're sorry, but photo uploading has been disabled."),
    PHOTOS_ERROR_UNSUPPORTED_FORMAT_DESCRIPTION("We're sorry, but you can only upload .jpg, .gif, .bmp or .png format images."),
    PHOTOS_ERROR_UNSUPPORTED_FILE_DESCRIPTION("${0} is not a .jpg, .gif, .bmp or .png file."),
    PHOTOS_BATCH_EDITOR_LABEL("Edit Information for All Photos"),
    PHOTOS_APPLY_THIS_INFO("Apply this info to the photos below"),
    PHOTOS_ERROR_UPLOAD_UNEXPECTED_DESCRIPTION(null){

        protected String getValue(String ... parameters) {
            if (parameters.length == 0) {
                return "There appears to be a problem with the photo at the top of the list. Please remove it before uploading the rest of your photos.";
            }
            return String.format("There appears to be a problem with the %s file. Please remove it from the list before uploading the rest of your photos.", parameters[0]);
        }
    }
    ,
    PHOTOS_UPLOAD_SUCCESSFUL_DESCRIPTION("Please wait while we take you to your photos\u2026"),
    PHOTOS_UPLOAD_PENDING_DESCRIPTION("Your photos were successfully uploaded and are awaiting approval."),
    PHOTOS_UPLOAD_LIMIT_WARNING("You can upload ${0} photos"),
    PHOTOS_UPLOAD_LIMIT_COUNTDOWN(null){

        protected String getValue(String ... parameters) {
            int remaining = Integer.parseInt(parameters[0]);
            switch (remaining) {
                case 0: {
                    return "You've added the maximum number of photos.";
                }
                case 1: {
                    return "You can upload 1 more photo.";
                }
            }
            return "You can upload " + remaining + " more photos.";
        }
    }
    ,
    PHOTOS_I_HAVE_THE_RIGHT("I have the right to upload these photos under the <a href='http://www.ning.com/about/tos.html'>Terms of Service</a>"),
    VIDEOS_UPLOAD_HEADER("Videos to Upload"),
    VIDEOS_DRAG_OUT_INSTRUCTIONS("Drag videos out to remove them"),
    VIDEOS_DRAG_IN_INSTRUCTIONS("Drag Videos Here"),
    VIDEOS_SELECT_INSTRUCTIONS("Select a Video"),
    VIDEOS_FILES("Videos"),
    VIDEOS_UPLOADING_STATUS("Uploading Video ${0} of ${1}"),
    VIDEOS_ERROR_TOO_MANY_TITLE("Too Many Videos"),
    VIDEOS_ERROR_TOO_MANY_DESCRIPTION("We're sorry, but you can only upload ${0} videos at a time."),
    VIDEOS_ERROR_CONTENT_TYPE_NOT_ALLOWED_DESCRIPTION("We're sorry, but video uploading has been disabled."),
    VIDEOS_ERROR_UNSUPPORTED_FORMAT_DESCRIPTION("We're sorry, but you can only upload .avi, .mov, .mp4, .wmv or .mpg format videos."),
    VIDEOS_ERROR_UNSUPPORTED_FILE_DESCRIPTION("${0} is not a .avi, .mov, .mp4, .wmv or .mpg file."),
    VIDEOS_BATCH_EDITOR_LABEL("Edit Information for All Videos"),
    VIDEOS_APPLY_THIS_INFO("Apply this info to the videos below"),
    VIDEOS_ERROR_UPLOAD_UNEXPECTED_DESCRIPTION(null){

        protected String getValue(String ... parameters) {
            if (parameters.length == 0) {
                return "There appears to be a problem with the video at the top of the list. Please remove it before uploading the rest of your videos.";
            }
            return String.format("There appears to be a problem with the %s file. Please remove it from the list before uploading the rest of your videos.", parameters[0]);
        }
    }
    ,
    VIDEOS_UPLOAD_SUCCESSFUL_DESCRIPTION("Please wait while we take you to your videos\u2026"),
    VIDEOS_UPLOAD_PENDING_DESCRIPTION("Your videos were successfully uploaded and are awaiting approval."),
    VIDEOS_UPLOAD_LIMIT_WARNING("You can upload ${0} videos"),
    VIDEOS_UPLOAD_LIMIT_COUNTDOWN(null){

        protected String getValue(String ... parameters) {
            int remaining = Integer.parseInt(parameters[0]);
            switch (remaining) {
                case 0: {
                    return "You've added the maximum number of videos.";
                }
                case 1: {
                    return "You can upload 1 more video.";
                }
            }
            return "You can upload " + remaining + " more videos.";
        }
    }
    ,
    VIDEOS_I_HAVE_THE_RIGHT("I have the right to upload these videos under the <a href='http://www.ning.com/about/tos.html'>Terms of Service</a>"),
    MUSIC_UPLOAD_HEADER("Songs to Upload"),
    MUSIC_TITLE_PROPERTY("Song Title"),
    MUSIC_DRAG_OUT_INSTRUCTIONS("Drag songs out to remove them"),
    MUSIC_DRAG_IN_INSTRUCTIONS("Drag Songs Here"),
    MUSIC_SELECT_INSTRUCTIONS("Select a Song"),
    MUSIC_FILES("Songs"),
    MUSIC_UPLOADING_STATUS("Uploading Song ${0} of ${1}"),
    MUSIC_ERROR_TOO_MANY_TITLE("Too Many Songs"),
    MUSIC_ERROR_TOO_MANY_DESCRIPTION("We're sorry, but you can only upload ${0} songs at a time."),
    MUSIC_ERROR_CONTENT_TYPE_NOT_ALLOWED_DESCRIPTION("We're sorry, but song uploading has been disabled."),
    MUSIC_ERROR_UNSUPPORTED_FORMAT_DESCRIPTION("We're sorry, but you can only upload .mp3 format songs."),
    MUSIC_ERROR_UNSUPPORTED_FILE_DESCRIPTION("${0} is not a .mp3 file."),
    MUSIC_BATCH_EDITOR_LABEL("Edit Information for All Songs"),
    MUSIC_APPLY_THIS_INFO("Apply this info to the songs below"),
    MUSIC_ERROR_UPLOAD_UNEXPECTED_DESCRIPTION(null){

        protected String getValue(String ... parameters) {
            if (parameters.length == 0) {
                return "There appears to be a problem with the song at the top of the list. Please remove it before uploading the rest of your songs.";
            }
            return String.format("There appears to be a problem with the %s file. Please remove it from the list before uploading the rest of your songs.", parameters[0]);
        }
    }
    ,
    MUSIC_UPLOAD_SUCCESSFUL_DESCRIPTION("Please wait while we take you to your songs\u2026"),
    MUSIC_UPLOAD_PENDING_DESCRIPTION("Your songs were successfully uploaded and are awaiting approval."),
    MUSIC_UPLOAD_LIMIT_WARNING("You can upload ${0} songs"),
    MUSIC_UPLOAD_LIMIT_COUNTDOWN(null){

        protected String getValue(String ... parameters) {
            int remaining = Integer.parseInt(parameters[0]);
            switch (remaining) {
                case 0: {
                    return "You've added the maximum number of songs.";
                }
                case 1: {
                    return "You can upload 1 more song.";
                }
            }
            return "You can upload " + remaining + " more songs.";
        }
    }
    ,
    MUSIC_I_HAVE_THE_RIGHT("I have the right to upload these songs under the <a href='http://www.ning.com/about/tos.html'>Terms of Service</a>");

    private static final Logger log;
    private String value;
    private String jsName;
    private Map<String[], String> cached = new HashMap<String[], String>();
    private static String typePrefix;
    private static JSObject window;

    public static void setTypePrefix(String typePrefix) {
        Strings.typePrefix = typePrefix;
    }

    public static void setWindow(JSObject window) {
        Strings.window = window;
    }

    private Strings(String value) {
        this.value = value;
        StringBuilder camelCase = new StringBuilder();
        boolean capitalize = false;
        for (String part : this.toString().split("_")) {
            if (capitalize) {
                camelCase.append(Character.toUpperCase(part.charAt(0)));
            } else {
                camelCase.append(Character.toLowerCase(part.charAt(0)));
            }
            capitalize = true;
            camelCase.append(part.substring(1).toLowerCase());
        }
        this.jsName = camelCase.toString();
    }

    public String get(String ... parameters) {
        String typeKey = String.format("%s_%s", new Object[]{typePrefix, this});
        for (Strings s : Strings.values()) {
            if (!s.toString().equals(typeKey)) continue;
            return s.findValue(parameters);
        }
        return this.findValue(parameters);
    }

    public String get() {
        return this.get(new String[0]);
    }

    private String findValue(String ... parameters) {
        String value = this.cached.get(parameters);
        if (value != null) {
            return value;
        }
        if (window != null) {
            try {
                Object result;
                StringBuilder js = new StringBuilder();
                js.append("try {");
                js.append("xg.uploader.nls.text('").append(this.jsName).append("'");
                for (String parameter : parameters) {
                    js.append(", unescape('").append(URLEncoder.encode(parameter, "UTF-8")).append("')");
                }
                js.append(")");
                js.append("} catch (e) { ''; }");
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Executing JS: %s", js.toString()));
                }
                if ((result = window.eval(js.toString())) != null && result.toString().length() > 0) {
                    value = result.toString();
                    this.cached.put(parameters, value);
                    return value;
                }
            }
            catch (Exception e) {
                log.info(String.format("Failed to retrieve JS string for %s", this.jsName), e);
            }
            log.info(String.format("Failed to retrieve JS string for %s", this.jsName));
        }
        value = this.getValue(parameters);
        this.cached.put(parameters, value);
        return value;
    }

    protected String getValue(String ... parameters) {
        String value = this.value;
        for (int i = 0; i < parameters.length; ++i) {
            value = value.replace("${" + i + "}", parameters[i]);
        }
        return value;
    }

    static {
        log = Logger.getLogger(Strings.class);
        window = null;
    }
}

