/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.logging;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ning.uploader.logging.Level;

public class Logger {
    private static final Map<Class, Logger> LOGGERS = new HashMap<Class, Logger>();
    private static final Map<String, Level> LOG_LEVEL = new ConcurrentHashMap<String, Level>();
    private static Level DEFAULT_LEVEL = Level.INFO;
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final Class clazz;

    private Logger(Class clazz) {
        this.clazz = clazz;
    }

    public static synchronized Logger getLogger(Class clazz) {
        Logger log = LOGGERS.get(clazz);
        if (log == null) {
            log = new Logger(clazz);
            LOGGERS.put(clazz, log);
        }
        return log;
    }

    public static void setDefaultLevel(Level level) {
        DEFAULT_LEVEL = level;
    }

    public static void setLevel(Class clazz, Level level) {
        Logger.setLevel(clazz.getName(), level);
    }

    public static void setLevel(String path, Level level) {
        LOG_LEVEL.put(path, level);
    }

    public static Level getLevel(Class clazz) {
        String path = clazz.getName();
        while (path.length() > 0) {
            Level level = LOG_LEVEL.get(path);
            if (level != null) {
                return level;
            }
            path = path.substring(0, Math.max(0, path.lastIndexOf(".")));
        }
        return DEFAULT_LEVEL;
    }

    public void error(String msg) {
        this.log(Level.ERROR, msg, null);
    }

    public void error(String msg, Throwable t) {
        this.log(Level.ERROR, msg, t);
    }

    public void warn(String msg) {
        this.log(Level.WARN, msg, null);
    }

    public void warn(String msg, Throwable t) {
        this.log(Level.WARN, msg, t);
    }

    public void info(String msg) {
        this.log(Level.INFO, msg, null);
    }

    public void info(String msg, Throwable t) {
        this.log(Level.INFO, msg, t);
    }

    public void debug(String msg) {
        this.log(Level.DEBUG, msg, null);
    }

    public void debug(String msg, Throwable t) {
        this.log(Level.DEBUG, msg, t);
    }

    public void trace(String msg) {
        this.log(Level.TRACE, msg, null);
    }

    public void trace(String msg, Throwable t) {
        this.log(Level.TRACE, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logger.getLevel(this.clazz).getRank() >= Level.DEBUG.getRank();
    }

    private synchronized void log(Level level, String msg, Throwable t) {
        if (level.getRank() >= Logger.getLevel(this.clazz).getRank()) {
            System.out.println(String.format("%s %s %s %s %s", new Object[]{level, this.dateFormat.format(new Date()), Thread.currentThread().getName(), this.clazz.getName(), msg}));
            if (t != null) {
                t.printStackTrace();
            }
        }
    }
}

