/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.info;

import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.FileFilter;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import ning.uploader.icon.ScalingParameters;
import ning.uploader.info.DefaultFileInfoRenderer;
import ning.uploader.info.FileAttributeList;
import ning.uploader.resources.IconCreator;
import ning.uploader.resources.ResourceLoader;
import ning.uploader.resources.Strings;
import ning.uploader.swing.MultiLineLabel;

public class PhotoInfoRenderer
extends DefaultFileInfoRenderer {
    private final ImageIcon defaultIcon = new ImageIcon(ResourceLoader.getUrlFor("spinner.gif"));
    private final ImageIcon errorIcon = new ImageIcon(ResourceLoader.getUrlFor("file-photo.png"));
    private final ImageIcon batchIcon = new ImageIcon(ResourceLoader.getUrlFor("batch.png"));
    private final ImageIcon directoryIcon = new ImageIcon(ResourceLoader.getUrlFor("folder.png"));
    private final JLabel batchPreview;
    private final MultiLineLabel emptyPreview;
    private final IconCreator iconCreator;
    private final ScalingParameters iconParams;
    private final Border paddingBorder = BorderFactory.createEmptyBorder(0, 0, 5, 0);

    public PhotoInfoRenderer(FileFilter filter, IconCreator iconCreator, ScalingParameters iconParams) {
        super(filter);
        this.iconCreator = iconCreator;
        this.iconParams = iconParams;
        this.batchPreview = new JLabel();
        this.batchPreview.setHorizontalAlignment(0);
        this.batchPreview.setBorder(this.paddingBorder);
        this.batchPreview.setIcon(this.batchIcon);
        this.batchPreview.setPreferredSize(new Dimension(iconParams.getTargetWidth(), iconParams.getTargetHeight()));
        this.emptyPreview = new MultiLineLabel();
        this.emptyPreview.setText(Strings.SELECT_INSTRUCTIONS.get());
        this.emptyPreview.setFont(this.batchPreview.getFont().deriveFont(1, 14.0f));
        this.emptyPreview.setForeground(new Color(170, 170, 170, 255));
        this.emptyPreview.setLineSpacing(1.4f);
        this.emptyPreview.setBorder(this.paddingBorder);
        this.emptyPreview.setPreferredSize(new Dimension(iconParams.getTargetWidth(), iconParams.getTargetHeight()));
    }

    protected void addEmptyAttributes(FileAttributeList component) {
        component.addComponent(this.emptyPreview);
        super.addEmptyAttributes(component);
    }

    protected void addSingleFileAttributes(FileAttributeList component, File file) {
        final JLabel preview = new JLabel();
        preview.setHorizontalAlignment(0);
        preview.setBorder(this.paddingBorder);
        preview.setIcon(this.iconCreator.getIcon(file, this.iconParams, this.defaultIcon, this.errorIcon, new IconCreator.IconListener(){

            public void iconUpdated(ImageIcon icon) {
                preview.setIcon(icon);
                preview.repaint();
            }
        }));
        preview.setPreferredSize(new Dimension(this.iconParams.getTargetWidth(), this.iconParams.getTargetHeight()));
        component.addComponent(preview);
        super.addSingleFileAttributes(component, file);
    }

    protected void addMultipleFileAttributes(FileAttributeList component, File ... files) {
        boolean hasDir = false;
        for (File f : files) {
            if (!f.isDirectory()) continue;
            hasDir = true;
            break;
        }
        this.batchPreview.setIcon(hasDir ? this.directoryIcon : this.batchIcon);
        component.addComponent(this.batchPreview);
        super.addMultipleFileAttributes(component, files);
    }
}

