/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.info;

import java.text.NumberFormat;

public class Formatter {
    private static final int BASE = 1024;

    public static String toHumanReadable(Long bytes) {
        if (bytes == null) {
            return "n/a";
        }
        return Formatter.toHumanReadable((long)bytes);
    }

    public static String toHumanReadable(long bytes) {
        int unitIndex;
        NumberFormat format = NumberFormat.getNumberInstance();
        boolean negative = bytes < 0L;
        double size = negative ? (double)(-bytes) : (double)bytes;
        for (unitIndex = 0; unitIndex < Unit.values().length - 1 && size >= 1024.0; size /= 1024.0, ++unitIndex) {
        }
        if (negative) {
            size = -size;
        }
        Unit unit = Unit.values()[unitIndex];
        switch (unit) {
            case B: 
            case KB: {
                format.setMaximumFractionDigits(0);
                break;
            }
            case MB: 
            case GB: 
            case TB: {
                format.setMaximumFractionDigits(1);
            }
        }
        return unit.format(format.format((double)((long)(size * 100.0)) / 100.0), size == 1.0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Unit {
        B("byte", "bytes"),
        KB,
        MB,
        GB,
        TB;

        private String singular;
        private String plural;

        private Unit() {
            this.singular = this.name();
            this.plural = this.name();
        }

        private Unit(String singular, String plural) {
            this.singular = singular;
            this.plural = plural;
        }

        public String format(String number, boolean isOne) {
            return String.format("%s %s", number, isOne ? this.singular : this.plural);
        }
    }
}

