/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.image;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import ning.uploader.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedImageCreatingConsumer
implements ImageConsumer {
    private static final Logger log = Logger.getLogger(BufferedImageCreatingConsumer.class);
    private static final BufferedImage ERROR_IMAGE = new BufferedImage(1, 1, 1);
    private BufferedImage image;
    private AtomicBoolean finished = new AtomicBoolean(false);
    private ColorModel rgbModel = ColorModel.getRGBdefault();
    private BlockingQueue<BufferedImage> resultQueue = new LinkedBlockingQueue<BufferedImage>(1);

    public static BufferedImage getFilteredBufferedImage(ImageProducer source) throws InterruptedException {
        BufferedImageCreatingConsumer imageCreator = new BufferedImageCreatingConsumer();
        source.startProduction(imageCreator);
        return imageCreator.getImage();
    }

    public BufferedImage getImage() throws InterruptedException {
        BufferedImage result = this.resultQueue.take();
        if (result == ERROR_IMAGE) {
            throw new IllegalStateException("Image error");
        }
        return result;
    }

    @Override
    public void setDimensions(int width, int height) {
        this.image = new BufferedImage(width, height, 2);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        log.debug("Is byte array");
        int[] filteredpixels = new int[w];
        int index = off;
        for (int cy = 0; cy < h; ++cy) {
            for (int cx = 0; cx < w; ++cx) {
                filteredpixels[cx] = model.getRGB(pixels[index] & 0xFF);
                ++index;
            }
            index += scansize - w;
            this.image.setRGB(x, y + cy, w, 1, filteredpixels, 0, w);
        }
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        if (model.equals(this.rgbModel)) {
            log.debug("Is RGB");
            this.image.setRGB(x, y, w, h, pixels, off, scansize);
        } else {
            log.debug("Is not RGB");
            int[] filteredpixels = new int[w];
            int index = off;
            for (int cy = 0; cy < h; ++cy) {
                for (int cx = 0; cx < w; ++cx) {
                    filteredpixels[cx] = model.getRGB(pixels[index]);
                    ++index;
                }
                index += scansize - w;
                this.image.setRGB(x, y + cy, w, 1, filteredpixels, 0, w);
            }
        }
    }

    @Override
    public void setProperties(Hashtable<?, ?> props) {
    }

    @Override
    public void setColorModel(ColorModel model) {
    }

    @Override
    public void setHints(int hintflags) {
    }

    @Override
    public void imageComplete(int status) {
        if (!this.finished.getAndSet(true)) {
            try {
                this.resultQueue.put(status == 1 ? ERROR_IMAGE : this.image);
            }
            catch (InterruptedException e) {
                log.info("Failed to add image to result queue", e);
                Thread.currentThread().interrupt();
            }
        }
    }
}

