/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.image;

import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoscaleFilter
extends ImageFilter {
    private ImageFilter delegate = null;
    private final int maxWidth;
    private final int maxHeight;

    public AutoscaleFilter(int maxWidth, int maxHeight) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    @Override
    public void setDimensions(int width, int height) {
        if (this.delegate == null) {
            int scaledWidth = width;
            int scaledHeight = height;
            if (width > this.maxWidth || height > this.maxHeight) {
                if ((double)width / (double)this.maxWidth > (double)height / (double)this.maxHeight) {
                    scaledWidth = this.maxWidth;
                    scaledHeight = -1;
                } else {
                    scaledWidth = -1;
                    scaledHeight = this.maxHeight;
                }
            }
            this.delegate = new AreaAveragingScaleFilter(scaledWidth, scaledHeight){
                {
                    this.consumer = AutoscaleFilter.this.consumer;
                }
            };
        }
        this.delegate.setDimensions(width, height);
    }

    @Override
    public void setProperties(Hashtable<?, ?> props) {
        this.delegate.setProperties(props);
    }

    @Override
    public void setColorModel(ColorModel model) {
        this.delegate.setColorModel(model);
    }

    @Override
    public void setHints(int hints) {
        this.delegate.setHints(hints);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        this.delegate.setPixels(x, y, w, h, model, pixels, off, scansize);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        this.delegate.setPixels(x, y, w, h, model, pixels, off, scansize);
    }

    @Override
    public void imageComplete(int status) {
        if (this.delegate != null) {
            this.delegate.imageComplete(status);
        } else {
            super.imageComplete(status);
        }
    }

    @Override
    public void resendTopDownLeftRight(ImageProducer ip) {
        this.delegate.resendTopDownLeftRight(ip);
    }
}

