/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.http;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class MimeTypes {
    private final Map<String, String> types = new HashMap<String, String>();
    private final String defaultType = "application/octet-stream";

    public String getMimeType(File file) {
        String name = file.getName();
        return this.getMimeTypeForExtension(name.substring(name.lastIndexOf(46) + 1));
    }

    public String getMimeTypeForExtension(String ext) {
        String type = this.types.get(ext.trim().toLowerCase());
        return type == null ? "application/octet-stream" : type;
    }

    public MimeTypes() {
        this.types.put("3g2", "video/3gpp2");
        this.types.put("3gp", "video/3gpp");
        this.types.put("3gp2", "video/3gpp2");
        this.types.put("3gpp", "video/3gpp");
        this.types.put("ac3", "audio/ac3");
        this.types.put("aif", "audio/aiff");
        this.types.put("aifc", "audio/aiff");
        this.types.put("aiff", "audio/aiff");
        this.types.put("asf", "video/x-ms-asf");
        this.types.put("asx", "video/x-ms-asx");
        this.types.put("au", "audio/basic");
        this.types.put("avi", "video/avi");
        this.types.put("bin", "application/macbinary");
        this.types.put("bmp", "image/bmp");
        this.types.put("crw", "image/x-canon-crw");
        this.types.put("dif", "video/x-dv");
        this.types.put("dll", "application/x-msdownload");
        this.types.put("dls", "audio/dls");
        this.types.put("docm", "application/vnd.ms-word.document.macroenabled.12");
        this.types.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        this.types.put("dotm", "application/vnd.ms-word.template.macroenabled.12");
        this.types.put("dotx", "application/vnd.openxmlformats-officedocument.wordprocessingml.template");
        this.types.put("dv", "video/x-dv");
        this.types.put("efx", "image/efax");
        this.types.put("eml", "message/rfc822");
        this.types.put("exe", "application/x-msdownload");
        this.types.put("fpx", "image/fpx");
        this.types.put("gif", "image/gif");
        this.types.put("gtar", "application/x-gtar");
        this.types.put("gz", "application/x-gzip");
        this.types.put("gzip", "application/x-gzip");
        this.types.put("hqx", "application/mac-binhex40");
        this.types.put("htm", "text/html");
        this.types.put("html", "text/html");
        this.types.put("ics", "text/calendar");
        this.types.put("ifb", "text/calendar");
        this.types.put("j2k", "image/jp2");
        this.types.put("jar", "application/java-archive");
        this.types.put("jnlp", "application/x-java-jnlp-file");
        this.types.put("jp2", "image/jp2");
        this.types.put("jpe", "image/jpeg");
        this.types.put("jpeg", "image/jpeg");
        this.types.put("jpf", "image/jp2");
        this.types.put("jpg", "image/jpeg");
        this.types.put("jpx", "image/jp2");
        this.types.put("js", "text/javascript");
        this.types.put("kar", "audio/midi");
        this.types.put("m15", "video/mpeg");
        this.types.put("m2v", "video/mpeg2");
        this.types.put("m75", "video/mpeg");
        this.types.put("mid", "audio/midi");
        this.types.put("midi", "audio/midi");
        this.types.put("mov", "video/quicktime");
        this.types.put("mp3", "audio/mpeg");
        this.types.put("mp4", "video/mp4");
        this.types.put("mpe", "video/mpeg");
        this.types.put("mpeg", "video/mpeg");
        this.types.put("mpg", "video/mpeg");
        this.types.put("odc", "application/vnd.oasis.opendocument.chart");
        this.types.put("odf", "application/vnd.oasis.opendocument.formula");
        this.types.put("odg", "application/vnd.oasis.opendocument.graphics");
        this.types.put("odi", "application/vnd.oasis.opendocument.image");
        this.types.put("odm", "application/vnd.oasis.opendocument.text-master");
        this.types.put("odp", "application/vnd.oasis.opendocument.presentation");
        this.types.put("ods", "application/vnd.oasis.opendocument.spreadsheet");
        this.types.put("odt", "application/vnd.oasis.opendocument.text");
        this.types.put("otc", "application/vnd.oasis.opendocument.chart-template");
        this.types.put("otg", "application/vnd.oasis.opendocument.graphics-template");
        this.types.put("oth", "application/vnd.oasis.opendocument.text-web");
        this.types.put("oti", "application/vnd.oasis.opendocument.image-template");
        this.types.put("otp", "application/vnd.oasis.opendocument.presentation-template");
        this.types.put("ots", "application/vnd.oasis.opendocument.spreadsheet-template");
        this.types.put("ott", "application/vnd.oasis.opendocument.text-template");
        this.types.put("pct", "image/pict");
        this.types.put("pdf", "application/pdf");
        this.types.put("ph3", "text/php");
        this.types.put("ph4", "text/php");
        this.types.put("php", "text/php");
        this.types.put("php3", "text/php");
        this.types.put("php4", "text/php");
        this.types.put("pict", "image/pict");
        this.types.put("pl", "text/x-perl-script");
        this.types.put("pm", "text/x-perl-script");
        this.types.put("png", "image/png");
        this.types.put("potm", "application/vnd.ms-powerpoint.template.macroenabled.12");
        this.types.put("potx", "application/vnd.openxmlformats-officedocument.presentationml.template");
        this.types.put("ppsm", "application/vnd.ms-powerpoint.slideshow.macroenabled.12");
        this.types.put("ppsx", "application/vnd.openxmlformats-officedocument.presentationml.slideshow");
        this.types.put("pptm", "application/vnd.ms-powerpoint.presentation.macroenabled.12");
        this.types.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        this.types.put("ps", "application/postscript");
        this.types.put("psd", "image/vnd.adobe.photoshop");
        this.types.put("py", "text/x-python-script");
        this.types.put("qif", "image/x-quicktime");
        this.types.put("qt", "video/quicktime");
        this.types.put("qti", "image/x-quicktime");
        this.types.put("qtif", "image/x-quicktime");
        this.types.put("qtz", "application/x-quartzcomposer");
        this.types.put("ra", "audio/vnd.rn-realaudio");
        this.types.put("ram", "audio/vnd.rn-realaudio");
        this.types.put("rb", "text/x-ruby-script");
        this.types.put("rbw", "text/x-ruby-script");
        this.types.put("rm", "application/vnd.rn-realmedia");
        this.types.put("rtf", "text/rtf");
        this.types.put("sgi", "image/sgi");
        this.types.put("shtm", "text/html");
        this.types.put("sit", "application/x-stuffit");
        this.types.put("sitx", "application/x-stuffit");
        this.types.put("smf", "audio/midi");
        this.types.put("smil", "application/smil");
        this.types.put("snd", "audio/basic");
        this.types.put("svg", "image/svg+xml");
        this.types.put("svgz", "image/svg+xml");
        this.types.put("tar", "application/x-tar");
        this.types.put("text", "text/plain");
        this.types.put("tga", "image/targa");
        this.types.put("tif", "image/tiff");
        this.types.put("tiff", "image/tiff");
        this.types.put("txt", "text/plain");
        this.types.put("vcal", "text/x-vcalendar");
        this.types.put("vcf", "text/directory");
        this.types.put("vcs", "text/x-vcalendar");
        this.types.put("vfw", "video/avi");
        this.types.put("vmdk", "application/x-vmware-vmdisk");
        this.types.put("vmsn", "application/x-vmware-snapshot");
        this.types.put("vmtm", "application/x-vmware-team");
        this.types.put("vmx", "application/x-vmware-vm");
        this.types.put("vmxf", "application/x-vmware-vmfoundry");
        this.types.put("wav", "audio/wav");
        this.types.put("wave", "audio/wav");
        this.types.put("wax", "video/x-ms-wax");
        this.types.put("wm", "video/x-ms-wm");
        this.types.put("wma", "video/x-ms-wma");
        this.types.put("wmp", "video/x-ms-wmp");
        this.types.put("wmv", "video/x-ms-wmv");
        this.types.put("wmx", "video/x-ms-wmx");
        this.types.put("wvx", "video/x-ms-wvx");
        this.types.put("xbm", "image/x-xbitmap");
        this.types.put("xlsb", "application/vnd.ms-excel.sheet.binary.macroenabled.12");
        this.types.put("xlsm", "application/vnd.ms-excel.sheet.macroenabled.12");
        this.types.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        this.types.put("xltm", "application/vnd.ms-excel.template.macroenabled.12");
        this.types.put("xltx", "application/vnd.openxmlformats-officedocument.spreadsheetml.template");
        this.types.put("xml", "text/xml");
        this.types.put("zip", "application/zip");
    }
}

