/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.http;

public class HttpResponse {
    private Code code;
    private String body;

    public HttpResponse(int code, String body) {
        this.code = Code.valueOf(code, body);
        this.body = body;
    }

    public HttpResponse(Code code, String body) {
        this.code = code;
        this.body = body;
    }

    public Code getCode() {
        return this.code;
    }

    public String getBody() {
        return this.body;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Code {
        SUCCESSFUL(201, null),
        PENDING_APPROVAL(202, null),
        INVALID_REQUEST(400, "media-uploader:1"),
        CONTENT_TYPE_NOT_ALLOWED(403, "media-uploader:2"),
        NOT_A_MEMBER(403, "media-uploader:3"),
        NOT_POST(405, "media-uploader:4"),
        UNSUPPORTED_FORMAT(415, "media-uploader:5"),
        NETWORK_ERROR(500, "media-uploader:6"),
        UNEXPECTED(-1, null);

        private int code;
        private String errorId;

        private Code(int code, String errorId) {
            this.code = code;
            if (errorId != null) {
                this.errorId = String.format("<error code=\"%s\">", errorId);
            }
        }

        public int getCode() {
            return this.code;
        }

        public static Code valueOf(int code, String body) {
            for (Code c : Code.values()) {
                if (c.code != code || c.errorId != null && !body.contains(c.errorId)) continue;
                return c;
            }
            return UNEXPECTED;
        }
    }
}

