/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.filelist;

import java.io.File;
import java.io.FileFilter;
import javax.swing.AbstractListModel;
import ning.uploader.filebrowser.FileElement;
import ning.uploader.filter.FileExtensionFilter;

public class FileListModel
extends AbstractListModel {
    private FileElement[] contents;
    private FileElement[] rootContents;

    public FileListModel(FileExtensionFilter filter) {
        File[] roots = File.listRoots();
        boolean singleRoot = roots.length == 1;
        FileElement root = singleRoot ? new FileElement((FileFilter)filter, roots[0]) : new FileElement((FileFilter)filter, roots);
        this.rootContents = root.getChildren();
        this.contents = this.rootContents;
    }

    public FileElement[] getRootContents() {
        return this.rootContents;
    }

    public synchronized void setContents(FileElement[] contents) {
        int length = this.contents.length;
        if (length < contents.length) {
            this.contents = contents;
            this.fireIntervalAdded(this, length + 1, contents.length);
            this.fireContentsChanged(this, 0, length);
        } else if (length > contents.length) {
            this.fireIntervalRemoved(this, contents.length + 1, length);
            this.contents = contents;
            this.fireContentsChanged(this, 0, contents.length);
        } else {
            this.contents = contents;
            this.fireContentsChanged(this, 0, length);
        }
    }

    public synchronized int getSize() {
        return this.contents.length;
    }

    public synchronized Object getElementAt(int i) {
        return this.contents[i];
    }
}

