/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.filelist;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.filechooser.FileSystemView;
import ning.uploader.filebrowser.FileElement;

public class FileListCellRenderer
extends DefaultListCellRenderer {
    private static final FileSystemView FILE_SYSTEM_VIEW = FileSystemView.getFileSystemView();

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
        Icon icon = null;
        if (value instanceof FileElement) {
            FileElement fileElement = (FileElement)value;
            icon = fileElement.getIcon();
            if (icon == null && fileElement.getFile() != null) {
                icon = FILE_SYSTEM_VIEW.getSystemIcon(fileElement.getFile());
            }
            this.setEnabled(fileElement.isEnabled());
        } else if (index == list.getModel().getSize() - 1) {
            this.setIcon(FileElement.getRootIcon());
        }
        if (icon != null) {
            this.setIcon(icon);
        }
        this.setDisabledIcon(this.getIcon());
        return this;
    }
}

