/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.filelist;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ning.uploader.dnd.AbstractDragInsteadOfSelect;
import ning.uploader.dnd.FileDragSource;
import ning.uploader.dnd.FileDragSourceDelegate;
import ning.uploader.filebrowser.DirectoryContextListener;
import ning.uploader.filebrowser.FileChoiceListener;
import ning.uploader.filebrowser.FileElement;
import ning.uploader.filebrowser.FileListenerHandler;
import ning.uploader.filebrowser.FileSelectionListener;
import ning.uploader.filelist.FileListCellRenderer;
import ning.uploader.filelist.FileListModel;
import ning.uploader.filter.FileExtensionFilter;
import ning.uploader.resources.Strings;

public class FileList
extends JPanel {
    private JList list;
    private FileListModel model;
    private FileExtensionFilter filter;
    private final String fileRoot = Strings.FILE_ROOT.get();
    private final DefaultComboBoxModel parentPathModel = new DefaultComboBoxModel<String>(new String[]{this.fileRoot});
    private JComboBox parentPath = new JComboBox(this.parentPathModel);
    private final FileListenerHandler listeners = new FileListenerHandler();
    private AbstractDragInsteadOfSelect<Integer> dragInsteadOfSelect = new AbstractDragInsteadOfSelect<Integer>(){

        @Override
        public void setSelection(Integer pendingSelection) {
            FileList.this.list.setSelectionInterval(pendingSelection, pendingSelection);
        }
    };

    public FileList(FileExtensionFilter filter) {
        super(new BorderLayout(), true);
        this.filter = filter;
        this.model = new FileListModel(filter);
        FileListCellRenderer renderer = new FileListCellRenderer();
        this.parentPath.setRenderer(renderer);
        this.parentPath.setBackground(Color.WHITE);
        this.parentPath.setOpaque(true);
        this.parentPath.setVisible(false);
        this.parentPath.putClientProperty("JComboBox.isSquare", Boolean.TRUE);
        this.parentPath.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.parentPath.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultComboBoxModel defaultComboBoxModel = FileList.this.parentPathModel;
                synchronized (defaultComboBoxModel) {
                    Object selectedItem = FileList.this.parentPathModel.getSelectedItem();
                    if (selectedItem instanceof FileElement) {
                        FileElement element = (FileElement)selectedItem;
                        int index = FileList.this.parentPathModel.getIndexOf(element);
                        if (index != 0) {
                            for (int i = 0; i <= index; ++i) {
                                FileList.this.parentPathModel.removeElementAt(0);
                            }
                            FileList.this.pushDirectory(element);
                        }
                        FileList.this.listeners.fireContextChanged(element.getFile());
                    } else if (selectedItem != null) {
                        FileList.this.parentPathModel.removeAllElements();
                        FileList.this.parentPathModel.addElement(FileList.this.fileRoot);
                        FileList.this.list.setSelectedIndices(new int[0]);
                        FileList.this.model.setContents(FileList.this.model.getRootContents());
                        FileList.this.parentPath.setVisible(false);
                        FileList.this.listeners.fireContextChanged(null);
                    }
                }
            }
        });
        this.list = new JList(this.model){

            public void setSelectionInterval(int anchor, int lead) {
                if (anchor != lead || !FileList.this.dragInsteadOfSelect.delaySelect(anchor, this.isSelectedIndex(anchor))) {
                    super.setSelectionInterval(anchor, lead);
                }
            }
        };
        this.list.setCellRenderer(renderer);
        this.list.setSelectionMode(2);
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int index = FileList.this.list.locationToIndex(mouseEvent.getPoint());
                    FileElement element = (FileElement)FileList.this.model.getElementAt(index);
                    if (element.getFile().isDirectory()) {
                        FileList.this.pushDirectory(element);
                        FileList.this.listeners.fireContextChanged(element.getFile());
                    } else {
                        FileList.this.listeners.fireFilesChosen(element.getFile());
                    }
                }
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ArrayList<File> files = new ArrayList<File>();
                for (Object obj : FileList.this.list.getSelectedValues()) {
                    FileElement value = (FileElement)obj;
                    if (!value.isEnabled() || !value.isDraggable()) continue;
                    files.add(value.getFile());
                }
                FileList.this.listeners.fireFileSelectionChanged(files.toArray(new File[0]));
            }
        });
        this.dragInsteadOfSelect.install(this.list);
        JScrollPane listScrollPane = new JScrollPane(this.list);
        listScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.parentPath, "North");
        this.add((Component)listScrollPane, "Center");
        FileDragSource.install(this.list, new FileDragSourceDelegate<FileElement>(){

            @Override
            public Iterable<FileElement> getSelectedValues() {
                ArrayList<FileElement> result = new ArrayList<FileElement>();
                for (Object obj : FileList.this.list.getSelectedValues()) {
                    FileElement value = (FileElement)obj;
                    if (!value.isEnabled() || !value.isDraggable()) continue;
                    result.add(value);
                }
                return result;
            }

            @Override
            public Rectangle getValueBounds(FileElement value) {
                return FileList.this.list.getCellBounds(0, 0);
            }

            @Override
            public void renderValue(Graphics2D g2, Rectangle bounds, FileElement value) {
                JComponent cell = (JComponent)FileList.this.list.getCellRenderer().getListCellRendererComponent(FileList.this.list, value, 0, false, false);
                cell.setBounds(bounds);
                cell.setOpaque(false);
                cell.paint(g2);
                cell.setOpaque(true);
            }

            @Override
            public File getFileForValue(FileElement value) {
                return value.getFile();
            }

            @Override
            public void startDrag(Iterable<FileElement> selectedValues) {
                FileList.this.dragInsteadOfSelect.clearPending();
            }

            @Override
            public void completeDrag(Iterable<FileElement> selectedValues) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirectory(File directory) {
        DefaultComboBoxModel defaultComboBoxModel = this.parentPathModel;
        synchronized (defaultComboBoxModel) {
            this.parentPathModel.removeAllElements();
            File f = directory;
            while (f.getParentFile() != null) {
                this.parentPathModel.addElement(new FileElement((FileFilter)this.filter, f));
                f = f.getParentFile();
            }
            this.parentPathModel.addElement(this.fileRoot);
            this.parentPath.setVisible(true);
        }
        FileElement element = new FileElement((FileFilter)this.filter, directory);
        this.list.setSelectedIndices(new int[0]);
        this.model.setContents(element.getChildren());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushDirectory(FileElement directory) {
        DefaultComboBoxModel defaultComboBoxModel = this.parentPathModel;
        synchronized (defaultComboBoxModel) {
            this.parentPathModel.insertElementAt(directory, 0);
            this.parentPathModel.setSelectedItem(directory);
            this.parentPath.setVisible(true);
        }
        this.list.setSelectedIndices(new int[0]);
        this.model.setContents(directory.getChildren());
    }

    public void addSelectionListener(FileSelectionListener listener) {
        this.listeners.addSelectionListener(listener);
    }

    public void removeSelectionListener(FileSelectionListener listener) {
        this.listeners.removeSelectionListener(listener);
    }

    public void addChoiceListener(FileChoiceListener listener) {
        this.listeners.addChoiceListener(listener);
    }

    public void removeChoiceListener(FileChoiceListener listener) {
        this.listeners.removeChoiceListener(listener);
    }

    public void addContextListener(DirectoryContextListener listener) {
        this.listeners.addContextListener(listener);
    }

    public void removeContextListener(DirectoryContextListener listener) {
        this.listeners.removeContextListener(listener);
    }
}

