/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import ning.uploader.editor.CheckBoxComponent;
import ning.uploader.editor.ComboBoxComponent;
import ning.uploader.editor.RadioButtonComponent;
import ning.uploader.editor.ValueChangeAnnouncer;
import ning.uploader.editor.ValueChangeListener;
import ning.uploader.icon.ScalingParameters;
import ning.uploader.info.AttributeComponentCreator;
import ning.uploader.info.FileAttributeList;
import ning.uploader.model.UploadItem;
import ning.uploader.model.property.Downloadable;
import ning.uploader.model.property.License;
import ning.uploader.model.property.Property;
import ning.uploader.model.property.Visibility;
import ning.uploader.resources.IconCreator;
import ning.uploader.resources.Strings;
import ning.uploader.swing.FixedLayout;
import ning.uploader.swing.MultiLineLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemEditor
extends JPanel
implements ValueChangeAnnouncer {
    private final UploadItem item;
    private final AttributeComponentCreator attributeCreator;
    private final FileAttributeList attributeList;
    private final MultiLineLabel label = new MultiLineLabel();
    private final List<JComponent> components = new ArrayList<JComponent>();
    private final List<ValueChangeListener> listeners = new CopyOnWriteArrayList<ValueChangeListener>();

    public ItemEditor(UploadItem item, IconCreator iconCreator, ScalingParameters iconParams, AttributeComponentCreator attributeCreator) {
        this(item, iconParams, attributeCreator);
        this.setText(item.getName());
        this.setIcon(item.getIcon(iconCreator, iconParams, new IconCreator.IconListener(){

            public void iconUpdated(ImageIcon icon) {
                ItemEditor.this.setIcon(icon);
            }
        }));
    }

    public ItemEditor(UploadItem item, ScalingParameters iconParams, AttributeComponentCreator attributeCreator) {
        super(new FixedLayout(FixedLayout.Grow.HORIZONTAL));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.item = item;
        this.attributeCreator = attributeCreator;
        this.attributeList = new FileAttributeList(attributeCreator);
        this.setBackground(this.getBackground());
        this.setOpaque(this.isOpaque());
        Font font = UIManager.getFont("TableHeader.font");
        if (font != null) {
            this.attributeList.setFont(font.deriveFont(1), font);
        }
        switch (item.getType()) {
            case PHOTOS: 
            case VIDEOS: {
                this.addPhotoOrVideoItem(item, font);
                break;
            }
            case MUSIC: {
                this.addMusicItem(item, font);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Don't know how to edit %s", new Object[]{item.getType()}));
            }
        }
        this.label.setMaximumLines(0);
        this.label.setAlignment(MultiLineLabel.Alignment.CENTER);
        if (font != null) {
            this.label.setFont(font.deriveFont(10.0f));
        }
        final Rectangle attributeRect = new Rectangle(0, 0, 450, this.attributeList.getPreferredSize().height);
        final Rectangle labelRect = new Rectangle(attributeRect.x + attributeRect.width, 0, iconParams.getTargetWidth(), attributeRect.height);
        this.add((Component)this.attributeList, new FixedLayout.DynamicRectangle(){

            public Rectangle getRectangle() {
                Insets insets = ItemEditor.this.getInsets();
                attributeRect.width = ItemEditor.this.getWidth() - labelRect.width - insets.left - insets.right;
                attributeRect.height = ((ItemEditor)ItemEditor.this).attributeList.getPreferredSize().height;
                return attributeRect;
            }
        });
        this.label.setOpaque(false);
        this.add((Component)this.label, new FixedLayout.DynamicRectangle(){

            public Rectangle getRectangle() {
                labelRect.x = attributeRect.x + attributeRect.width;
                return labelRect;
            }
        });
    }

    public void addAttribute(String name, String value) {
        this.attributeList.addAttribute(name, value);
    }

    public void addComponent(String name, JComponent component) {
        this.attributeList.addComponent(name, component);
    }

    public void addComponent(JComponent component) {
        this.attributeList.addComponent(component);
    }

    public void setIcon(ImageIcon icon) {
        this.label.setIcon(icon);
        this.repaint();
    }

    public void setText(String text) {
        this.label.setMaximumLines(text == null ? 0 : 2);
        this.label.setText(text);
        this.repaint();
    }

    @Override
    public void setBackground(Color background) {
        super.setBackground(background);
        if (this.attributeList != null) {
            this.attributeList.setBackground(background);
        }
        if (this.components != null) {
            for (JComponent c : this.components) {
                c.setBackground(background);
            }
        }
        this.repaint();
    }

    @Override
    public void setOpaque(boolean opaque) {
        super.setOpaque(opaque);
        if (this.attributeList != null) {
            this.attributeList.setOpaque(opaque);
        }
        if (this.components != null) {
            for (JComponent c : this.components) {
                c.setOpaque(opaque);
            }
        }
        this.repaint();
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeValueChangeListener(ValueChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void setValue(String name, String value) {
        if (name.equals(Strings.TITLE_PROPERTY.get())) {
            this.item.set(Property.TITLE, value);
        } else if (name.equals(Strings.DESCRIPTION_PROPERTY.get())) {
            this.item.set(Property.DESCRIPTION, value);
        } else if (name.equals(Strings.TAGS_PROPERTY.get())) {
            this.item.set(Property.TAGS, value);
        } else if (name.equals(Strings.ARTIST_PROPERTY.get())) {
            this.item.set(Property.ARTIST, value);
        } else if (name.equals(Strings.ALBUM_PROPERTY.get())) {
            this.item.set(Property.ALBUM, value);
        } else if (name.equals(Strings.ENABLE_DOWNLOAD_LINK_PROPERTY.get())) {
            this.item.set(Property.ENABLE_DOWNLOAD_LINK, (Object)Downloadable.valueOf(Boolean.valueOf(value)));
        } else if (name.equals(Strings.ENABLE_PROFILE_USAGE_PROPERTY.get())) {
            this.item.set(Property.ENABLE_PROFILE_USAGE, Boolean.valueOf(value));
        } else if (name.equals(Strings.LICENSE_PROPERTY.get())) {
            if (value.equals(Strings.SELECT_LICENSE.get())) {
                this.item.set(Property.LICENSE, (Object)License.NONE);
            } else if (value.equals(Strings.COPYRIGHT.get())) {
                this.item.set(Property.LICENSE, (Object)License.COPYRIGHT);
            } else if (value.equals(Strings.CC_BY_X.get(Strings.CREATIVE_COMMONS_VERSION.get()))) {
                this.item.set(Property.LICENSE, (Object)License.CC_BY_X);
            } else if (value.equals(Strings.CC_BY_SA_X.get(Strings.CREATIVE_COMMONS_VERSION.get()))) {
                this.item.set(Property.LICENSE, (Object)License.CC_BY_SA_X);
            } else if (value.equals(Strings.CC_BY_ND_X.get(Strings.CREATIVE_COMMONS_VERSION.get()))) {
                this.item.set(Property.LICENSE, (Object)License.CC_BY_ND_X);
            } else if (value.equals(Strings.CC_BY_NC_X.get(Strings.CREATIVE_COMMONS_VERSION.get()))) {
                this.item.set(Property.LICENSE, (Object)License.CC_BY_NC_X);
            } else if (value.equals(Strings.CC_BY_NC_SA_X.get(Strings.CREATIVE_COMMONS_VERSION.get()))) {
                this.item.set(Property.LICENSE, (Object)License.CC_BY_NC_SA_X);
            } else if (value.equals(Strings.CC_BY_NC_ND_X.get(Strings.CREATIVE_COMMONS_VERSION.get()))) {
                this.item.set(Property.LICENSE, (Object)License.CC_BY_NC_ND_X);
            } else if (value.equals(Strings.PUBLIC_DOMAIN.get())) {
                this.item.set(Property.LICENSE, (Object)License.PUBLIC_DOMAIN);
            } else if (value.equals(Strings.OTHER.get())) {
                this.item.set(Property.LICENSE, (Object)License.OTHER);
            }
        } else if (name.equals(Strings.VIEWABLE_BY_PROPERTY.get())) {
            if (value.equals(Strings.VIEWABLE_BY_EVERYONE.get())) {
                this.item.set(Property.VISIBILITY, (Object)Visibility.ALL);
            } else if (value.equals(Strings.VIEWABLE_BY_FRIENDS.get())) {
                this.item.set(Property.VISIBILITY, (Object)Visibility.FRIENDS);
            } else if (value.equals(Strings.VIEWABLE_BY_ME.get())) {
                this.item.set(Property.VISIBILITY, (Object)Visibility.ME);
            }
        }
        for (ValueChangeListener listener : this.listeners) {
            listener.onValueChanged(name, value);
        }
    }

    public Map<String, String> getValues() {
        HashMap<String, String> result = new HashMap<String, String>();
        switch (this.item.getType()) {
            case PHOTOS: 
            case VIDEOS: {
                result.put(Strings.TITLE_PROPERTY.get(), this.item.get(Property.TITLE));
                result.put(Strings.DESCRIPTION_PROPERTY.get(), this.item.get(Property.DESCRIPTION));
                result.put(Strings.TAGS_PROPERTY.get(), this.item.get(Property.TAGS));
                result.put(Strings.VIEWABLE_BY_PROPERTY.get(), this.getViewableBy(this.item.get(Property.VISIBILITY)));
                break;
            }
            case MUSIC: {
                result.put(Strings.TITLE_PROPERTY.get(), this.item.get(Property.TITLE));
                result.put(Strings.ARTIST_PROPERTY.get(), this.item.get(Property.ARTIST));
                result.put(Strings.ALBUM_PROPERTY.get(), this.item.get(Property.ALBUM));
                result.put(Strings.ENABLE_DOWNLOAD_LINK_PROPERTY.get(), this.item.get(Property.ENABLE_DOWNLOAD_LINK));
                result.put(Strings.ENABLE_PROFILE_USAGE_PROPERTY.get(), this.item.get(Property.ENABLE_PROFILE_USAGE));
                result.put(Strings.LICENSE_PROPERTY.get(), this.getLicenseDescription(this.item.get(Property.LICENSE)));
            }
        }
        return result;
    }

    private String getViewableBy(String visibility) {
        if (visibility.equals(Visibility.ME.toString())) {
            return Strings.VIEWABLE_BY_ME.get();
        }
        if (visibility.equals(Visibility.FRIENDS.toString())) {
            return Strings.VIEWABLE_BY_FRIENDS.get();
        }
        return Strings.VIEWABLE_BY_EVERYONE.get();
    }

    private String getLicenseDescription(String url) {
        if (url.equals(License.NONE.toString())) {
            return Strings.SELECT_LICENSE.get();
        }
        if (url.equals(License.COPYRIGHT.toString())) {
            return Strings.COPYRIGHT.get();
        }
        if (url.equals(License.CC_BY_X.toString())) {
            return Strings.CC_BY_X.get(Strings.CREATIVE_COMMONS_VERSION.get());
        }
        if (url.equals(License.CC_BY_SA_X.toString())) {
            return Strings.CC_BY_SA_X.get(Strings.CREATIVE_COMMONS_VERSION.get());
        }
        if (url.equals(License.CC_BY_ND_X.toString())) {
            return Strings.CC_BY_ND_X.get(Strings.CREATIVE_COMMONS_VERSION.get());
        }
        if (url.equals(License.CC_BY_NC_X.toString())) {
            return Strings.CC_BY_NC_X.get(Strings.CREATIVE_COMMONS_VERSION.get());
        }
        if (url.equals(License.CC_BY_NC_SA_X.toString())) {
            return Strings.CC_BY_NC_SA_X.get(Strings.CREATIVE_COMMONS_VERSION.get());
        }
        if (url.equals(License.CC_BY_NC_ND_X.toString())) {
            return Strings.CC_BY_NC_ND_X.get(Strings.CREATIVE_COMMONS_VERSION.get());
        }
        if (url.equals(License.PUBLIC_DOMAIN.toString())) {
            return Strings.PUBLIC_DOMAIN.get();
        }
        if (url.equals(License.OTHER.toString())) {
            return Strings.OTHER.get();
        }
        return Strings.VIEWABLE_BY_EVERYONE.get();
    }

    private void addVisibilityRadioGroup(Font font, ValueChangeListener listener) {
        RadioButtonComponent buttons = new RadioButtonComponent(Strings.VIEWABLE_BY_PROPERTY.get(), this.getViewableBy(this.item.get(Property.VISIBILITY)), new String[]{Strings.VIEWABLE_BY_EVERYONE.get(), Strings.VIEWABLE_BY_FRIENDS.get(), Strings.VIEWABLE_BY_ME.get()});
        buttons.setFont(font);
        this.attributeList.addComponent(Strings.VIEWABLE_BY_PROPERTY.get(), buttons);
        this.components.add(buttons);
        buttons.addValueChangeListener(listener);
    }

    private void addPhotoOrVideoItem(UploadItem item, Font font) {
        ValueChangeListener listener = new ValueChangeListener(){

            public void onValueChanged(String name, String value) {
                ItemEditor.this.setValue(name, value);
            }
        };
        this.attributeList.addAttribute(Strings.TITLE_PROPERTY.get(), item.get(Property.TITLE));
        this.attributeList.addAttribute(Strings.DESCRIPTION_PROPERTY.get(), item.get(Property.DESCRIPTION));
        this.attributeList.addAttribute(Strings.TAGS_PROPERTY.get(), item.get(Property.TAGS));
        this.addVisibilityRadioGroup(font, listener);
        if (this.attributeCreator instanceof ValueChangeAnnouncer) {
            ((ValueChangeAnnouncer)((Object)this.attributeCreator)).addValueChangeListener(listener);
        }
    }

    private void addMusicItem(UploadItem item, Font font) {
        ValueChangeListener listener = new ValueChangeListener(){

            public void onValueChanged(String name, String value) {
                ItemEditor.this.setValue(name, value);
            }
        };
        this.attributeList.addAttribute(Strings.TITLE_PROPERTY.get(), item.get(Property.TITLE));
        this.attributeList.addAttribute(Strings.ARTIST_PROPERTY.get(), item.get(Property.ARTIST));
        this.attributeList.addAttribute(Strings.ALBUM_PROPERTY.get(), item.get(Property.ALBUM));
        if (item.get(Property.ENABLE_DOWNLOAD_LINK, Downloadable.class) != Downloadable.PROHIBITED_IN_NETWORK) {
            CheckBoxComponent enableDownloadLinkCheckBox = new CheckBoxComponent(Strings.ENABLE_DOWNLOAD_LINK_PROPERTY.get());
            enableDownloadLinkCheckBox.addValueChangeListener(listener);
            enableDownloadLinkCheckBox.setFont(font);
            enableDownloadLinkCheckBox.setSelected(Boolean.valueOf(item.get(Property.ENABLE_DOWNLOAD_LINK)));
            this.attributeList.addComponent("", enableDownloadLinkCheckBox);
        }
        CheckBoxComponent enableProfileUsageCheckBox = new CheckBoxComponent(Strings.ENABLE_PROFILE_USAGE_PROPERTY.get());
        enableProfileUsageCheckBox.addValueChangeListener(listener);
        enableProfileUsageCheckBox.setFont(font);
        enableProfileUsageCheckBox.setSelected(Boolean.valueOf(item.get(Property.ENABLE_PROFILE_USAGE)));
        this.attributeList.addComponent("", enableProfileUsageCheckBox);
        ComboBoxComponent licenseBox = new ComboBoxComponent(Strings.LICENSE_PROPERTY.get(), new String[]{Strings.SELECT_LICENSE.get(), Strings.COPYRIGHT.get(), Strings.CC_BY_X.get(Strings.CREATIVE_COMMONS_VERSION.get()), Strings.CC_BY_SA_X.get(Strings.CREATIVE_COMMONS_VERSION.get()), Strings.CC_BY_ND_X.get(Strings.CREATIVE_COMMONS_VERSION.get()), Strings.CC_BY_NC_X.get(Strings.CREATIVE_COMMONS_VERSION.get()), Strings.CC_BY_NC_SA_X.get(Strings.CREATIVE_COMMONS_VERSION.get()), Strings.CC_BY_NC_ND_X.get(Strings.CREATIVE_COMMONS_VERSION.get()), Strings.PUBLIC_DOMAIN.get(), Strings.OTHER.get()});
        licenseBox.setFont(font);
        licenseBox.setSelectedItem(this.getLicenseDescription(item.get(Property.LICENSE)));
        licenseBox.addValueChangeListener(listener);
        this.attributeList.addComponent(Strings.LICENSE_PROPERTY.get(), licenseBox);
        if (this.attributeCreator instanceof ValueChangeAnnouncer) {
            ((ValueChangeAnnouncer)((Object)this.attributeCreator)).addValueChangeListener(listener);
        }
    }
}

