/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import ning.uploader.editor.MutableComponent;
import ning.uploader.editor.ValueChangeAnnouncer;
import ning.uploader.editor.ValueChangeListener;
import ning.uploader.focus.TabFocus;

public class ComboBoxComponent
extends JPanel
implements ValueChangeAnnouncer,
MutableComponent {
    private final List<ValueChangeListener> listeners = new CopyOnWriteArrayList<ValueChangeListener>();
    private final String name;
    private final TabFocusComboBox comboBox;

    public ComboBoxComponent(final String name, String[] choices) {
        super(new BorderLayout());
        this.setOpaque(false);
        this.name = name;
        this.comboBox = new TabFocusComboBox(choices);
        this.comboBox.putClientProperty("JComboBox.isSquare", Boolean.TRUE);
        this.comboBox.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                for (ValueChangeListener listener : ComboBoxComponent.this.listeners) {
                    listener.onValueChanged(name, ComboBoxComponent.this.comboBox.getSelectedItem().toString());
                }
            }
        });
        this.add((Component)this.comboBox, "Center");
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.comboBox != null) {
            this.comboBox.setFont(font);
        }
    }

    public void setSelectedItem(String item) {
        if (!this.comboBox.getSelectedItem().equals(item)) {
            this.comboBox.setSelectedItem(item);
            for (ValueChangeListener listener : this.listeners) {
                listener.onValueChanged(this.name, item);
            }
        }
    }

    public void addValueChangeListener(ValueChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeValueChangeListener(ValueChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void setText(String text) {
        this.setSelectedItem(text);
    }

    private class TabFocusComboBox
    extends JComboBox
    implements TabFocus {
        public TabFocusComboBox(String[] choices) {
            super(choices);
        }
    }
}

