/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import ning.uploader.editor.MutableComponent;
import ning.uploader.editor.ValueChangeAnnouncer;
import ning.uploader.editor.ValueChangeListener;
import ning.uploader.focus.TabFocus;

public class CheckBoxComponent
extends JPanel
implements ValueChangeAnnouncer,
MutableComponent {
    private final List<ValueChangeListener> listeners = new CopyOnWriteArrayList<ValueChangeListener>();
    private final TabFocusCheckBox checkBox;
    private final String name;

    public CheckBoxComponent(String name) {
        super(new BorderLayout());
        this.setOpaque(false);
        this.name = name;
        this.checkBox = new TabFocusCheckBox(name);
        this.checkBox.setOpaque(false);
        this.checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                for (ValueChangeListener listener : CheckBoxComponent.this.listeners) {
                    listener.onValueChanged(CheckBoxComponent.this.checkBox.getText(), Boolean.toString(CheckBoxComponent.this.checkBox.isSelected()));
                }
            }
        });
        this.add((Component)this.checkBox, "West");
    }

    public String getName() {
        return this.name;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.checkBox != null) {
            this.checkBox.setFont(font);
        }
    }

    public void setSelected(boolean selected) {
        if (this.checkBox.isSelected() != selected) {
            this.checkBox.setSelected(selected);
            for (ValueChangeListener listener : this.listeners) {
                listener.onValueChanged(this.checkBox.getText(), Boolean.toString(selected));
            }
        }
    }

    public void addValueChangeListener(ValueChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeValueChangeListener(ValueChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void setText(String text) {
        this.setSelected(Boolean.valueOf(text));
    }

    private class TabFocusCheckBox
    extends JCheckBox
    implements TabFocus {
        public TabFocusCheckBox(String name) {
            super(name);
        }
    }
}

