/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.dnd;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import ning.uploader.dnd.FileDragSourceDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDragSource {
    private static final int DRAG_IMAGE_WIDTH = 512;
    private static final int DRAG_IMAGE_HEIGHT = 150;
    private static final int FADE_START = 100;
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private static final GradientPaint TRANPARENT_GRADIENT = new GradientPaint(0.0f, 100.0f, Color.GREEN, 0.0f, 150.0f, TRANSPARENT);
    private static final DataFlavor[] FILE_LIST_FLAVOR = new DataFlavor[]{DataFlavor.javaFileListFlavor};

    public static <T> void install(Component component, final FileDragSourceDelegate<T> delegate) {
        final BufferedImage dragImage = new BufferedImage(512, 150, 3);
        final DragSource source = DragSource.getDefaultDragSource();
        source.createDefaultDragGestureRecognizer(component, 1, new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent event) {
                final Iterable selectedValues = delegate.getSelectedValues();
                Iterator iter = selectedValues.iterator();
                if (iter.hasNext()) {
                    delegate.startDrag(selectedValues);
                    FileDragSource.updateDragImage(dragImage, delegate, selectedValues);
                    source.startDrag(event, DragSource.DefaultCopyDrop, dragImage, new Point(0, 0), new Transferable(){

                        public DataFlavor[] getTransferDataFlavors() {
                            return FILE_LIST_FLAVOR;
                        }

                        public boolean isDataFlavorSupported(DataFlavor flavor) {
                            return FILE_LIST_FLAVOR[0].equals(flavor);
                        }

                        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                            if (this.isDataFlavorSupported(flavor)) {
                                ArrayList<File> data = new ArrayList<File>();
                                for (Object v : selectedValues) {
                                    data.add(delegate.getFileForValue(v));
                                }
                                return data;
                            }
                            return null;
                        }
                    }, new DragSourceAdapter(){

                        public void dragEnter(DragSourceDragEvent dsde) {
                            super.dragEnter(dsde);
                        }

                        public void dragExit(DragSourceEvent dse) {
                            super.dragExit(dse);
                        }

                        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
                            super.dragDropEnd(dragSourceDropEvent);
                        }
                    });
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void updateDragImage(BufferedImage dragImage, FileDragSourceDelegate<T> delegate, Iterable<T> selectedValues) {
        BufferedImage bufferedImage = dragImage;
        synchronized (bufferedImage) {
            Iterator<T> iter = selectedValues.iterator();
            if (!iter.hasNext()) {
                Graphics2D graphics = dragImage.createGraphics();
                graphics.setComposite(AlphaComposite.Src);
                graphics.setColor(TRANSPARENT);
                graphics.fillRect(0, 0, dragImage.getWidth(), dragImage.getHeight());
                graphics.dispose();
                return;
            }
            Graphics2D graphics = dragImage.createGraphics();
            graphics.setComposite(AlphaComposite.getInstance(2));
            graphics.setColor(TRANSPARENT);
            graphics.fillRect(0, 0, dragImage.getWidth(), dragImage.getHeight());
            graphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
            int totalTranslation = 0;
            for (T v : selectedValues) {
                Rectangle bounds = delegate.getValueBounds(v);
                bounds.y = 0;
                delegate.renderValue(graphics, bounds, v);
                graphics.translate(0, bounds.height);
                if ((totalTranslation += bounds.height) < 150) continue;
                break;
            }
            graphics.translate(0, -totalTranslation);
            graphics.setPaint(TRANPARENT_GRADIENT);
            graphics.setComposite(AlphaComposite.DstIn);
            graphics.fillRect(0, 100, dragImage.getWidth(), dragImage.getHeight());
            graphics.dispose();
        }
    }
}

