/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader.alerter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.RootPaneContainer;
import ning.uploader.alerter.Alerter;
import ning.uploader.alerter.Callback;
import ning.uploader.alerter.Choices;
import ning.uploader.alerter.Chosen;
import ning.uploader.alerter.Popup;
import ning.uploader.alerter.ProgressBar;
import ning.uploader.resources.Strings;

public class AlerterPanel
implements Alerter {
    private Background infoBackground = new Background(new Color(153, 204, 0), new Color(172, 213, 47), new Color(136, 187, 0), new Color(152, 203, 0), new Color(229, 255, 204), new Color(204, 255, 153));
    private Background warningBackground = new Background(new Color(255, 204, 0), new Color(255, 213, 47), new Color(247, 187, 0), new Color(254, 203, 0), new Color(255, 255, 204), new Color(255, 255, 153));
    private Background errorBackground = new Background(new Color(255, 0, 0), new Color(255, 47, 47), new Color(238, 0, 0), new Color(254, 0, 0), new Color(255, 221, 221), new Color(255, 187, 187));
    private Background statusBackground = new Background(new Color(136, 136, 136), new Color(119, 119, 119), new Color(104, 104, 104), new Color(85, 85, 85), new Color(221, 221, 221), new Color(255, 255, 255));
    private final JPanel glassPanel = new JPanel(new GridBagLayout()){

        public void paintComponent(Graphics g) {
            g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.5f));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paintComponent(g);
        }
    };
    private final JPanel actionPanel = new JPanel(new FlowLayout(2));
    private final ExecutorService executor = Executors.newFixedThreadPool(1);
    private final JTextArea titleText;
    private final JTextArea messageText;
    private final ProgressBar progressBar = new ProgressBar();
    private Alert current = null;
    private Background background = this.infoBackground;

    public AlerterPanel(RootPaneContainer container) {
        JPanel innerPanel = new JPanel(new BorderLayout());
        this.titleText = new JTextArea(){

            protected void paintComponent(Graphics g) {
                AlerterPanel.this.background.drawHeader(g, this);
                super.paintComponent(g);
            }
        };
        Font font = Font.decode("Arial");
        if (font == null) {
            font = Font.decode("Helvetica");
        }
        if (font == null) {
            font = this.titleText.getFont();
        }
        this.titleText.setForeground(Color.WHITE);
        this.titleText.setOpaque(false);
        this.titleText.setFont(font.deriveFont(1));
        this.titleText.setEditable(false);
        this.titleText.setBorder(BorderFactory.createEmptyBorder(7, 10, 7, 10));
        this.titleText.setLineWrap(true);
        this.titleText.setWrapStyleWord(true);
        this.messageText = new JTextArea();
        this.messageText.setForeground(new Color(102, 102, 102));
        this.messageText.setOpaque(false);
        this.messageText.setFont(font);
        this.messageText.setEditable(false);
        this.messageText.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        this.messageText.setLineWrap(true);
        this.messageText.setWrapStyleWord(true);
        this.actionPanel.setOpaque(false);
        this.progressBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 7, 0, 7), BorderFactory.createEtchedBorder()));
        JPanel messagePanel = new JPanel(new BorderLayout()){

            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = 300;
                return dim;
            }

            protected void paintComponent(Graphics g) {
                AlerterPanel.this.background.drawBody(g, this);
            }
        };
        messagePanel.setOpaque(true);
        messagePanel.add((Component)this.progressBar, "North");
        messagePanel.add((Component)this.messageText, "Center");
        messagePanel.add((Component)this.actionPanel, "South");
        innerPanel.add((Component)this.titleText, "North");
        innerPanel.add((Component)messagePanel, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        this.glassPanel.add((Component)innerPanel, c);
        this.glassPanel.addMouseListener(new MouseAdapter(){});
        this.glassPanel.setDropTarget(new DropTarget());
        this.glassPanel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 27) {
                    AlerterPanel.this.close();
                }
            }
        });
        this.glassPanel.setOpaque(false);
        container.setGlassPane(this.glassPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        JPanel jPanel = this.glassPanel;
        synchronized (jPanel) {
            this.glassPanel.setVisible(false);
            this.glassPanel.repaint();
            this.glassPanel.notifyAll();
            this.current = null;
        }
    }

    public void destroy() {
        this.executor.shutdownNow();
    }

    public Popup info(String title, String message, Choices choices, Callback callback) {
        return this.enqueue(this.infoBackground, title, message, choices, callback);
    }

    public Popup warning(String title, String message, Choices choices, Callback callback) {
        return this.enqueue(this.warningBackground, title, message, choices, callback);
    }

    public Popup error(String title, String message, Choices choices, Callback callback) {
        return this.enqueue(this.errorBackground, title, message, choices, callback);
    }

    public Popup status(String title, String message, Choices choices, Callback callback) {
        return this.enqueue(this.statusBackground, title, message, choices, callback);
    }

    private JButton createButton(String text, boolean isDefault, final Chosen chosen, final Callback callback) {
        JButton button = new JButton(text);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                callback.onChosen(chosen);
                AlerterPanel.this.close();
            }
        });
        button.setDefaultCapable(isDefault);
        button.setOpaque(false);
        return button;
    }

    private Popup enqueue(Background background, String title, String message, Choices choices, Callback callback) {
        final Alert alert = new Alert(background, title, message, choices, callback);
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (alert.close) {
                    return;
                }
                try {
                    JPanel jPanel = AlerterPanel.this.glassPanel;
                    synchronized (jPanel) {
                        while (AlerterPanel.this.glassPanel.isVisible()) {
                            AlerterPanel.this.glassPanel.wait();
                        }
                        AlerterPanel.this.current = alert;
                        AlerterPanel.this.background = alert.background;
                        AlerterPanel.this.titleText.setText(alert.title);
                        AlerterPanel.this.messageText.setText(alert.message);
                        AlerterPanel.this.progressBar.setVisible(false);
                        ArrayList<JButton> buttons = new ArrayList<JButton>();
                        AlerterPanel.this.actionPanel.removeAll();
                        switch (alert.choices) {
                            case OKAY: {
                                buttons.add(AlerterPanel.this.createButton(Strings.OKAY_BUTTON.get(), true, Chosen.OKAY, alert.callback));
                                break;
                            }
                            case CANCEL: {
                                buttons.add(AlerterPanel.this.createButton(Strings.CANCEL_BUTTON.get(), true, Chosen.CANCEL, alert.callback));
                                break;
                            }
                            case CANCEL_CONITNUE: {
                                buttons.add(AlerterPanel.this.createButton(Strings.CANCEL_BUTTON.get(), false, Chosen.CANCEL, alert.callback));
                                buttons.add(AlerterPanel.this.createButton(Strings.CONTINUE_BUTTON.get(), true, Chosen.CONTINUE, alert.callback));
                                break;
                            }
                            case YES_NO: {
                                buttons.add(AlerterPanel.this.createButton(Strings.YES_BUTTON.get(), false, Chosen.YES, alert.callback));
                                buttons.add(AlerterPanel.this.createButton(Strings.NO_BUTTON.get(), true, Chosen.NO, alert.callback));
                                break;
                            }
                            case NO_YES: {
                                buttons.add(AlerterPanel.this.createButton(Strings.NO_BUTTON.get(), false, Chosen.NO, alert.callback));
                                buttons.add(AlerterPanel.this.createButton(Strings.YES_BUTTON.get(), true, Chosen.YES, alert.callback));
                                break;
                            }
                        }
                        for (JButton button : buttons) {
                            AlerterPanel.this.actionPanel.add(button);
                            if (!button.isDefaultCapable()) continue;
                            AlerterPanel.this.glassPanel.getRootPane().setDefaultButton(button);
                        }
                        AlerterPanel.this.glassPanel.setVisible(true);
                        AlerterPanel.this.glassPanel.repaint();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        return new Popup(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() {
                JPanel jPanel = AlerterPanel.this.glassPanel;
                synchronized (jPanel) {
                    alert.close = true;
                    if (alert.equals(AlerterPanel.this.current)) {
                        AlerterPanel.this.close();
                    }
                }
            }

            public void setProgress(double percent) {
                AlerterPanel.this.progressBar.setValue(percent);
                AlerterPanel.this.progressBar.setVisible(true);
            }

            public void setTitle(String title) {
                AlerterPanel.this.titleText.setText(title);
                AlerterPanel.this.titleText.repaint();
            }

            public void setMessage(String message) {
                AlerterPanel.this.messageText.setText(message);
                AlerterPanel.this.messageText.repaint();
            }
        };
    }

    private static class Alert {
        private Background background;
        private String title;
        private String message;
        private Choices choices;
        private Callback callback;
        private boolean close = false;

        public Alert(Background background, String title, String message, Choices choices, Callback callback) {
            this.background = background;
            this.title = title;
            this.message = message;
            this.choices = choices;
            this.callback = callback;
        }
    }

    private static class Background {
        private Color headerBrightTop;
        private Color headerBrightBottom;
        private Color headerDarkTop;
        private Color headerDarkBottom;
        private Color bodyTop;
        private Color bodyBottom;

        private Background(Color headerBrightTop, Color headerBrightBottom, Color headerDarkTop, Color headerDarkBottom, Color bodyTop, Color bodyBottom) {
            this.headerBrightTop = headerBrightTop;
            this.headerBrightBottom = headerBrightBottom;
            this.headerDarkTop = headerDarkTop;
            this.headerDarkBottom = headerDarkBottom;
            this.bodyTop = bodyTop;
            this.bodyBottom = bodyBottom;
        }

        public void drawHeader(Graphics g, Component c) {
            int width = c.getWidth();
            int height = c.getHeight();
            int split = 45 * height / 100;
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setPaint(new GradientPaint(0.0f, 0.0f, this.headerBrightTop, 0.0f, split, this.headerBrightBottom));
            g2.fillRect(0, 0, width, split);
            g2.setPaint(new GradientPaint(0.0f, split, this.headerDarkTop, 0.0f, height, this.headerDarkBottom));
            g2.fillRect(0, split, width, height);
            g2.dispose();
        }

        public void drawBody(Graphics g, Component c) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setBackground(this.bodyBottom);
            g2.setPaint(new GradientPaint(0.0f, 0.0f, this.bodyTop, 0.0f, 100.0f, this.bodyBottom));
            g2.fillRect(0, 0, c.getWidth(), c.getHeight());
            g2.setColor(this.headerDarkBottom);
            g2.drawRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
            g2.dispose();
        }
    }
}

