/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.JApplet;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import ning.uploader.Cookie;
import ning.uploader.FileBrowserPanel;
import ning.uploader.ProgressDialog;
import ning.uploader.UploadPanel;
import ning.uploader.alerter.Alerter;
import ning.uploader.alerter.AlerterHelper;
import ning.uploader.alerter.AlerterPanel;
import ning.uploader.alerter.Callback;
import ning.uploader.alerter.Choices;
import ning.uploader.alerter.Chosen;
import ning.uploader.editor.EditorList;
import ning.uploader.filebrowser.FileElement;
import ning.uploader.filter.FileExtensionFilter;
import ning.uploader.filter.MusicFilter;
import ning.uploader.filter.PhotosFilter;
import ning.uploader.filter.VideosFilter;
import ning.uploader.http.HttpPost;
import ning.uploader.icon.ScalingParameters;
import ning.uploader.info.DefaultFileInfoRenderer;
import ning.uploader.info.PhotoInfoRenderer;
import ning.uploader.logging.Level;
import ning.uploader.logging.Logger;
import ning.uploader.model.MusicItemFactory;
import ning.uploader.model.PhotoItemFactory;
import ning.uploader.model.UploadItem;
import ning.uploader.model.UploadItemFactory;
import ning.uploader.model.VideoItemFactory;
import ning.uploader.resources.IconCreator;
import ning.uploader.resources.Strings;
import ning.uploader.uploadlist.UploadList;
import ning.uploader.uploadlist.UploadListModel;

public class UploaderApplet
extends JApplet {
    private static final Logger log = Logger.getLogger(UploaderApplet.class);
    private final CardLayout cards = new CardLayout();
    private final IconCreator iconCreator = new IconCreator();
    private final UploadListModel backingList = new UploadListModel();
    private final ScalingParameters uploadParams = new ScalingParameters(105, 105, 4, 4);
    private final ScalingParameters editorParams = new ScalingParameters(115, 60, 0, 0);
    private final ScalingParameters photoInfoParams = new ScalingParameters(180, 85, 0, 0);
    private AlerterPanel alerter;
    private HttpPost httpPost;
    private AppletContext context;

    public void init() {
        try {
            DefaultFileInfoRenderer fileInfoRenderer;
            FileExtensionFilter filter;
            UploadItemFactory factory;
            this.alerter = new AlerterPanel(this);
            this.context = this.getAppletContext();
            HyperlinkListener hyperlinkListener = new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent event) {
                    URL url;
                    HyperlinkEvent.EventType type = event.getEventType();
                    try {
                        url = UploaderApplet.this.buildUrl(UploaderApplet.this.getDocumentBase(), event.getDescription());
                    }
                    catch (MalformedURLException e) {
                        log.warn(String.format("Bogus link url: %s", event.getDescription()), e);
                        AlerterHelper.error((Alerter)UploaderApplet.this.alerter, Strings.ERROR_UNEXPECTED_TITLE, Strings.ERROR_UNEXPECTED_DESCRIPTION, new String[0]);
                        return;
                    }
                    if (type.equals(HyperlinkEvent.EventType.ACTIVATED)) {
                        UploaderApplet.this.context.showDocument(url, "_blank");
                    } else if (type.equals(HyperlinkEvent.EventType.ENTERED)) {
                        UploaderApplet.this.context.showStatus(url.toString());
                    } else if (type.equals(HyperlinkEvent.EventType.EXITED)) {
                        UploaderApplet.this.context.showStatus("");
                    }
                }
            };
            if (System.getProperty("os.name").startsWith("Windows") && "1.6.0-oem".equals(System.getProperty("java.version"))) {
                this.alerter.error(Strings.UPDATE_JAVA_TITLE.get(), Strings.UPDATE_JAVA_DESCRIPTION.get(), Choices.OKAY, new Callback(){

                    public void onChosen(Chosen chosen) {
                        try {
                            UploaderApplet.this.context.showDocument(new URL("http://java.com/"));
                        }
                        catch (MalformedURLException e) {
                            log.warn("This should never happen", e);
                        }
                    }
                });
                return;
            }
            String loggerOverrides = this.getParameter("logger-overrides");
            String defaultLogLevel = this.getParameter("default-log-level");
            boolean showDisabledFiles = Boolean.valueOf(this.getParameter("show-disabled-files"));
            boolean downloadEnabled = Boolean.valueOf(this.getParameter("download-enabled"));
            URL uploadUrl = this.getUrlParameter("upload-url");
            URL successUrl = this.getUrlParameter("success-url");
            Type type = Type.valueOf(this.getParameter("uploader-type"));
            Integer maxItems = this.getIntegerParameter("max-items");
            FileBrowserPanel.Type fileBrowserType = this.getFileBrowserType(this.getParameter("file-browser-type"));
            final Container contentPane = this.getContentPane();
            contentPane.setLayout(this.cards);
            this.parseLoggerSettings(loggerOverrides, defaultLogLevel);
            this.registerJavascriptHooks();
            this.registerScalingParams();
            FileElement.setDefaultShowDisabledFiles(showDisabledFiles);
            this.httpPost = new HttpPost(uploadUrl);
            Strings.setTypePrefix(type.toString());
            switch (type) {
                case PHOTOS: {
                    factory = new PhotoItemFactory();
                    filter = new PhotosFilter();
                    fileInfoRenderer = new PhotoInfoRenderer(filter, this.iconCreator, this.photoInfoParams);
                    break;
                }
                case VIDEOS: {
                    factory = new VideoItemFactory();
                    filter = new VideosFilter();
                    fileInfoRenderer = new DefaultFileInfoRenderer(filter);
                    break;
                }
                case MUSIC: {
                    factory = new MusicItemFactory(downloadEnabled);
                    filter = new MusicFilter();
                    fileInfoRenderer = new DefaultFileInfoRenderer(filter);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unknown type %s", this.getParameter("uploader-type")));
                }
            }
            UploadList uploadList = new UploadList(this.iconCreator, this.uploadParams, this.backingList, filter, factory, this.alerter);
            if (maxItems != null) {
                uploadList.setMaxItems(maxItems);
            } else if (type == Type.VIDEOS) {
                uploadList.setMaxItems(30);
            }
            UploadPanel uploadPanel = new UploadPanel(uploadList, this.backingList, hyperlinkListener);
            EditorList editorPanel = this.createEditorList(factory, successUrl, hyperlinkListener);
            JPanel selectionPanel = new JPanel(new BorderLayout(10, 0));
            selectionPanel.setBackground(Color.WHITE);
            FileBrowserPanel fileBrowserPanel = new FileBrowserPanel(fileBrowserType, filter, fileInfoRenderer, uploadList);
            fileBrowserPanel.setPreferredSize(new Dimension(200, -1));
            selectionPanel.add((Component)fileBrowserPanel, "West");
            uploadPanel.addNextListener(new UploadPanel.NextListener(){

                public void onNext() {
                    UploaderApplet.this.cards.show(contentPane, "Editor");
                }
            });
            selectionPanel.add((Component)uploadPanel, "Center");
            contentPane.add("Selection", selectionPanel);
            contentPane.add("Editor", editorPanel);
            this.cards.show(contentPane, "Selection");
        }
        catch (Exception e) {
            log.error("Failed to init applet", e);
            AlerterHelper.error((Alerter)this.alerter, Strings.ERROR_UNEXPECTED_TITLE, Strings.ERROR_UNEXPECTED_DESCRIPTION, new String[0]);
        }
        if (Boolean.valueOf(this.getParameter("debug-memory")).booleanValue()) {
            this.showMemoryStats();
        }
    }

    public void destroy() {
        this.iconCreator.clearCache();
        this.alerter.destroy();
        super.destroy();
    }

    private URL buildUrl(URL baseUrl, String uri) throws MalformedURLException {
        try {
            return new URL(uri);
        }
        catch (MalformedURLException e) {
            String path = uri;
            if (!uri.startsWith("/")) {
                path = baseUrl.getPath();
                int index = path.lastIndexOf(47);
                path = index != -1 ? path.substring(0, index + 1) + uri : "/" + uri;
            }
            return new URL(baseUrl.getProtocol(), baseUrl.getHost(), baseUrl.getPort(), path);
        }
    }

    private EditorList createEditorList(UploadItemFactory factory, URL successUrl, HyperlinkListener listener) {
        Object batchItem = factory.createItem((File)null);
        EditorList editorPanel = new EditorList(this.iconCreator, this.editorParams, this.backingList, (UploadItem)batchItem, listener);
        final ProgressDialog poster = new ProgressDialog(this.httpPost, this.backingList, this.alerter, this.context, successUrl);
        editorPanel.addCancelListener(new EditorList.CancelListener(){

            public void onCancel() {
                UploaderApplet.this.cards.show(UploaderApplet.this.getContentPane(), "Selection");
            }
        });
        editorPanel.addUploadListener(new EditorList.UploadListener(){

            public void onUpload() {
                poster.doPost();
            }
        });
        return editorPanel;
    }

    private FileBrowserPanel.Type getFileBrowserType(String type) {
        FileBrowserPanel.Type fileBrowserType = FileBrowserPanel.Type.LIST;
        if (type != null) {
            try {
                fileBrowserType = FileBrowserPanel.Type.valueOf(type);
            }
            catch (Exception e) {
                log.info(String.format("Failed to set file browser type to %s: using %s default", new Object[]{type, fileBrowserType}), e);
            }
        }
        return fileBrowserType;
    }

    private URL getUrlParameter(String name) throws MalformedURLException {
        URL baseUrl = this.getDocumentBase();
        URL url = this.buildUrl(baseUrl, this.getParameter(name));
        if (!baseUrl.getHost().equals(url.getHost()) && !baseUrl.getProtocol().equals("file")) {
            throw new IllegalStateException(String.format("Target URL is not under base URL: %s\t%s", url, baseUrl));
        }
        return url;
    }

    private Integer getIntegerParameter(String name) {
        Integer result = null;
        String param = this.getParameter(name);
        if (param != null) {
            try {
                result = Integer.parseInt(param);
            }
            catch (NumberFormatException e) {
                log.warn("Failed to parse int param %s = %s");
            }
        }
        return result;
    }

    private void parseLoggerSettings(String loggerOverrides, String defaultLevel) {
        if (defaultLevel != null) {
            try {
                Logger.setDefaultLevel(Level.valueOf(defaultLevel));
            }
            catch (Exception e) {
                log.warn(String.format("Failed to set default log level to: %s", defaultLevel), e);
            }
        }
        if (loggerOverrides != null) {
            String[] parts;
            for (String override : parts = loggerOverrides.split(";[\\s]*")) {
                try {
                    String[] classAndLevel = override.split("[\\s]*=[\\s]*");
                    Logger.setLevel(classAndLevel[0], Level.valueOf(classAndLevel[1]));
                }
                catch (Exception e) {
                    log.warn(String.format("Failed to set logger override: %s", override), e);
                }
            }
        }
    }

    private void registerJavascriptHooks() {
        try {
            JSObject window = JSObject.getWindow((Applet)this);
            Strings.setWindow(window);
            Cookie.setWindow(window);
        }
        catch (JSException e) {
            log.info("Failed to get window object -- perhaps we're not in a browser");
        }
    }

    private void registerScalingParams() {
        this.iconCreator.registerParameters(this.uploadParams);
        this.iconCreator.registerParameters(this.editorParams);
        this.iconCreator.registerParameters(this.photoInfoParams);
    }

    private void showMemoryStats() {
        Executors.newScheduledThreadPool(1).scheduleWithFixedDelay(new Runnable(){

            public void run() {
                long total = Runtime.getRuntime().totalMemory();
                long used = total - Runtime.getRuntime().freeMemory();
                UploaderApplet.this.context.showStatus(String.format("%dMB / %dMB (%d%%)", used / 1024L / 1024L, total / 1024L / 1024L, 100L * used / total));
            }
        }, 0L, 2L, TimeUnit.SECONDS);
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            UIManager.put("CheckBox.background", new Color(0, 0, 0, 0));
        }
        catch (Exception e) {
            log.info("Failed to set look and feel", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PHOTOS,
        VIDEOS,
        MUSIC;

    }
}

