/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import ning.uploader.resources.Strings;
import ning.uploader.swing.FooterPanel;
import ning.uploader.swing.FourSidedBorder;
import ning.uploader.swing.HeaderPanel;
import ning.uploader.swing.MessagePanel;
import ning.uploader.uploadlist.UploadList;
import ning.uploader.uploadlist.UploadListModel;

public class UploadPanel
extends JPanel {
    private List<NextListener> nextListeners = new CopyOnWriteArrayList<NextListener>();

    public UploadPanel(final UploadList uploadList, final UploadListModel backingList, HyperlinkListener listener) {
        super(new BorderLayout(), true);
        JPanel panelContainer = new JPanel(new BorderLayout());
        FourSidedBorder panelBorder = new FourSidedBorder(new Insets(1, 1, 0, 1), FooterPanel.BORDER_COLOR);
        panelContainer.setBorder(panelBorder);
        HeaderPanel header = new HeaderPanel();
        header.setLeftLabel(Strings.UPLOAD_HEADER.get(), 2, true);
        header.setRightLabel(Strings.DRAG_OUT_INSTRUCTIONS.get(), 4, false);
        panelContainer.add((Component)header, "North");
        JScrollPane uploadListScrollPane = new JScrollPane(uploadList);
        uploadListScrollPane.setBorder(BorderFactory.createEmptyBorder());
        panelContainer.add((Component)uploadListScrollPane, "Center");
        final MessagePanel messagePanel = new MessagePanel(Strings.UPLOAD_LIMIT_WARNING.get(Integer.toString(uploadList.getMaxItems())), listener);
        panelContainer.add((Component)messagePanel, "South");
        backingList.addListDataListener(new ListDataListener(){

            private void update() {
                int size = backingList.size();
                Strings message = size == 0 ? Strings.UPLOAD_LIMIT_WARNING : Strings.UPLOAD_LIMIT_COUNTDOWN;
                messagePanel.setText(message.get(Integer.toString(uploadList.getMaxItems() - size)));
            }

            public void intervalAdded(ListDataEvent e) {
                this.update();
            }

            public void intervalRemoved(ListDataEvent e) {
                this.update();
            }

            public void contentsChanged(ListDataEvent e) {
                this.update();
            }
        });
        final JButton nextButton = new JButton(Strings.NEXT_BUTTON.get());
        nextButton.setOpaque(false);
        nextButton.setEnabled(false);
        nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (NextListener listener : UploadPanel.this.nextListeners) {
                    listener.onNext();
                }
            }
        });
        FooterPanel footer = new FooterPanel();
        footer.add((Component)nextButton, "East");
        this.add((Component)panelContainer, "Center");
        this.add((Component)footer, "South");
        final ListModel model = uploadList.getModel();
        model.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                nextButton.setEnabled(model.getSize() > 0);
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                nextButton.setEnabled(model.getSize() > 0);
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                nextButton.setEnabled(model.getSize() > 0);
            }
        });
    }

    public void addNextListener(NextListener listener) {
        this.nextListeners.add(listener);
    }

    public void removeNextListener(NextListener listener) {
        this.nextListeners.remove(listener);
    }

    public static interface NextListener {
        public void onNext();
    }
}

