/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import ning.uploader.info.FileInfoRenderer;
import ning.uploader.resources.ResourceLoader;
import ning.uploader.resources.Strings;
import ning.uploader.swing.FooterPanel;

public class InformationPanel
extends FooterPanel {
    private ImageIcon closedIcon = new ImageIcon(ResourceLoader.loadImage("info-closed.png"));
    private Font closedFont;
    private ImageIcon expandedIcon = new ImageIcon(ResourceLoader.loadImage("info-expanded.png"));
    private Font expandedFont;
    private JLabel label;
    private final JPanel infoPanel = new JPanel(new CardLayout());
    private boolean autoExpand;
    private boolean expanded = true;
    private File[] files = null;
    private final FileInfoRenderer fileInfoRenderer;
    private Border fileInfoBorder = BorderFactory.createEmptyBorder(0, 0, 5, 0);

    public InformationPanel(FileInfoRenderer fileInfoRenderer, boolean autoExpand) {
        this.fileInfoRenderer = fileInfoRenderer;
        this.autoExpand = autoExpand;
        this.infoPanel.setLayout(new BorderLayout());
        this.label = new JLabel(Strings.FILE_INFORMATION_HEADER.get(), this.closedIcon, 2);
        this.label.setBorder(BorderFactory.createEmptyBorder(4, 6, 4, 6));
        Font font = UIManager.getFont("TableHeader.font");
        if (font != null) {
            this.closedFont = font;
            fileInfoRenderer.setFont(font);
        } else {
            this.closedFont = this.getFont();
        }
        this.expandedFont = this.closedFont.deriveFont(1);
        this.add((Component)this.label, "North");
        this.label.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseClicked(MouseEvent e) {
                JPanel jPanel = InformationPanel.this.infoPanel;
                synchronized (jPanel) {
                    InformationPanel.this.autoExpand = false;
                    InformationPanel.this.expanded = !InformationPanel.this.expanded;
                    InformationPanel.this.updatePanel();
                }
            }
        });
        this.add((Component)this.infoPanel, "Center");
        this.updatePanel();
    }

    public void setFiles(File ... files) {
        this.files = files;
        this.updatePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePanel() {
        JPanel jPanel = this.infoPanel;
        synchronized (jPanel) {
            if (this.autoExpand && !this.expanded && this.files != null && this.files.length > 0) {
                this.expanded = true;
            }
            if (this.expanded) {
                this.label.setIcon(this.expandedIcon);
                this.label.setFont(this.expandedFont);
                this.infoPanel.removeAll();
                this.fileInfoRenderer.cancelPendingCalculations();
                JComponent c = this.fileInfoRenderer.getComponentForFiles(this.files);
                c.setBackground(this.getBackground());
                c.setBorder(this.fileInfoBorder);
                this.infoPanel.add((Component)c, "North");
            } else {
                this.label.setIcon(this.closedIcon);
                this.label.setFont(this.closedFont);
                this.infoPanel.removeAll();
            }
            if (this.getParent() != null) {
                this.getParent().validate();
            }
        }
    }
}

