/*
 * Decompiled with CFR 0.152.
 */
package ning.uploader;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreePath;
import ning.uploader.Cookie;
import ning.uploader.InformationPanel;
import ning.uploader.filebrowser.DirectoryContextListener;
import ning.uploader.filebrowser.FileChoiceListener;
import ning.uploader.filebrowser.FileSelectionListener;
import ning.uploader.filelist.FileList;
import ning.uploader.filetree.FileTree;
import ning.uploader.filetree.FileTreeCellRenderer;
import ning.uploader.filetree.FileTreeModel;
import ning.uploader.filetree.FileTreeSelectionModel;
import ning.uploader.filter.FileExtensionFilter;
import ning.uploader.info.FileInfoRenderer;
import ning.uploader.logging.Logger;
import ning.uploader.resources.Strings;
import ning.uploader.swing.FooterPanel;
import ning.uploader.swing.FourSidedBorder;
import ning.uploader.swing.HeaderPanel;

public class FileBrowserPanel
extends JPanel {
    private static final Logger log = Logger.getLogger(FileBrowserPanel.class);
    private static final String PATH_COOKIE = "xn_uploader_path";

    public FileBrowserPanel(Type type, FileExtensionFilter filter, FileInfoRenderer fileInfoRenderer, FileChoiceListener choiceListener) {
        super(new BorderLayout());
        File defaultDirectory;
        JPanel panelContainer = new JPanel(new BorderLayout());
        FourSidedBorder panelBorder = new FourSidedBorder(1, FooterPanel.BORDER_COLOR);
        panelBorder.setBottomColor(new Color(221, 221, 221));
        panelContainer.setBorder(panelBorder);
        panelContainer.add((Component)new HeaderPanel(Strings.FILE_BROWSER_HEADER.get()), "North");
        final InformationPanel infoPanel = new InformationPanel(fileInfoRenderer, type == Type.LIST_AUTO_EXPAND || type == Type.TREE_AUTO_EXPAND);
        FileSelectionListener selectionListener = new FileSelectionListener(){

            public void onFileSelectionChanged(File ... files) {
                infoPanel.setFiles(files);
            }
        };
        try {
            defaultDirectory = FileSystemView.getFileSystemView().getDefaultDirectory();
        }
        catch (Throwable t) {
            log.warn("Could not get default directory; using root instead", t);
            defaultDirectory = new File("/");
        }
        String path = Cookie.getCookie(PATH_COOKIE);
        if (path != null) {
            if (path.equals("")) {
                defaultDirectory = null;
            } else {
                File file = new File(path);
                if (!file.isDirectory()) {
                    file = file.getParentFile();
                }
                if (file.exists()) {
                    defaultDirectory = file;
                }
            }
        }
        if (type == Type.LIST || type == Type.LIST_AUTO_EXPAND) {
            FileList fileList = new FileList(filter);
            panelContainer.add((Component)fileList, "Center");
            if (defaultDirectory != null) {
                fileList.setDirectory(defaultDirectory);
            }
            fileList.addContextListener(new DirectoryContextListener(){

                public void onDirectoryContextChanged(File directory) {
                    Cookie.setPageCookie(FileBrowserPanel.PATH_COOKIE, directory == null ? "" : directory.getAbsolutePath());
                }
            });
            fileList.addSelectionListener(selectionListener);
            fileList.addChoiceListener(choiceListener);
        } else if (type == Type.TREE || type == Type.TREE_AUTO_EXPAND) {
            FileTreeModel model = new FileTreeModel(filter);
            FileTree fileTree = new FileTree(model);
            fileTree.setRootVisible(false);
            fileTree.setShowsRootHandles(true);
            fileTree.setCellRenderer(new FileTreeCellRenderer());
            fileTree.setSelectionModel(new FileTreeSelectionModel());
            JScrollPane fileTreeScrollPane = new JScrollPane(fileTree);
            fileTreeScrollPane.setBorder(BorderFactory.createEmptyBorder());
            panelContainer.add((Component)fileTreeScrollPane, "Center");
            TreePath homePath = model.getPathForFile(defaultDirectory);
            if (homePath != null) {
                fileTree.expandPath(homePath);
                fileTree.scrollPathToVisible(homePath);
            }
            fileTree.addSelectionListener(selectionListener);
            fileTree.addChoiceListener(choiceListener);
        }
        this.add((Component)panelContainer, "Center");
        this.add((Component)infoPanel, "South");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        TREE,
        TREE_AUTO_EXPAND,
        LIST,
        LIST_AUTO_EXPAND;

    }
}

